/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.internal.AbstractFieldSupport;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;

public abstract class AbstractCompositeField<C extends Component, S extends AbstractCompositeField<C, S, T>, T>
extends Composite<C>
implements HasValueAndElement<AbstractField.ComponentValueChangeEvent<S, T>, T>,
HasEnabled {
    private final AbstractFieldSupport<S, T> fieldSupport;

    public AbstractCompositeField(T defaultValue) {
        AbstractCompositeField thisAsS = this;
        this.fieldSupport = new AbstractFieldSupport<AbstractCompositeField, T>(thisAsS, defaultValue, this::valueEquals, this::setPresentationValue);
    }

    @Override
    public void setValue(T value) {
        this.fieldSupport.setValue(value);
    }

    @Override
    public T getValue() {
        return this.fieldSupport.getValue();
    }

    @Override
    public T getEmptyValue() {
        return this.fieldSupport.getEmptyValue();
    }

    @Override
    public boolean isEmpty() {
        return this.valueEquals(this.getValue(), this.getEmptyValue());
    }

    @Override
    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<S, T>> listener) {
        return this.fieldSupport.addValueChangeListener(listener);
    }

    protected abstract void setPresentationValue(T var1);

    protected void setModelValue(T newModelValue, boolean fromClient) {
        this.fieldSupport.setModelValue(newModelValue, fromClient);
    }

    protected boolean valueEquals(T value1, T value2) {
        return this.fieldSupport.valueEquals(value1, value2);
    }

    @Override
    public void bindValue(Signal<T> valueSignal, SerializableConsumer<T> writeCallback) {
        this.fieldSupport.bindValue(valueSignal, writeCallback);
    }
}

