/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SharedValueSignalHelperTest
extends SignalTestBase {
    @Test
    void updater_nullUpdater_throwsNullPointerException() {
        SharedValueSignal signal = new SharedValueSignal((Object)new ImmutablePerson("Alice", 30));
        Assertions.assertThrows(NullPointerException.class, () -> signal.updater(null));
    }

    @Test
    void updater_returnsCallback() {
        SharedValueSignal signal = new SharedValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        Assertions.assertNotNull((Object)callback);
    }

    @Test
    void updater_callbackUpdatesSignal() {
        SharedValueSignal signal = new SharedValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        callback.accept((Object)"Bob");
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)30, (int)((ImmutablePerson)signal.get()).age());
    }

    @Test
    void updater_multipleCallbackInvocations_updatesSignalEachTime() {
        SharedValueSignal signal = new SharedValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        callback.accept((Object)"Bob");
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        callback.accept((Object)"Charlie");
        Assertions.assertEquals((Object)"Charlie", (Object)((ImmutablePerson)signal.get()).name());
        callback.accept((Object)"Diana");
        Assertions.assertEquals((Object)"Diana", (Object)((ImmutablePerson)signal.get()).name());
    }

    @Test
    void updater_preservesOtherFields() {
        SharedValueSignal signal = new SharedValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer nameCallback = signal.updater(ImmutablePerson::withName);
        nameCallback.accept((Object)"Bob");
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)30, (int)((ImmutablePerson)signal.get()).age());
    }

    @Test
    void updater_withNullValue_works() {
        SharedValueSignal signal = new SharedValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer callback = signal.updater(ImmutablePerson::withName);
        callback.accept(null);
        Assertions.assertEquals(null, (Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)30, (int)((ImmutablePerson)signal.get()).age());
    }

    @Test
    void updater_multipleDifferentUpdaters_canBeCreated() {
        SharedValueSignal signal = new SharedValueSignal((Object)new ImmutablePerson("Alice", 30));
        SerializableConsumer nameCallback = signal.updater(ImmutablePerson::withName);
        SerializableConsumer ageCallback = signal.updater(ImmutablePerson::withAge);
        nameCallback.accept((Object)"Bob");
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)30, (int)((ImmutablePerson)signal.get()).age());
        ageCallback.accept((Object)35);
        Assertions.assertEquals((Object)"Bob", (Object)((ImmutablePerson)signal.get()).name());
        Assertions.assertEquals((int)35, (int)((ImmutablePerson)signal.get()).age());
    }

    record ImmutablePerson(String name, int age) {
        ImmutablePerson withName(String name) {
            return new ImmutablePerson(name, this.age);
        }

        ImmutablePerson withAge(int age) {
            return new ImmutablePerson(this.name, age);
        }
    }
}

