/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.RouteRegistryTestBase;
import jakarta.servlet.ServletContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ApplicationRouteRegistryTest
extends RouteRegistryTestBase {
    private ApplicationRouteRegistry registry;

    ApplicationRouteRegistryTest() {
    }

    @BeforeEach
    public void init() {
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext((ServletContext)Mockito.mock(ServletContext.class)));
    }

    @Test
    public void assertApplicationRegistry() {
        Assertions.assertEquals(ApplicationRouteRegistry.class, (Object)this.getTestedRegistry().getClass());
    }

    @Test
    public void updateRoutesFromMultipleThreads_allRoutesAreRegistered() throws InterruptedException, ExecutionException {
        ArrayList<Callable<Result>> callables = new ArrayList<Callable<Result>>();
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("home", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("info", RouteRegistryTestBase.MyInfo.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("palace", RouteRegistryTestBase.MyPalace.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Future resultFuture : futures) {
            Result result = (Result)resultFuture.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assertions.assertEquals((int)0, (int)exceptions.size(), (String)"No exceptions should have been thrown for threaded updates.");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("home").isPresent(), (String)"Route 'home' was not registered into the scope.");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("info").isPresent(), (String)"Route 'info' was not registered into the scope.");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("palace").isPresent(), (String)"Route 'palace' was not registered into the scope.");
    }

    @Test
    public void updateAndRemoveFromMultipleThreads_endResultAsExpected() throws InterruptedException, ExecutionException {
        this.getTestedRegistry().setRoute("home", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
        this.getTestedRegistry().setRoute("info", RouteRegistryTestBase.MyInfo.class, Collections.emptyList());
        ArrayList<Callable<Result>> callables = new ArrayList<Callable<Result>>();
        callables.add(() -> {
            try {
                this.getTestedRegistry().removeRoute("info");
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("modular", RouteRegistryTestBase.MyModular.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getTestedRegistry().setRoute("palace", RouteRegistryTestBase.MyPalace.class, Collections.emptyList());
                this.getTestedRegistry().removeRoute("home");
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Future resultFuture : futures) {
            Result result = (Result)resultFuture.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assertions.assertEquals((int)0, (int)exceptions.size(), (String)"No exceptions should have been thrown for threaded updates.");
        Assertions.assertFalse((boolean)this.getTestedRegistry().getNavigationTarget("home").isPresent(), (String)"Route 'home' was still registered even though it should have been removed.");
        Assertions.assertFalse((boolean)this.getTestedRegistry().getNavigationTarget("info").isPresent(), (String)"Route 'info' was still registered even though it should have been removed.");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("modular").isPresent(), (String)"Route 'modular' was not registered into the scope.");
        Assertions.assertTrue((boolean)this.getTestedRegistry().getNavigationTarget("palace").isPresent(), (String)"Route 'palace' was not registered into the scope.");
    }

    @Test
    public void lockingConfiguration_newConfigurationIsGottenOnlyAfterUnlock() {
        final CountDownLatch waitReaderThread = new CountDownLatch(1);
        final CountDownLatch waitUpdaterThread = new CountDownLatch(2);
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                ApplicationRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assertions.assertTrue((boolean)ApplicationRouteRegistryTest.this.getTestedRegistry().getRegisteredRoutes().isEmpty(), (String)"Registry should still remain empty");
                ApplicationRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assertions.assertTrue((boolean)ApplicationRouteRegistryTest.this.getTestedRegistry().getRegisteredRoutes().isEmpty(), (String)"Registry should still remain empty");
                waitReaderThread.countDown();
            }
        };
        readerThread.start();
        this.getTestedRegistry().update((Command & Serializable)() -> {
            this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            this.getTestedRegistry().setRoute("path", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            this.awaitCountDown(waitReaderThread);
        });
        Assertions.assertEquals((int)2, (int)this.getTestedRegistry().getRegisteredRoutes().size(), (String)"After unlock registry should be updated for others to configure with new data");
    }

    @Test
    public void routeChangeListener_correctChangesAreReturned() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.getTestedRegistry().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
        Assertions.assertFalse((boolean)added.isEmpty(), (String)"Added should contain data for one entry");
        Assertions.assertTrue((boolean)removed.isEmpty(), (String)"No routes should have been removed");
        Assertions.assertEquals(RouteRegistryTestBase.MyRoute.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assertions.assertEquals((Object)"", (Object)((RouteBaseData)added.get(0)).getTemplate());
        this.getTestedRegistry().setRoute("home", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
        Assertions.assertFalse((boolean)added.isEmpty(), (String)"Added should contain data for one entry");
        Assertions.assertEquals((int)1, (int)added.size(), (String)"Only latest change should be available");
        Assertions.assertTrue((boolean)removed.isEmpty(), (String)"No routes should have been removed");
        Assertions.assertEquals(RouteRegistryTestBase.Secondary.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assertions.assertEquals((Object)"home", (Object)((RouteBaseData)added.get(0)).getTemplate());
        this.getTestedRegistry().removeRoute("home");
        Assertions.assertTrue((boolean)added.isEmpty(), (String)"No routes should have been added");
        Assertions.assertFalse((boolean)removed.isEmpty(), (String)"One route should have gotten removed");
        Assertions.assertEquals(RouteRegistryTestBase.Secondary.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assertions.assertEquals((Object)"home", (Object)((RouteBaseData)removed.get(0)).getTemplate(), (String)"The 'home' route should have been removed");
    }

    @Test
    public void routeChangeListener_blockChangesAreGivenCorrectlyInEvent() {
        this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.emptyList());
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.getTestedRegistry().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.getTestedRegistry().update((Command & Serializable)() -> {
            this.getTestedRegistry().removeRoute("");
            this.getTestedRegistry().setRoute("path", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            this.getTestedRegistry().setRoute("", RouteRegistryTestBase.MyRoute.class, Collections.singletonList(RouteRegistryTestBase.MainLayout.class));
        });
        Assertions.assertFalse((boolean)added.isEmpty(), (String)"");
        Assertions.assertEquals((int)2, (int)added.size(), (String)"");
        Assertions.assertFalse((boolean)removed.isEmpty(), (String)"");
        for (RouteBaseData data : added) {
            if (data.getTemplate().equals("")) {
                Assertions.assertEquals(RouteRegistryTestBase.MyRoute.class, (Object)data.getNavigationTarget(), (String)"MyRoute should have been added");
                Assertions.assertEquals(RouteRegistryTestBase.MainLayout.class, (Object)data.getParentLayout(), (String)"MyRoute should have been seen as a update as the parent layouts changed.");
                continue;
            }
            Assertions.assertEquals(RouteRegistryTestBase.Secondary.class, (Object)data.getNavigationTarget(), (String)"");
        }
        Assertions.assertEquals(RouteRegistryTestBase.MyRoute.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget(), (String)"MyRoute should have been both removed and added");
        Assertions.assertEquals(Collections.emptyList(), (Object)((RouteBaseData)removed.get(0)).getParentLayouts(), (String)"Removed version should not have a parent layout");
    }

    @Test
    public void routeWithAliases_eventShowsCorrectlyAsRemoved() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.getTestedRegistry().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.getTestedRegistry().update((Command & Serializable)() -> {
            this.getTestedRegistry().setRoute("main", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            this.getTestedRegistry().setRoute("Alias1", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
            this.getTestedRegistry().setRoute("Alias2", RouteRegistryTestBase.Secondary.class, Collections.emptyList());
        });
        Assertions.assertEquals((int)3, (int)added.size(), (String)"Main route and aliases should all be seen as added.");
        Assertions.assertTrue((boolean)removed.isEmpty(), (String)"No routes should have been removed");
        this.getTestedRegistry().removeRoute("Alias2");
        Assertions.assertTrue((boolean)added.isEmpty(), (String)"No routes should have been added");
        Assertions.assertEquals((int)1, (int)removed.size(), (String)"Removing the alias route should be seen in the event");
    }

    @Test
    public void setErrorNavigationTargets_abstractClassesAreIgnored() {
        this.registry.setErrorNavigationTargets(new HashSet<Class>(Arrays.asList(RouteRegistryTestBase.ErrorView.class, RouteRegistryTestBase.AbstractErrorView.class)));
        Optional errorNavigationTarget = this.registry.getErrorNavigationTarget((Exception)new NullPointerException());
        Assertions.assertTrue((boolean)errorNavigationTarget.isPresent(), (String)"Error navigation target was not registered");
        Assertions.assertEquals(RouteRegistryTestBase.ErrorView.class, (Object)((ErrorTargetEntry)errorNavigationTarget.get()).getNavigationTarget(), (String)"Wrong errorNavigationTarget was registered");
    }

    @Override
    protected RouteRegistry getInitializationRegistry() {
        return this.registry;
    }

    @Override
    protected RouteRegistry getTestedRegistry() {
        return this.registry;
    }

    private void awaitCountDown(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Assertions.fail();
        }
    }

    private static class Result {
        final String value;

        Result(String value) {
            this.value = value;
        }
    }
}

