/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.ColorScheme;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.BootstrapInitialPredicate;
import com.vaadin.flow.server.BootstrapUrlPredicate;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.MockServletServiceSessionSetup;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.IndexHtmlRequestHandler;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinAppShellInitializerTest;
import com.vaadin.flow.theme.Theme;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import com.vaadin.tests.util.TestUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import tools.jackson.databind.node.ObjectNode;

public class IndexHtmlRequestHandlerTest {
    private static final String SPRING_CSRF_ATTRIBUTE_IN_SESSION = "org.springframework.security.web.csrf.CsrfToken";
    private static final String SPRING_CSRF_ATTRIBUTE = "_csrf";
    private static final String INITIAL_UIDL_SEARCH_STRING = "window.Vaadin.TypeScript= ";
    private MockServletServiceSessionSetup mocks;
    private MockServletServiceSessionSetup.TestVaadinServletService service;
    private VaadinSession session;
    private IndexHtmlRequestHandler indexHtmlRequestHandler;
    private VaadinResponse response;
    private ByteArrayOutputStream responseOutput;
    private MockDeploymentConfiguration deploymentConfiguration;
    private VaadinContext context;
    private String springTokenString;
    private final String springTokenHeaderName = "x-CSRF-TOKEN";
    private final String springTokenParamName = "org.springframework.security.web.csrf.CsrfToken";
    @TempDir
    Path temporaryFolder;
    private static final Pattern UUID_PATTERN = Pattern.compile("\"token\":\"[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}\"");

    @BeforeEach
    public void setUp() throws Exception {
        UsageStatistics.resetEntries();
        this.mocks = new MockServletServiceSessionSetup();
        this.service = this.mocks.getService();
        this.session = this.mocks.getSession();
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.responseOutput = new ByteArrayOutputStream();
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)this.responseOutput);
        this.deploymentConfiguration = this.mocks.getDeploymentConfiguration();
        this.deploymentConfiguration.setProductionMode(true);
        this.indexHtmlRequestHandler = new IndexHtmlRequestHandler();
        this.context = this.service.getContext();
        this.springTokenString = UUID.randomUUID().toString();
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)((ApplicationConfiguration)this.context.getAttribute(ApplicationConfiguration.class))).thenReturn((Object)applicationConfiguration);
        MenuRegistry.clearFileRoutesCache();
    }

    @Test
    public void serveIndexHtml_requestWithRootPath_serveContentFromTemplate() throws IOException {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)indexHtml.contains("index.html template content"), (String)"Response should have content from the index.html template");
        Assertions.assertTrue((boolean)indexHtml.contains(".v-system-error"), (String)"Response should have styles for the system-error dialogs");
    }

    @Test
    public void serveNotFoundIndexHtml_requestWithRootPath_failsWithIOException() throws IOException {
        VaadinServletService vaadinService = (VaadinServletService)Mockito.mock(VaadinServletService.class);
        Mockito.when((Object)vaadinService.getDeploymentConfiguration()).thenReturn((Object)this.deploymentConfiguration);
        Mockito.when((Object)vaadinService.getContext()).thenReturn((Object)this.context);
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        ResourceProvider resourceProvider = (ResourceProvider)Mockito.mock(ResourceProvider.class);
        Mockito.when((Object)((Lookup)this.context.getAttribute(Lookup.class))).thenReturn((Object)lookup);
        Mockito.when((Object)((ResourceProvider)lookup.lookup(ResourceProvider.class))).thenReturn((Object)resourceProvider);
        URL resource = (URL)Mockito.mock(URL.class);
        Mockito.when((Object)resourceProvider.getApplicationResource("META-INF/VAADIN/webapp/index.html")).thenReturn((Object)resource);
        Mockito.when((Object)resource.openStream()).thenReturn(null);
        VaadinServletRequest vaadinRequest = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)vaadinRequest.getService()).thenReturn((Object)vaadinService);
        String expectedError = "java.io.IOException: Unable to find index.html. It should be available on the classpath when running in production mode";
        UncheckedIOException expectedException = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)vaadinRequest, this.response));
        Assertions.assertEquals((Object)expectedError, (Object)expectedException.getMessage());
    }

    @Test
    public void serveIndexHtml_language_attribute_is_present() throws IOException {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)indexHtml.contains("<html lang"), (String)"Response should have a language attribute");
    }

    @Test
    public void serveIndexHtml_requestWithRootPath_hasBaseHrefElement() throws IOException {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)indexHtml.contains("<base href=\".\""), (String)"Response should have correct base href");
    }

    @Test
    public void serveIndexHtml_requestWithSomePath_hasBaseHrefElement() throws IOException {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/some/path"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)indexHtml.contains("<base href=\"./..\""), (String)"Response should have correct base href");
    }

    @Test
    public void serveIndexHtml_featureFlagsSetter_isPresent() throws IOException {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Assertions.assertTrue((boolean)indexHtml.contains("window.Vaadin.featureFlagsUpdaters.push((activator) => {"), (String)"Response should have Feature Flags updater function");
    }

    @Test
    public void canHandleRequest_requestWithRootPath_handleRequest() {
        boolean canHandleRequest = this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/"));
        Assertions.assertTrue((boolean)canHandleRequest, (String)"The handler should handle a root path request");
    }

    @Test
    public void canHandleRequest_withoutBootstrapUrlPredicate() {
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/nested/picture.png")));
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/nested/CAPITAL.PNG")));
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("com.foo.MyTest")));
    }

    @Test
    public void canHandleRequest_withBootstrapUrlPredicate() {
        this.service.setBootstrapUrlPredicate((BootstrapUrlPredicate & Serializable)req -> !req.getPathInfo().matches(".+\\.[A-z][A-z\\d]+$"));
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/some/route")), (String)"The handler should handle a route with parameter");
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/myroute")), (String)"The handler should handle a normal route");
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/myroute/ends/withslash/")), (String)"The handler should handle a directory request");
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/documentation/10.0.x1/flow")), (String)"The handler should handle a request if it has extension pattern in the middle of the path");
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/nested/picture.png")), (String)"The handler should not handle request with extension");
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/nested/CAPITAL.PNG")), (String)"The handler should not handle request with capital extension");
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/script.js")), (String)"The handler should not handle request with extension");
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/music.mp3")), (String)"The handler should not handle request with extension");
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createVaadinRequest("/.htaccess")), (String)"The handler should not handle request with only extension");
    }

    @Test
    public void canHandleRequest_allow_oldBrowser() {
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createRequestWithDestination("/", null, null)));
    }

    @Test
    public void canHandleRequest_handle_indexHtmlRequest() {
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createRequestWithDestination("/", "document", "navigate")));
    }

    @Test
    public void canHandleRequest_doNotHandle_scriptRequest() {
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createRequestWithDestination("/", "script", "no-cors")));
    }

    @Test
    public void canHandleRequest_doNotHandle_imageRequest() {
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createRequestWithDestination("/", "image", "no-cors")));
    }

    @Test
    public void canHandleRequest_doNotHandle_vaadinStaticResources() {
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createRequestWithDestination("/VAADIN/foo.js", null, null)));
    }

    @Test
    public void canHandleRequest_doNotHandle_vaadinReservedFolders() {
        for (String reservedFolder : HandlerHelper.getPublicInternalFolderPaths()) {
            Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createRequestWithDestination(reservedFolder, null, null)), (String)(reservedFolder + " was handled even though it should not init index handler"));
        }
    }

    @Test
    public void canHandleRequest_handle_serviceWorkerDocumentRequest() {
        Assertions.assertTrue((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)this.createRequestWithDestination("/", "empty", "same-origin")));
    }

    @Test
    public void bootstrapListener_addListener_responseIsModified() throws IOException {
        this.service.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)evt -> evt.getDocument().head().getElementsByTag("script").remove());
        this.service.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)evt -> evt.getDocument().head().appendElement("script").attr("src", "testing.1"));
        this.service.addIndexHtmlRequestListener((IndexHtmlRequestListener & Serializable)evt -> evt.getDocument().head().appendElement("script").attr("src", "testing.2"));
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements scripts = document.head().getElementsByTag("script");
        int expectedScripts = 2;
        Assertions.assertEquals((int)expectedScripts, (int)scripts.size());
        Assertions.assertEquals((Object)"testing.1", (Object)((Element)scripts.get(expectedScripts - 2)).attr("src"));
        Assertions.assertEquals((Object)"testing.2", (Object)((Element)scripts.get(expectedScripts - 1)).attr("src"));
    }

    @Test
    public void should_add_initialUidl_when_includeInitialBootstrapUidl() throws IOException {
        this.deploymentConfiguration.setEagerServerLoad(true);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements scripts = document.head().getElementsByTag("script");
        Element initialUidlScript = IndexHtmlRequestHandlerTest.findScript(scripts, INITIAL_UIDL_SEARCH_STRING);
        Assertions.assertEquals((Object)"", (Object)initialUidlScript.attr("initial"));
    }

    private static Element findScript(Elements scripts, String needle) {
        for (Element script : scripts) {
            if (!script.toString().contains(needle)) continue;
            return script;
        }
        return null;
    }

    @Test
    public void should_not_add_initialUidl_when_not_includeInitialBootstrapUidl() throws IOException {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements scripts = document.head().getElementsByTag("script");
        Element initialUidlScript = IndexHtmlRequestHandlerTest.findScript(scripts, INITIAL_UIDL_SEARCH_STRING);
        Assertions.assertEquals((Object)"window.Vaadin = window.Vaadin || {};window.Vaadin.TypeScript= {};", (Object)initialUidlScript.childNode(0).toString());
        Assertions.assertEquals((Object)"", (Object)initialUidlScript.attr("initial"));
    }

    @Test
    public void should_initialize_UI_and_add_initialUidl_when_valid_route() throws IOException {
        this.deploymentConfiguration.setEagerServerLoad(true);
        this.service.setBootstrapInitialPredicate((BootstrapInitialPredicate & Serializable)request -> request.getPathInfo().equals("/"));
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements scripts = document.head().getElementsByTag("script");
        Element initialUidlScript = IndexHtmlRequestHandlerTest.findScript(scripts, INITIAL_UIDL_SEARCH_STRING);
        Assertions.assertEquals((Object)"", (Object)initialUidlScript.attr("initial"));
        String scriptContent = initialUidlScript.toString();
        Assertions.assertTrue((boolean)scriptContent.contains("Could not navigate"));
        Assertions.assertFalse((scriptContent.contains("&lt;") || scriptContent.contains("&gt;") ? 1 : 0) != 0, (String)"Initial object content should not be escaped");
        Assertions.assertNotNull((Object)UI.getCurrent());
    }

    @Test
    public void should_not_initialize_UI_and_add_initialUidl_when_invalid_route() throws IOException {
        this.deploymentConfiguration.setEagerServerLoad(true);
        this.service.setBootstrapInitialPredicate((BootstrapInitialPredicate & Serializable)request -> request.getPathInfo().equals("/"));
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/foo"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements scripts = document.head().getElementsByTag("script");
        Element initialUidlScript = IndexHtmlRequestHandlerTest.findScript(scripts, INITIAL_UIDL_SEARCH_STRING);
        Assertions.assertEquals((Object)"window.Vaadin = window.Vaadin || {};window.Vaadin.TypeScript= {};", (Object)initialUidlScript.childNode(0).toString());
        Assertions.assertEquals((Object)"", (Object)initialUidlScript.attr("initial"));
        Assertions.assertNull((Object)UI.getCurrent());
    }

    @Test
    public void should_getter_UI_return_not_empty_when_includeInitialBootstrapUidl() throws IOException {
        this.deploymentConfiguration.setEagerServerLoad(true);
        VaadinServletRequest request = this.createVaadinRequest("/");
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)request, this.response);
        ArgumentCaptor captor = ArgumentCaptor.forClass(IndexHtmlResponse.class);
        ((VaadinService)Mockito.verify((Object)request.getService())).modifyIndexHtmlResponse((IndexHtmlResponse)captor.capture());
        Assertions.assertNotNull((Object)((IndexHtmlResponse)captor.getValue()).getUI());
    }

    @Test
    public void eagerServerLoad_requestParameters_forwardedToLocationObject() throws IOException {
        this.deploymentConfiguration.setEagerServerLoad(true);
        HashMap<String, String[]> requestParams = new HashMap<String, String[]>();
        requestParams.put("param1", new String[]{"a", "b"});
        requestParams.put("param2", new String[]{"2"});
        VaadinServletRequest request = this.createVaadinRequest("/view");
        Mockito.when((Object)request.getHttpServletRequest().getParameterMap()).thenReturn(requestParams);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)request, this.response);
        ArgumentCaptor captor = ArgumentCaptor.forClass(IndexHtmlResponse.class);
        ((VaadinServletService)Mockito.verify((Object)request.getService())).modifyIndexHtmlResponse((IndexHtmlResponse)captor.capture());
        Optional maybeUI = ((IndexHtmlResponse)captor.getValue()).getUI();
        Assertions.assertNotNull((Object)maybeUI);
        QueryParameters locationParams = ((UI)maybeUI.get()).getActiveViewLocation().getQueryParameters();
        Assertions.assertEquals(List.of("a", "b"), (Object)locationParams.getParameters("param1"));
        Assertions.assertEquals(List.of("2"), (Object)locationParams.getParameters("param2"));
    }

    @Test
    public void should_getter_UI_return_empty_when_not_includeInitialBootstrapUidl() throws IOException {
        VaadinServletRequest request = this.createVaadinRequest("/");
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)request, this.response);
        ArgumentCaptor captor = ArgumentCaptor.forClass(IndexHtmlResponse.class);
        ((VaadinService)Mockito.verify((Object)request.getService())).modifyIndexHtmlResponse((IndexHtmlResponse)captor.capture());
        Assertions.assertEquals(Optional.empty(), (Object)((IndexHtmlResponse)captor.getValue()).getUI());
    }

    @Test
    public void should_include_spring_csrf_token_in_meta_tags_when_return_not_null_spring_csrf_in_request() throws IOException {
        VaadinRequest request = this.createVaadinRequestWithSpringCsrfToken();
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, request, this.response);
        this.assertSpringCsrfTokenIsAvailableAsMetaTagsInDom();
    }

    @Test
    public void should_not_include_token_in_dom_when_return_null_csrfToken_in_session() throws IOException {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements scripts = document.head().getElementsByTag("script");
        Element initialUidlScript = IndexHtmlRequestHandlerTest.findScript(scripts, INITIAL_UIDL_SEARCH_STRING);
        Assertions.assertFalse((boolean)initialUidlScript.childNode(0).toString().contains("window.Vaadin = {Flow: {\"csrfToken\":"));
        Assertions.assertEquals((Object)"", (Object)initialUidlScript.attr("initial"));
    }

    @Test
    public void should_not_include_spring_csrf_token_in_meta_tags_when_return_null_spring_csrf_in_request() throws IOException {
        VaadinServletRequest request = this.createVaadinRequest("/");
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)request, this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Assertions.assertEquals((int)0, (int)document.head().getElementsByAttribute(SPRING_CSRF_ATTRIBUTE).size());
        Assertions.assertEquals((int)0, (int)document.head().getElementsByAttribute("_csrf_header").size());
    }

    @Test
    public void should_include_spring_token_in_dom_when_referer_is_service_worker() throws IOException {
        VaadinRequest request = this.createVaadinRequestWithSpringCsrfToken();
        Mockito.when((Object)request.getHeader("referer")).thenReturn((Object)"http://somewhere.test/sw.js");
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, request, this.response);
        this.assertSpringCsrfTokenIsAvailableAsMetaTagsInDom();
    }

    @Test
    public void should_not_add_metaElements_when_not_appShellPresent() throws Exception {
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements elements = document.head().getElementsByTag("meta");
        Assertions.assertEquals((int)2, (int)elements.size());
    }

    @Test
    public void should_add_metaAndPwa_Inline_Elements_when_appShellPresent() throws Exception {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(VaadinAppShellInitializerTest.AppShellWithPWA.class);
        this.mocks.setAppShellRegistry(registry);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements elements = document.head().getElementsByTag("meta");
        Assertions.assertEquals((int)8, (int)elements.size());
        Optional<Element> viewPort = this.findFirstElementByNameAttrEqualTo(elements, "viewport");
        Assertions.assertTrue((boolean)viewPort.isPresent(), (String)"'viewport' meta link should exist.");
        Assertions.assertEquals((Object)"my-viewport", (Object)viewPort.get().attr("content"));
        Optional<Element> appleMobileWebAppCapable = this.findFirstElementByNameAttrEqualTo(elements, "apple-mobile-web-app-capable");
        Assertions.assertTrue((boolean)appleMobileWebAppCapable.isPresent(), (String)"'apple-mobile-web-app-capable' meta link should exist.");
        Assertions.assertEquals((Object)"yes", (Object)appleMobileWebAppCapable.get().attr("content"));
        Optional<Element> themeColor = this.findFirstElementByNameAttrEqualTo(elements, "theme-color");
        Assertions.assertTrue((boolean)themeColor.isPresent(), (String)"'theme-color' meta link should exists.");
        Assertions.assertEquals((Object)"#ffffff", (Object)themeColor.get().attr("content"));
        Optional<Element> appleMobileWebAppStatusBar = this.findFirstElementByNameAttrEqualTo(elements, "apple-mobile-web-app-status-bar-style");
        Assertions.assertTrue((boolean)appleMobileWebAppStatusBar.isPresent(), (String)"'apple-mobile-web-app-status-bar-style' meta link should exists.");
        Assertions.assertEquals((Object)"#ffffff", (Object)appleMobileWebAppStatusBar.get().attr("content"));
        Optional<Element> mobileWebAppCapableElements = this.findFirstElementByNameAttrEqualTo(elements, "mobile-web-app-capable");
        Assertions.assertTrue((boolean)mobileWebAppCapableElements.isPresent(), (String)"'mobile-web-app-capable' meta link should exists.");
        Assertions.assertEquals((Object)"yes", (Object)mobileWebAppCapableElements.get().attr("content"));
        Optional<Element> appleTouchFullScreenElements = this.findFirstElementByNameAttrEqualTo(elements, "apple-touch-fullscreen");
        Assertions.assertTrue((boolean)appleTouchFullScreenElements.isPresent(), (String)"'apple-touch-fullscreen' meta link should exist.");
        Assertions.assertEquals((Object)"yes", (Object)appleTouchFullScreenElements.get().attr("content"));
        Optional<Element> appleMobileWebAppTitleElements = this.findFirstElementByNameAttrEqualTo(elements, "apple-mobile-web-app-title");
        Assertions.assertTrue((boolean)appleMobileWebAppTitleElements.isPresent(), (String)"'apple-mobile-web-app-title' should exist.");
        Assertions.assertEquals((Object)"n", (Object)appleMobileWebAppTitleElements.get().attr("content"));
        Elements headInlineAndStyleElements = document.head().getElementsByTag("style");
        Assertions.assertEquals((int)3, (int)headInlineAndStyleElements.size());
        Assertions.assertEquals((Object)"[hidden] { display: none !important; }", (Object)((Element)headInlineAndStyleElements.get(1)).childNode(0).toString());
        Assertions.assertEquals((Object)"text/css", (Object)((Element)headInlineAndStyleElements.get(2)).attr("type"));
        Assertions.assertEquals((Object)"body,#outlet{width:my-width;height:my-height;}", (Object)((Element)headInlineAndStyleElements.get(2)).childNode(0).toString());
    }

    @Test
    public void should_add_elements_when_appShellWithConfigurator() throws Exception {
        File projectRootFolder = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
        TestUtil.createIndexHtmlStub(projectRootFolder);
        TestUtil.createStatsJsonStub(projectRootFolder);
        this.deploymentConfiguration.setProductionMode(false);
        this.deploymentConfiguration.setProjectFolder(projectRootFolder);
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(VaadinAppShellInitializerTest.MyAppShellWithConfigurator.class);
        this.mocks.setAppShellRegistry(registry);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements elements = document.head().getElementsByTag("meta");
        Assertions.assertEquals((int)4, (int)elements.size());
        Assertions.assertEquals((Object)"UTF-8", (Object)((Element)elements.get(0)).attr("charset"));
        Assertions.assertEquals((Object)"viewport", (Object)((Element)elements.get(1)).attr("name"));
        Assertions.assertEquals((Object)"my-viewport", (Object)((Element)elements.get(1)).attr("content"));
        Assertions.assertEquals((Object)"foo", (Object)((Element)elements.get(2)).attr("name"));
        Assertions.assertEquals((Object)"bar", (Object)((Element)elements.get(2)).attr("content"));
        Assertions.assertEquals((Object)"lorem", (Object)((Element)elements.get(3)).attr("name"));
        Assertions.assertEquals((Object)"ipsum", (Object)((Element)elements.get(3)).attr("content"));
        Assertions.assertEquals((Object)"my-title", (Object)((Element)document.head().getElementsByTag("title").get(0)).childNode(0).toString());
        Elements headInlineAndStyleElements = document.head().getElementsByTag("style");
        Assertions.assertEquals((int)4, (int)headInlineAndStyleElements.size());
        Assertions.assertEquals((Object)"[hidden] { display: none !important; }", (Object)((Element)headInlineAndStyleElements.get(2)).childNode(0).toString());
        Assertions.assertEquals((Object)"text/css", (Object)((Element)headInlineAndStyleElements.get(3)).attr("type"));
        Assertions.assertEquals((Object)"body,#outlet{width:my-width;height:my-height;}", (Object)((Element)headInlineAndStyleElements.get(3)).childNode(0).toString());
        Elements bodyInlineElements = document.body().getElementsByTag("script");
        Assertions.assertEquals((int)2, (int)bodyInlineElements.size());
    }

    @Test
    public void should_export_usage_statistics_in_development_mode() throws IOException {
        File projectRootFolder = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
        TestUtil.createIndexHtmlStub(projectRootFolder);
        TestUtil.createStatsJsonStub(projectRootFolder);
        this.deploymentConfiguration.setProductionMode(false);
        this.deploymentConfiguration.setProjectFolder(projectRootFolder);
        VaadinServletRequest request = this.createVaadinRequest("/");
        Mockito.when((Object)request.getHttpServletRequest().getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)request, this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements bodyInlineElements = document.body().getElementsByTag("script");
        Assertions.assertEquals((int)1, (int)bodyInlineElements.size());
        String entries = UsageStatistics.getEntries().map(entry -> {
            ObjectNode json = JacksonUtils.createObjectNode();
            json.put("is", entry.getName());
            json.put("version", entry.getVersion());
            return json.toString();
        }).collect(Collectors.joining(","));
        String expected = StringUtil.normaliseWhitespace((String)("window.Vaadin = window.Vaadin || {}; window.Vaadin.registrations = window.Vaadin.registrations || [];\nwindow.Vaadin.registrations.push(" + entries + ");"));
        Assertions.assertTrue((boolean)IndexHtmlRequestHandlerTest.isTokenPresent(indexHtml));
        String htmlContent = ((Element)bodyInlineElements.get(0)).childNode(0).outerHtml();
        htmlContent = htmlContent.replace("\r", "");
        htmlContent = htmlContent.replace("\n", " ");
        Assertions.assertEquals((Object)StringUtil.normaliseWhitespace((String)expected), (Object)htmlContent);
    }

    private static boolean isTokenPresent(String htmlContent) {
        Matcher matcher = UUID_PATTERN.matcher(htmlContent);
        return matcher.find();
    }

    @Test
    public void devTools_disable_stubPushFunctionRegistered() throws IOException {
        File projectRootFolder = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
        TestUtil.createIndexHtmlStub(projectRootFolder);
        TestUtil.createStatsJsonStub(projectRootFolder);
        this.deploymentConfiguration.setDevToolsEnabled(false);
        this.deploymentConfiguration.setProductionMode(false);
        this.deploymentConfiguration.setProjectFolder(projectRootFolder);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Assertions.assertTrue((boolean)document.head().getElementsByTag("script").stream().map(Element::html).anyMatch(script -> script.contains("window.Vaadin.devToolsPlugins = {") && script.contains("push: function(plugin) {")), (String)"Expected devToolsPlugins.push function when dev-tools are disabled");
    }

    @Test
    public void should_NOT_export_usage_statistics_in_production_mode() throws IOException {
        this.deploymentConfiguration.setProductionMode(true);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements bodyInlineElements = document.body().getElementsByTag("script");
        Assertions.assertEquals((int)1, (int)bodyInlineElements.size());
    }

    @Test
    public void should_apply_theme_variant() throws IOException {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(ClassWithDarkLumo.class);
        this.mocks.setAppShellRegistry(registry);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Assertions.assertEquals((Object)"dark", (Object)document.head().parent().attr("theme"));
    }

    @Test
    public void should_apply_colorScheme_dark() throws IOException {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(ClassWithDarkColorScheme.class);
        this.mocks.setAppShellRegistry(registry);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Assertions.assertEquals((Object)"dark", (Object)document.head().parent().attr("theme"));
        Assertions.assertEquals((Object)"color-scheme: dark;", (Object)document.head().parent().attr("style"));
    }

    @Test
    public void should_apply_colorScheme_lightDark() throws IOException {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(ClassWithLightDarkColorScheme.class);
        this.mocks.setAppShellRegistry(registry);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Assertions.assertEquals((Object)"light-dark", (Object)document.head().parent().attr("theme"));
        Assertions.assertEquals((Object)"color-scheme: light dark;", (Object)document.head().parent().attr("style"));
    }

    @Test
    public void should_not_apply_colorScheme_normal() throws IOException {
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(ClassWithNormalColorScheme.class);
        this.mocks.setAppShellRegistry(registry);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Assertions.assertEquals((Object)"", (Object)document.head().parent().attr("theme"));
        Assertions.assertEquals((Object)"", (Object)document.head().parent().attr("style"));
    }

    @Test
    public void should_append_colorScheme_to_existing_style() throws IOException {
        File projectRootFolder = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
        String indexHtmlWithStyle = "<!DOCTYPE html>\n<html style=\"--custom-prop: value;\">\n<head>\n  <meta charset=\"UTF-8\" />\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\" />\n</head>\n<body>\n  <div id=\"outlet\"></div>\n</body>\n</html>\n";
        File frontendDir = new File(projectRootFolder, "frontend");
        frontendDir.mkdirs();
        File indexHtml = new File(frontendDir, "index.html");
        Files.writeString(indexHtml.toPath(), (CharSequence)indexHtmlWithStyle, new OpenOption[0]);
        TestUtil.createStatsJsonStub(projectRootFolder);
        this.deploymentConfiguration.setProductionMode(false);
        this.deploymentConfiguration.setProjectFolder(projectRootFolder);
        AppShellRegistry registry = AppShellRegistry.getInstance((VaadinContext)this.context);
        registry.setShell(ClassWithDarkColorScheme.class);
        this.mocks.setAppShellRegistry(registry);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtmlOutput = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtmlOutput);
        Assertions.assertEquals((Object)"dark", (Object)document.head().parent().attr("theme"));
        Assertions.assertEquals((Object)"--custom-prop: value; color-scheme: dark;", (Object)document.head().parent().attr("style"));
    }

    @Test
    public void should_store_IndexHtmltitleToUI_When_LoadingServerEagerly() throws IOException {
        this.deploymentConfiguration.setEagerServerLoad(true);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        Assertions.assertEquals((Object)"Flow Test CCDM", (Object)UI.getCurrent().getInternals().getAppShellTitle());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.session.unlock();
        this.mocks.cleanup();
    }

    private Optional<Element> findFirstElementByNameAttrEqualTo(Elements elements, String name) {
        return elements.stream().filter(element -> name.equals(element.attr("name"))).findFirst();
    }

    private VaadinServletRequest createRequestWithDestination(String pathInfo, String fetchDest, String fetchMode) {
        VaadinServletRequest req = this.createVaadinRequest(pathInfo);
        Mockito.when((Object)req.getHeader(Mockito.anyString())).thenAnswer(arg -> {
            if ("Sec-Fetch-Dest".equals(arg.getArgument(0))) {
                return fetchDest;
            }
            if ("Sec-Fetch-Mode".equals(arg.getArgument(0))) {
                return fetchMode;
            }
            return null;
        });
        return req;
    }

    private VaadinServletRequest createVaadinRequest(String pathInfo) {
        HttpServletRequest request = this.createRequest(pathInfo);
        return new VaadinServletRequest(request, (VaadinServletService)Mockito.spy((Object)((Object)this.service)));
    }

    private HttpServletRequest createRequest(String pathInfo) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doAnswer(invocation -> "").when((Object)request)).getServletPath();
        ((HttpServletRequest)Mockito.doAnswer(invocation -> pathInfo).when((Object)request)).getPathInfo();
        ((HttpServletRequest)Mockito.doAnswer(invocation -> new StringBuffer(pathInfo)).when((Object)request)).getRequestURL();
        return request;
    }

    @Test
    public void internal_request_no_bootstrap_page() {
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)request.getPathInfo()).thenReturn(null);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)"hello-foo-bar");
        Assertions.assertTrue((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)request));
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)"init");
        Assertions.assertTrue((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
        Assertions.assertFalse((boolean)this.indexHtmlRequestHandler.canHandleRequest((VaadinRequest)request));
    }

    @Test
    public void synchronizedHandleRequest_badLocation_noUiCreated() throws IOException {
        IndexHtmlRequestHandler bootstrapHandler = new IndexHtmlRequestHandler();
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        ((VaadinServletRequest)Mockito.doAnswer(invocation -> "..**").when((Object)request)).getPathInfo();
        MockServletServiceSessionSetup.TestVaadinServletResponse response = this.mocks.createResponse();
        boolean value = bootstrapHandler.synchronizedHandleRequest(this.mocks.getSession(), (VaadinRequest)request, (VaadinResponse)response);
        Assertions.assertTrue((boolean)value, (String)"No further request handlers should be called");
        Assertions.assertEquals((int)400, (int)response.getErrorCode(), (String)"Invalid status code reported");
        Assertions.assertEquals((Object)"Invalid location: Relative path cannot contain .. segments", (Object)response.getErrorMessage(), (String)"Invalid message reported");
    }

    @Test
    public void serviceWorkerRequest_canNotHandleRequest() {
        IndexHtmlRequestHandler bootstrapHandler = new IndexHtmlRequestHandler();
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        Mockito.when((Object)request.getHeader("Service-Worker")).thenReturn((Object)"script");
        Assertions.assertFalse((boolean)bootstrapHandler.canHandleRequest((VaadinRequest)request));
    }

    @Test
    public void servingStylesCss_productionMode_noLinkTagAdded() throws IOException {
        File projectRootFolder = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
        this.deploymentConfiguration.setProductionMode(true);
        this.deploymentConfiguration.setProjectFolder(projectRootFolder);
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements linkElements = document.head().getElementsByTag("link");
        Assertions.assertEquals((int)0, (int)linkElements.size());
    }

    private VaadinRequest createVaadinRequestWithSpringCsrfToken() {
        VaadinRequest request = (VaadinRequest)Mockito.spy((Object)this.createVaadinRequest("/"));
        HashMap<String, String> csrfJsonMap = new HashMap<String, String>();
        csrfJsonMap.put("token", this.springTokenString);
        csrfJsonMap.put("headerName", "x-CSRF-TOKEN");
        csrfJsonMap.put("parameterName", SPRING_CSRF_ATTRIBUTE_IN_SESSION);
        Mockito.when((Object)request.getAttribute(SPRING_CSRF_ATTRIBUTE_IN_SESSION)).thenReturn(csrfJsonMap);
        return request;
    }

    private void assertSpringCsrfTokenIsAvailableAsMetaTagsInDom() {
        try {
            String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
            Document document = Jsoup.parse((String)indexHtml);
            Elements csrfMetaEelement = document.head().getElementsByAttributeValue("name", SPRING_CSRF_ATTRIBUTE);
            Assertions.assertEquals((int)1, (int)csrfMetaEelement.size());
            Assertions.assertEquals((Object)this.springTokenString, (Object)csrfMetaEelement.first().attr("content"));
            Elements csrfHeaderMetaElement = document.head().getElementsByAttributeValue("name", "_csrf_header");
            Assertions.assertEquals((int)1, (int)csrfHeaderMetaElement.size());
            Assertions.assertEquals((Object)"x-CSRF-TOKEN", (Object)csrfHeaderMetaElement.first().attr("content"));
            Elements csrfParameterMetaElement = document.head().getElementsByAttributeValue("name", "_csrf_parameter");
            Assertions.assertEquals((int)1, (int)csrfParameterMetaElement.size());
            Assertions.assertEquals((Object)SPRING_CSRF_ATTRIBUTE_IN_SESSION, (Object)csrfParameterMetaElement.first().attr("content"));
        }
        catch (Exception e) {
            Assertions.fail((String)"Unable to parse the index html page");
        }
    }

    private boolean isAllowedDevToolsHost(String hostsAllowedProperty, String remoteAddr) {
        return this.isAllowedDevToolsHost(hostsAllowedProperty, remoteAddr, (List<String>)null);
    }

    private boolean isAllowedDevToolsHost(String hostsAllowedProperty, String remoteAddr, String forwardedForHeader) {
        return this.isAllowedDevToolsHost(hostsAllowedProperty, remoteAddr, Collections.singletonList(forwardedForHeader));
    }

    private boolean isAllowedDevToolsHost(String hostsAllowedProperty, String remoteAddr, List<String> forwardedForHeader) {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)remoteAddr);
        ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        ((ApplicationConfiguration)Mockito.doAnswer(q -> hostsAllowedProperty).when((Object)configuration)).getStringProperty("devmode.hostsAllowed", null);
        if (forwardedForHeader == null) {
            Mockito.when((Object)request.getHeader("X-Forwarded-For")).thenReturn(null);
            Mockito.when((Object)request.getHeaders("X-Forwarded-For")).thenReturn(Collections.emptyEnumeration());
        } else {
            Mockito.when((Object)request.getHeader("X-Forwarded-For")).thenReturn((Object)forwardedForHeader.get(0));
            Mockito.when((Object)request.getHeaders("X-Forwarded-For")).thenReturn(Collections.enumeration(forwardedForHeader));
        }
        return IndexHtmlRequestHandler.isAllowedDevToolsHost((AbstractConfiguration)configuration, (VaadinRequest)request);
    }

    @Test
    public void devTools_loopbackAllowedByDefault() {
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost(null, "0:0:0:0:0:0:0:1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost(null, "::1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("", "127.0.0.1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("", "0:0:0:0:0:0:0:1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("", "::1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("   ", "0:0:0:0:0:0:0:1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("   ", "::1"));
    }

    @Test
    public void devTools_externalOrNoIpDeniedByDefault() {
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "192.168.1.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, null));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "192.168.1.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", null));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "192.168.1.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", null));
    }

    @Test
    public void devTools_allowedHostsMatchesIp() {
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("192.168.1.*", "192.168.1.1"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("192.168.1.*", "192.168.1.100"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("192.168.1.*", "192.168.100.100"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("192.168.1.*", "127.0.0.1"));
    }

    @Test
    public void devTools_allowedHostsMatchesIpAndForwardedFor() {
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("  ", "127.0.0.1", "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", "1.2.3.4, 3.4.5.6"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "1.2.3.4, 3.4.5.6"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", "1.2.3.4, 3.4.5.6"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4", "5.5.5.5", "1.2.3.4, 3.4.5.6"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4", "127.0.0.1", "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4", "127.0.0.1", "1.2.3.4, 3.4.5.6"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4", "127.0.0.1", "   1.2.3.4 , 3.4.5.6   "));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4,3.4.5.6", "127.0.0.1", "1.2.3.4, 3.4.5.6"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4,3.4.5.6", "127.0.0.1", "   1.2.3.4 , 3.4.5.6   "));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4, 5.5.5.5", "5.5.5.5", "   1.2.3.4    "));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4,5.5.*", "5.5.5.5", "1.2.3.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4,5.5.*", "5.5.5.5", "1.2.3.4, 3.4.5.6"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4,5.5.*", "5.5.5.5", "   1.2.3.4 , 3.4.5.6   "));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4,3.4.5.6,5.5.*", "5.5.5.5", "1.2.3.4, 3.4.5.6"));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4,3.4.5.6,5.5.*", "5.5.5.5", "   1.2.3.4 , 3.4.5.6   "));
        String forwardedChain = "1.2.3.4,5.5.5.5,6.6.6.6,7.7.7.7";
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4", "127.0.0.1", forwardedChain));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4,5.5.5.5", "127.0.0.1", forwardedChain));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4,5.5.5.5,6.6.6.6", "127.0.0.1", forwardedChain));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.2.3.4,5.5.5.5,7.7.7.7", "127.0.0.1", forwardedChain));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.2.3.4,5.5.5.5,6.6.6.6,7.7.7.7", "127.0.0.1", forwardedChain));
    }

    @Test
    public void devTools_forwardedForIsLocal_denyAccess() {
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", "127.0.0.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", "::1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", "0:0:0:0:0:0:0:1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", "172.16.0.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "127.0.0.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "::1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "0:0:0:0:0:0:0:1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "172.16.0.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", "127.0.0.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "::1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", "0:0:0:0:0:0:0:1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", "172.16.0.4"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("127.0.0.1", "127.0.0.1", "127.0.0.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "127.0.0.1"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", "127.0.0.1"));
    }

    @Test
    public void devTools_forwardedForIsEmpty_denyAccess() {
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", ""));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("127.0.0.1", "127.0.0.1", ""));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", ""));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", ""));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", "   "));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("127.0.0.1", "127.0.0.1", "   "));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", "   "));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", "   "));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", ","));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("127.0.0.1", "127.0.0.1", ","));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", ","));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", ","));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", ", ,, ,"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("127.0.0.1", "127.0.0.1", ", ,, ,"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("", "127.0.0.1", ", ,, ,"));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("   ", "127.0.0.1", ", ,, ,"));
    }

    @Test
    public void devTools_multipleForwardedForHeader_allChecked() {
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", List.of("1.1.1.1", "2.2.2.2")));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("1.1.1.1", "127.0.0.1", List.of("1.1.1.1", "2.2.2.2")));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost("2.2.2.2", "127.0.0.1", List.of("1.1.1.1", "2.2.2.2")));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", List.of("", "")));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", List.of("  ", "   ")));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", List.of("1.1.1.1", "", "2.2.2.2")));
        Assertions.assertFalse((boolean)this.isAllowedDevToolsHost(null, "127.0.0.1", List.of("1.1.1.1", "  ", "2.2.2.2")));
        Assertions.assertTrue((boolean)this.isAllowedDevToolsHost("1.1.1.1, 2.2.2.2", "127.0.0.1", List.of("1.1.1.1", "2.2.2.2")));
    }

    @Test
    public void devTools_customRemoteIPHeader_allowedIfIpMatches() {
        BiPredicate<String, String> verifier = (remoteIp, spoofedForwarderFor) -> {
            String customClientIpHeaderName = "Some-Proxy-Client-IP";
            VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
            ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
            Mockito.when((Object)configuration.getStringProperty("devmode.hostsAllowed", null)).thenAnswer(q -> "1.2.3.4,5.6.7.8");
            Mockito.when((Object)configuration.getStringProperty((String)ArgumentMatchers.eq((Object)"devmode.remoteAddressHeader"), (String)ArgumentMatchers.any())).thenAnswer(q -> customClientIpHeaderName);
            Mockito.when((Object)request.getHeader(customClientIpHeaderName)).thenReturn(remoteIp);
            Mockito.when((Object)request.getHeader("X-Forwarded-For")).thenReturn(spoofedForwarderFor);
            return IndexHtmlRequestHandler.isAllowedDevToolsHost((AbstractConfiguration)configuration, (VaadinRequest)request);
        };
        Assertions.assertFalse((boolean)verifier.test(null, null));
        Assertions.assertFalse((boolean)verifier.test(null, "1.2.3.4"));
        Assertions.assertFalse((boolean)verifier.test("5.5.5.5", null));
        Assertions.assertFalse((boolean)verifier.test("5.5.5.5", "1.2.3.4,5.5.5.5"));
        Assertions.assertTrue((boolean)verifier.test("1.2.3.4", null));
        Assertions.assertTrue((boolean)verifier.test("5.6.7.8", "5.5.5.5,5.6.7.8"));
    }

    @Test
    public void developmentMode_commercialBannerNeverApplied() throws IOException {
        this.assertHasCommercialBanner(false, false, true);
        this.assertHasCommercialBanner(false, false, false);
        this.assertHasCommercialBanner(false, false, null);
    }

    @Test
    public void productionMode_commercialBannerEnabled_commercialBannerApplied() throws IOException {
        this.assertHasCommercialBanner(true, true, true);
    }

    @Test
    public void productionMode_commercialBannerNotEnabled_commercialBannerNotApplied() throws IOException {
        this.assertHasCommercialBanner(false, true, false);
        this.assertHasCommercialBanner(false, true, null);
    }

    private void assertHasCommercialBanner(boolean expectBanner, boolean productionMode, Boolean commercialBannerFlag) throws IOException {
        if (!productionMode) {
            File projectRootFolder = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
            TestUtil.createIndexHtmlStub(projectRootFolder);
            TestUtil.createStatsJsonStub(projectRootFolder);
            this.deploymentConfiguration.setProjectFolder(projectRootFolder);
        }
        this.deploymentConfiguration.setProductionMode(productionMode);
        if (commercialBannerFlag != null) {
            this.deploymentConfiguration.setApplicationOrSystemProperty("commercialBanner.enable", Boolean.toString(commercialBannerFlag));
        }
        this.indexHtmlRequestHandler.synchronizedHandleRequest(this.session, (VaadinRequest)this.createVaadinRequest("/"), this.response);
        String indexHtml = this.responseOutput.toString(StandardCharsets.UTF_8);
        Document document = Jsoup.parse((String)indexHtml);
        Elements commercialBannerScript = document.head().select("script[type=\"module\"]:containsData(<vaadin-commercial-banner></vaadin-commercial-banner>)");
        if (expectBanner) {
            Assertions.assertEquals((int)1, (int)commercialBannerScript.size(), (String)"Commercial banner should be applied in %s mode with commercial banner token %s".formatted(productionMode ? "production" : "development", commercialBannerFlag));
        } else {
            Assertions.assertTrue((boolean)commercialBannerScript.isEmpty(), (String)"Commercial banner should not be applied in %s mode with commercial banner token %s".formatted(productionMode ? "production" : "development", commercialBannerFlag));
        }
    }

    @Theme(value="mytheme", variant="dark")
    public static class ClassWithDarkLumo
    implements AppShellConfigurator {
    }

    @ColorScheme(value=ColorScheme.Value.DARK)
    public static class ClassWithDarkColorScheme
    implements AppShellConfigurator {
    }

    @ColorScheme(value=ColorScheme.Value.LIGHT_DARK)
    public static class ClassWithLightDarkColorScheme
    implements AppShellConfigurator {
    }

    @ColorScheme(value=ColorScheme.Value.NORMAL)
    public static class ClassWithNormalColorScheme
    implements AppShellConfigurator {
    }
}

