/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HandlerHelperTest {
    private HttpServletRequest createRequest(String pathInfo, HandlerHelper.RequestType type) {
        return this.createRequest(pathInfo, type == null ? null : type.getIdentifier());
    }

    private HttpServletRequest createRequest(String pathInfo, String typeString) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        if ("".equals(pathInfo)) {
            pathInfo = null;
        }
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)typeString);
        return request;
    }

    @Test
    public void isFrameworkInternalRequest_validType_nullPathInfo() {
        HttpServletRequest request = this.createRequest(null, HandlerHelper.RequestType.INIT);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo/*", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_validType_emptyPathinfo() {
        HttpServletRequest request = this.createRequest("", HandlerHelper.RequestType.INIT);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo/*", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_validType_slashPathinfo() {
        HttpServletRequest request = this.createRequest("/", HandlerHelper.RequestType.INIT);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo/*", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_unknownType() {
        HttpServletRequest request = this.createRequest(null, "unknown");
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo/*", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_noType() {
        HttpServletRequest request = this.createRequest(null, (HandlerHelper.RequestType)null);
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo/*", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_validType_withPath() {
        HttpServletRequest request = this.createRequest("hello", HandlerHelper.RequestType.INIT);
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/foo/*", (HttpServletRequest)request));
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/hello", (HttpServletRequest)request));
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/hello/*", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_validType_withServletMappingAndPath() {
        HttpServletRequest request = this.createRequest("", HandlerHelper.RequestType.INIT);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"/servlet");
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"", (HttpServletRequest)request));
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/servlet", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_noType_withServletMappingAndPath() {
        HttpServletRequest request = this.createRequest("/", (HandlerHelper.RequestType)null);
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)"/servlet");
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/", (HttpServletRequest)request));
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/servlet", (HttpServletRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinRequest_servletRoot() {
        VaadinServletRequest request = this.createVaadinRequest("", "/*", HandlerHelper.RequestType.INIT);
        Assert.assertTrue((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinRequest_servletRoot_noType() {
        VaadinServletRequest request = this.createVaadinRequest("", "/*", null);
        Assert.assertFalse((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinRequest_pathInsideServlet() {
        VaadinServletRequest request = this.createVaadinRequest("/foo", "/*", HandlerHelper.RequestType.INIT);
        Assert.assertFalse((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinRequest_pathInsideServlet_noType() {
        VaadinServletRequest request = this.createVaadinRequest("/foo", "/*", null);
        Assert.assertFalse((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinRequest_nonRootServlet() {
        VaadinServletRequest request = this.createVaadinRequest("", "/myservlet/", HandlerHelper.RequestType.INIT);
        Assert.assertTrue((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinRequest_nonRootServlet_pathInsideServlet() {
        VaadinServletRequest request = this.createVaadinRequest("/hello", "/myservlet", null);
        Assert.assertFalse((boolean)BootstrapHandler.isFrameworkInternalRequest((VaadinRequest)request));
    }

    @Test
    public void isFrameworkInternalRequest_uploadUrl() {
        VaadinServletRequest request = this.createVaadinRequest("VAADIN/dynamic/resource/1/e83d6b6d-2b75-4960-8922-5431f4a23e49/upload", "", null);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_dynamicResourceUrl_withoutPostfix() {
        VaadinServletRequest request = this.createVaadinRequest("VAADIN/dynamic/resource/1/e83d6b6d-2b75-4960-8922-5431f4a23e49/", "", null);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_dynamicResourceUrl_withCustomPostfix() {
        VaadinServletRequest request = this.createVaadinRequest("VAADIN/dynamic/resource/1/e83d6b6d-2b75-4960-8922-5431f4a23e49/custom.pdf", "", null);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_hillaPushUrl() {
        VaadinServletRequest request = this.createVaadinRequest("HILLA/push", "", null);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinServletMapping_hillaPushUrl() {
        VaadinServletRequest request = this.createVaadinRequest("HILLA/push", "", null);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/ui/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_flowPushUrl() {
        VaadinServletRequest request = this.createVaadinRequest("VAADIN/push", "", HandlerHelper.RequestType.PUSH);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_vaadinServletMapping_flowPushUrl() {
        VaadinServletRequest request = this.createVaadinRequest("/VAADIN/push", "/ui", HandlerHelper.RequestType.PUSH);
        Assert.assertTrue((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/ui/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_fakeUploadUrl() {
        VaadinServletRequest request = this.createVaadinRequest("VAADIN/dynamic/resource/../../../upload", "", null);
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void isFrameworkInternalRequest_staticFileUrl() {
        VaadinServletRequest request = this.createVaadinRequest("VAADIN/static/file.png", "", null);
        Assert.assertFalse((boolean)HandlerHelper.isFrameworkInternalRequest((String)"/*", (HttpServletRequest)request.getHttpServletRequest()));
    }

    @Test
    public void getPathIfInsideServlet_default_servlet() {
        String servletMapping = "/*";
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)""));
        Assert.assertEquals(Optional.of("/"), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/"));
        Assert.assertEquals(Optional.of("foo"), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo"));
        Assert.assertEquals(Optional.of("/foo"), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foo"));
    }

    @Test
    public void getPathIfInsideServlet_root_only_servlet() {
        String servletMapping = "";
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)""));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foo"));
    }

    @Test
    public void getPathIfInsideServlet_all_urls_servlet() {
        String servletMapping = "/";
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)""));
        Assert.assertEquals(Optional.of("/"), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/"));
        Assert.assertEquals(Optional.of("foo"), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo"));
        Assert.assertEquals(Optional.of("/foo"), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foo"));
    }

    @Test
    public void getPathIfInsideServlet_sevlet_using_single_path() {
        String servletMapping = "/foo";
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)""));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"bar"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/bar"));
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo/"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo/bar"));
    }

    @Test
    public void getPathIfInsideServlet_sevlet_with_context_path() {
        String servletMapping = "/foo/*";
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)""));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"bar"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/bar"));
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo"));
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"foo/"));
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foo"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foos"));
        Assert.assertEquals(Optional.empty(), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foos/bar"));
        Assert.assertEquals(Optional.of(""), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foo/"));
        Assert.assertEquals(Optional.of("bar"), (Object)HandlerHelper.getPathIfInsideServlet((String)servletMapping, (String)"/foo/bar"));
    }

    private VaadinServletRequest createVaadinRequest(String requestPath, String servletPath, HandlerHelper.RequestType type) {
        HttpServletRequest servletRequest = this.createRequest(requestPath, type);
        if (servletPath.equals("/*")) {
            servletPath = "";
        }
        Mockito.when((Object)servletRequest.getServletPath()).thenReturn((Object)servletPath);
        return new VaadinServletRequest(servletRequest, (VaadinServletService)Mockito.mock(VaadinServletService.class));
    }

    @Test
    public void publicResources() {
        HashSet<String> expected = new HashSet<String>();
        expected.add("/manifest.webmanifest");
        expected.add("/sw.js");
        expected.add("/sw-runtime-resources-precache.js");
        expected.add("/offline.html");
        expected.add("/offline-stub.html");
        expected.add("/icons/icon.png");
        expected.add("/icons/icon-144x144.png");
        expected.add("/icons/icon-192x192.png");
        expected.add("/icons/icon-512x512.png");
        expected.add("/icons/icon-16x16.png");
        expected.add("/icons/icon-32x32.png");
        expected.add("/icons/icon-96x96.png");
        expected.add("/icons/icon-180x180.png");
        expected.add("/icons/icon-2048x2732.png");
        expected.add("/icons/icon-2732x2048.png");
        expected.add("/icons/icon-1668x2388.png");
        expected.add("/icons/icon-2388x1668.png");
        expected.add("/icons/icon-1668x2224.png");
        expected.add("/icons/icon-2224x1668.png");
        expected.add("/icons/icon-1620x2160.png");
        expected.add("/icons/icon-2160x1620.png");
        expected.add("/icons/icon-1536x2048.png");
        expected.add("/icons/icon-2048x1536.png");
        expected.add("/icons/icon-1284x2778.png");
        expected.add("/icons/icon-2778x1284.png");
        expected.add("/icons/icon-1170x2532.png");
        expected.add("/icons/icon-2532x1170.png");
        expected.add("/icons/icon-1125x2436.png");
        expected.add("/icons/icon-2436x1125.png");
        expected.add("/icons/icon-1242x2688.png");
        expected.add("/icons/icon-2688x1242.png");
        expected.add("/icons/icon-828x1792.png");
        expected.add("/icons/icon-1792x828.png");
        expected.add("/icons/icon-1242x2208.png");
        expected.add("/icons/icon-2208x1242.png");
        expected.add("/icons/icon-750x1334.png");
        expected.add("/icons/icon-1334x750.png");
        expected.add("/icons/icon-640x1136.png");
        expected.add("/icons/icon-1136x640.png");
        expected.add("/styles.css");
        expected.add("/themes/**");
        expected.add("/assets/**");
        HashSet actual = new HashSet();
        Collections.addAll(actual, HandlerHelper.getPublicResources());
        Assert.assertEquals(expected, actual);
        Set<String> expectedRoot = Set.of("/favicon.ico", "/aura/**", "/lumo/**");
        HashSet actualRoot = new HashSet();
        Collections.addAll(actualRoot, HandlerHelper.getPublicResourcesRoot());
        Assert.assertEquals(expectedRoot, actualRoot);
    }
}

