/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.TestAbstractRouteRegistry;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AbstractRouteRegistryTest {
    private AbstractRouteRegistry registry;

    AbstractRouteRegistryTest() {
    }

    @BeforeEach
    public void init() {
        this.registry = new TestAbstractRouteRegistry();
    }

    @Test
    public void lockingConfiguration_configurationIsUpdatedOnlyAfterUnlock() {
        final CountDownLatch waitReaderThread = new CountDownLatch(1);
        final CountDownLatch waitUpdaterThread = new CountDownLatch(2);
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                AbstractRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assertions.assertTrue((boolean)AbstractRouteRegistryTest.this.registry.getRegisteredRoutes().isEmpty(), (String)"Registry should still remain empty");
                AbstractRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assertions.assertTrue((boolean)AbstractRouteRegistryTest.this.registry.getRegisteredRoutes().isEmpty(), (String)"Registry should still remain empty");
                waitReaderThread.countDown();
            }
        };
        readerThread.start();
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("", MyRoute.class, Collections.emptyList());
            this.registry.setRoute("path", Secondary.class, Collections.emptyList());
        });
        Assertions.assertEquals((int)2, (int)this.registry.getRegisteredRoutes().size(), (String)"After unlock registry should be updated for others to configure with new data");
    }

    @Test
    public void routeChangeListener_correctChangesAreReturned() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.registry.setRoute("", MyRoute.class, Collections.emptyList());
        Assertions.assertFalse((boolean)added.isEmpty(), (String)"Added should contain data for one entry");
        Assertions.assertTrue((boolean)removed.isEmpty(), (String)"No routes should have been removed");
        Assertions.assertEquals(MyRoute.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assertions.assertEquals((Object)"", (Object)((RouteBaseData)added.get(0)).getTemplate());
        Assertions.assertEquals(Collections.emptyList(), (Object)((RouteBaseData)added.get(0)).getParentLayouts());
        this.registry.setRoute("home", Secondary.class, Collections.emptyList());
        Assertions.assertFalse((boolean)added.isEmpty(), (String)"Added should contain data for one entry");
        Assertions.assertEquals((int)1, (int)added.size(), (String)"Only latest change should be available");
        Assertions.assertTrue((boolean)removed.isEmpty(), (String)"No routes should have been removed");
        Assertions.assertEquals(Secondary.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assertions.assertEquals((Object)"home", (Object)((RouteBaseData)added.get(0)).getTemplate());
        this.registry.removeRoute("home");
        Assertions.assertTrue((boolean)added.isEmpty(), (String)"No routes should have been added");
        Assertions.assertFalse((boolean)removed.isEmpty(), (String)"One route should have gotten removed");
        Assertions.assertEquals(Secondary.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assertions.assertEquals((Object)"home", (Object)((RouteBaseData)removed.get(0)).getTemplate(), (String)"The 'home' route should have been removed");
    }

    @Test
    public void routeChangeListener_blockChangesAreGivenCorrectlyInEvent() {
        this.registry.setRoute("", MyRoute.class, Collections.emptyList());
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.removeRoute("");
            this.registry.setRoute("path", Secondary.class, Collections.emptyList());
            this.registry.setRoute("", MyRoute.class, Collections.singletonList(MainLayout.class));
        });
        Assertions.assertFalse((boolean)added.isEmpty(), (String)"");
        Assertions.assertEquals((int)2, (int)added.size(), (String)"");
        Assertions.assertFalse((boolean)removed.isEmpty(), (String)"");
        for (RouteBaseData data : added) {
            if (data.getTemplate().equals("")) {
                Assertions.assertEquals(MyRoute.class, (Object)data.getNavigationTarget(), (String)"MyRoute should have been added");
                Assertions.assertEquals(MainLayout.class, (Object)data.getParentLayout(), (String)"MyRoute should have been seen as a update as the parent layouts changed.");
                continue;
            }
            Assertions.assertEquals(Secondary.class, (Object)data.getNavigationTarget(), (String)"");
        }
        Assertions.assertEquals(MyRoute.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget(), (String)"MyRoute should have been both removed and added");
        Assertions.assertEquals(Collections.emptyList(), (Object)((RouteBaseData)removed.get(0)).getParentLayouts(), (String)"Removed version should not have a parent layout");
    }

    @Test
    public void routeWithAliases_eventShowsCorrectlyAsRemoved() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("main", Secondary.class, Collections.emptyList());
            this.registry.setRoute("Alias1", Secondary.class, Collections.emptyList());
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        });
        Assertions.assertEquals((int)3, (int)added.size(), (String)"Main route and aliases should all be seen as added.");
        Assertions.assertTrue((boolean)removed.isEmpty(), (String)"No routes should have been removed");
        this.registry.removeRoute("Alias2");
        Assertions.assertTrue((boolean)added.isEmpty(), (String)"No routes should have been added");
        Assertions.assertEquals((int)1, (int)removed.size(), (String)"Removing the alias route should be seen in the event");
    }

    @Test
    public void changeListenerAddedDuringUpdate_eventIsFiredForListener() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("main", Secondary.class, Collections.emptyList());
            this.registry.setRoute("Alias1", Secondary.class, Collections.emptyList());
            this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
                added.clear();
                removed.clear();
                added.addAll(event.getAddedRoutes());
                removed.addAll(event.getRemovedRoutes());
            });
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        });
        Assertions.assertEquals((int)3, (int)added.size(), (String)"Main route and aliases should all be seen as added.");
        Assertions.assertTrue((boolean)removed.isEmpty(), (String)"No routes should have been removed");
        this.registry.removeRoute("Alias2");
        Assertions.assertTrue((boolean)added.isEmpty(), (String)"No routes should have been added");
        Assertions.assertEquals((int)1, (int)removed.size(), (String)"Removing the alias route should be seen in the event");
    }

    @Test
    public void removeChangeListener_noEventsAreFired() {
        ArrayList events = new ArrayList();
        Registration registration = this.registry.addRoutesChangeListener(events::add);
        this.registry.setRoute("home", MyRoute.class, Collections.emptyList());
        Assertions.assertEquals((int)1, (int)events.size(), (String)"Event should have been fired for listener");
        registration.remove();
        this.registry.setRoute("away", MyRoute.class, Collections.emptyList());
        Assertions.assertEquals((int)1, (int)events.size(), (String)"No new event should have fired");
    }

    @Test
    public void routeChangedEvent_testRouteAddedAndRemoved() {
        this.registry.setRoute("MyRoute1", MyRoute.class, Collections.emptyList());
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            Assertions.assertEquals((int)2, (int)event.getAddedRoutes().size(), (String)"MyRoute2 and Alias2 must be added");
            Assertions.assertEquals((int)1, (int)event.getRemovedRoutes().size(), (String)"MyRoute1 must be deleted");
            Assertions.assertTrue((boolean)event.isRouteAdded(MyRoute.class), (String)"MyRoute2 must be added");
            Assertions.assertTrue((boolean)event.isRouteAdded(Secondary.class), (String)"Alias2 must be added");
            Assertions.assertTrue((boolean)event.isRouteRemoved(MyRoute.class), (String)"MyRoute1 must be deleted");
            Assertions.assertTrue((boolean)event.getAddedNavigationTargets().contains(MyRoute.class), (String)"MyRoute2 must be added");
            Assertions.assertTrue((boolean)event.getAddedNavigationTargets().contains(Secondary.class), (String)"Alias2 must be added");
            Assertions.assertTrue((boolean)event.getRemovedNavigationTargets().contains(MyRoute.class), (String)"MyRoute1 must be deleted");
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("MyRoute2", MyRoute.class, Collections.emptyList());
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
            this.registry.removeRoute("MyRoute1");
        });
    }

    @Test
    public void routeChangedEvent_testPathAddedAndRemoved() {
        this.registry.setRoute("MyRoute1", MyRoute.class, Collections.emptyList());
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            Assertions.assertEquals((int)2, (int)event.getAddedRoutes().size(), (String)"MyRoute2 and Alias2 must be added");
            Assertions.assertEquals((int)1, (int)event.getRemovedRoutes().size(), (String)"MyRoute1 must be deleted");
            Assertions.assertTrue((boolean)event.isPathAdded("MyRoute2"), (String)"MyRoute2 must be added");
            Assertions.assertTrue((boolean)event.isPathAdded("Alias2"), (String)"Alias2 must be added");
            Assertions.assertTrue((boolean)event.isPathRemoved("MyRoute1"), (String)"MyRoute1 must be deleted");
            Assertions.assertTrue((boolean)event.getAddedURLs().contains("MyRoute2"), (String)"MyRoute2 must be added");
            Assertions.assertTrue((boolean)event.getAddedURLs().contains("Alias2"), (String)"Alias2 must be added");
            Assertions.assertTrue((boolean)event.getRemovedURLs().contains("MyRoute1"), (String)"MyRoute1 must be deleted");
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("MyRoute2", MyRoute.class, Collections.emptyList());
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
            this.registry.removeRoute("MyRoute1");
        });
    }

    @Test
    public void only_normal_target_works_as_expected() {
        this.addTarget(NormalRoute.class);
        Assertions.assertEquals(NormalRoute.class, this.getTarget(), (String)"NormalRoute should have been returned");
    }

    @Test
    public void only_has_url_target_works_as_expected() {
        this.addTarget(HasUrlRoute.class);
        Assertions.assertNull(this.getTarget(new ArrayList<String>()), (String)"No has url should have been returned without parameter");
        Assertions.assertEquals(HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"HasUrlRoute should have been returned");
    }

    @Test
    public void only_optional_target_works_as_expected() {
        this.addTarget(OptionalRoute.class);
        Assertions.assertEquals(OptionalRoute.class, this.getTarget(new ArrayList<String>()), (String)"OptionalRoute should have been returned with no parameter");
        Assertions.assertEquals(OptionalRoute.class, this.getTarget(Arrays.asList("optional")), (String)"OptionalRoute should have been returned");
    }

    @Test
    public void only_wildcard_target_works_as_expected() {
        this.addTarget(WildcardRoute.class);
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(new ArrayList<String>()), (String)"WildcardRoute should have been returned with no parameter");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("wild")), (String)"WildcardRoute should have been returned for one parameter");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")), (String)"WildcardRoute should have been returned for multiple parameters");
    }

    @Test
    public void normal_and_has_url_work_together() {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        Assertions.assertEquals(NormalRoute.class, this.getTarget(new ArrayList<String>()), (String)"NormalRoute should have been returned");
        Assertions.assertEquals(HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"HasUrlRoute should have been returned");
    }

    @Test
    public void has_url_and_normal_work_together() {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(NormalRoute.class);
        Assertions.assertEquals(NormalRoute.class, this.getTarget(new ArrayList<String>()), (String)"NormalRoute should have been returned");
        Assertions.assertEquals(HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"HasUrlRoute should have been returned");
    }

    @Test
    public void normal_and_wildcard_work_together() {
        this.addTarget(NormalRoute.class);
        this.addTarget(WildcardRoute.class);
        Assertions.assertEquals(NormalRoute.class, this.getTarget(new ArrayList<String>()), (String)"NormalRoute should have been returned");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"WildcardRoute should have been returned");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")), (String)"WildcardRoute should have been returned for multiple parameters");
    }

    @Test
    public void wildcard_and_normal_work_together() {
        this.addTarget(WildcardRoute.class);
        this.addTarget(NormalRoute.class);
        Assertions.assertEquals(NormalRoute.class, this.getTarget(new ArrayList<String>()), (String)"NormalRoute should have been returned");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"WildcardRoute should have been returned");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")), (String)"WildcardRoute should have been returned for multiple parameters");
    }

    @Test
    public void normal_and_has_url_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void normal_and_wildcard_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(NormalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void wildcard_and_normal_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(NormalRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void has_url_and_wildcard_and_normal_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(NormalRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void has_url_and_normal_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(NormalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    private void assertNormalHasUrlAndWildcard() {
        Assertions.assertEquals(NormalRoute.class, this.getTarget(new ArrayList<String>()), (String)"NormalRoute should have been returned");
        Assertions.assertEquals(HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"HasUrlRoute should have been returned");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")), (String)"WildcardRoute should have been returned for multiple parameters");
    }

    @Test
    public void has_url_and_optional_parameter_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(OptionalRoute.class);
        Assertions.assertEquals(OptionalRoute.class, this.getTarget(new ArrayList<String>()), (String)"OptionalRoute should have been returned");
        Assertions.assertEquals(HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"HasUrlRoute should have been returned");
    }

    @Test
    public void has_url_and_wildcard_and_optional_parameter_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(OptionalRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void optional_parameter_and_has_url_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(OptionalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void optional_parameter_and_wildcard_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(OptionalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void wildcard_and_has_url_and_optional_parameter_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(OptionalRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void wildcard_and_optional_parameter_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(OptionalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void has_url_and_optional_parameter_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(OptionalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    private void assertHasUrlOptionalAndWildcard() {
        Assertions.assertEquals(OptionalRoute.class, this.getTarget(new ArrayList<String>()), (String)"OptionalRoute should have been returned");
        Assertions.assertEquals(HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"HasUrlRoute should have been returned");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")), (String)"WildcardRoute should have been returned for multiple parameters");
    }

    @Test
    public void has_url_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertHasUrlAndWildcard();
    }

    @Test
    public void wildcard_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertHasUrlAndWildcard();
    }

    private void assertHasUrlAndWildcard() {
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(new ArrayList<String>()), (String)"WildcardRoute should have been returned");
        Assertions.assertEquals(HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")), (String)"HasUrlRoute should have been returned");
        Assertions.assertEquals(WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")), (String)"WildcardRoute should have been returned for multiple parameters");
    }

    @Test
    public void multiple_normal_routes_throw_exception() throws InvalidRouteConfigurationException {
        this.addTarget(NormalRoute.class);
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.addTarget(SecondNormalRoute.class));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' having the same route.", NormalRoute.class.getName(), SecondNormalRoute.class.getName())));
    }

    @Test
    public void normal_and_optional_throws_exception() throws InvalidRouteConfigurationException {
        this.addTarget(NormalRoute.class);
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.addTarget(OptionalRoute.class));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", NormalRoute.class.getName(), OptionalRoute.class.getName(), OptionalRoute.class.getName())));
    }

    @Test
    public void two_optionals_throw_exception() throws InvalidRouteConfigurationException {
        this.addTarget(OptionalRoute.class);
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.addTarget(SecondOptionalRoute.class));
    }

    @Test
    public void optional_and_normal_throws_exception() throws InvalidRouteConfigurationException {
        this.addTarget(OptionalRoute.class);
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.addTarget(NormalRoute.class));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", NormalRoute.class.getName(), OptionalRoute.class.getName(), OptionalRoute.class.getName())));
    }

    @Test
    public void two_has_route_parameters_throw_exception() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.addTarget(SecondHasUrlRoute.class));
    }

    @Test
    public void two_wildcard_parameters_throw_exception() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        InvalidRouteConfigurationException ex = (InvalidRouteConfigurationException)Assertions.assertThrows(InvalidRouteConfigurationException.class, () -> this.addTarget(SecondWildcardRoute.class));
    }

    @Test
    public void removing_target_leaves_others() {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        Assertions.assertEquals((int)3, (int)this.config().getTargetRoutes().size(), (String)"Expected three routes to be registered");
        this.registry.removeRoute(HasUrlRoute.class);
        Assertions.assertEquals((int)2, (int)this.config().getTargetRoutes().size(), (String)"Only 2 routes should remain after removing one.");
        Assertions.assertTrue((boolean)this.config().hasRouteTarget(NormalRoute.class), (String)"NormalRoute should still be available");
        Assertions.assertTrue((boolean)this.config().hasRouteTarget(WildcardRoute.class), (String)"WildcardRoute should still be available");
    }

    @Test
    public void removing_all_targets_is_possible_and_returns_empty() {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        Assertions.assertEquals((int)3, (int)this.config().getTargetRoutes().size(), (String)"Expected three routes to be registered");
        this.registry.removeRoute(HasUrlRoute.class);
        this.registry.removeRoute(NormalRoute.class);
        this.registry.removeRoute(WildcardRoute.class);
        Assertions.assertTrue((boolean)this.config().getTargetRoutes().isEmpty(), (String)"All routes should have been removed from the target.");
    }

    @Test
    public void check_has_parameters_returns_correctly() {
        this.registry.setRoute("", NormalRoute.class, null);
        this.registry.setRoute("url", HasUrlRoute.class, null);
        this.registry.setRoute("optional", OptionalRoute.class, null);
        this.registry.setRoute("wild", WildcardRoute.class, null);
        this.registry.setRoute(ParameterView.class.getAnnotation(Route.class).value(), ParameterView.class, null);
        Assertions.assertEquals((int)5, (int)this.config().getTargetRoutes().size(), (String)"All routes should be registered.");
        Assertions.assertFalse((boolean)this.registry.hasMandatoryParameter(NormalRoute.class), (String)"Normal route should not mark as requiring parameter");
        Assertions.assertFalse((boolean)this.registry.hasMandatoryParameter(OptionalRoute.class), (String)"Optional parameter should not mark as requiring parameter");
        Assertions.assertFalse((boolean)this.registry.hasMandatoryParameter(WildcardRoute.class), (String)"Wildcard parameter should not mark as requiring parameter");
        Assertions.assertTrue((boolean)this.registry.hasMandatoryParameter(HasUrlRoute.class), (String)"HasUrl should require parameter");
        Assertions.assertTrue((boolean)this.registry.hasMandatoryParameter(ParameterView.class), (String)"Template parameter should require parameter");
        Assertions.assertThrows(NotFoundException.class, () -> this.registry.hasMandatoryParameter(Secondary.class), (String)"Checking unregistered route should throw exception");
    }

    @Test
    public void multipleLayouts_stricterLayoutMatches_correctLayoutsReturned() {
        this.registry.setLayout(DefaultLayout.class);
        this.registry.setLayout(ViewLayout.class);
        Assertions.assertEquals(ViewLayout.class, (Object)this.registry.getLayout("/view"), (String)"Path match returned wrong layout");
        Assertions.assertEquals(ViewLayout.class, (Object)this.registry.getLayout("/view/home"), (String)"Beginning path match returned wrong layout");
        Assertions.assertEquals(DefaultLayout.class, (Object)this.registry.getLayout("/path"), (String)"Any route match returned wrong layout");
    }

    @Test
    public void singleLayout_nonMatchingPathsReturnFalseOnHasLayout() {
        this.registry.setLayout(ViewLayout.class);
        Assertions.assertTrue((boolean)this.registry.hasLayout("/view"), (String)"Existing layout should have returned true");
        Assertions.assertFalse((boolean)this.registry.hasLayout("/path"), (String)"Path outside layout should return false");
    }

    private void awaitCountDown(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Assertions.fail();
        }
    }

    private ConfiguredRoutes config() {
        return this.registry.getConfiguration();
    }

    private void addTarget(Class<? extends Component> navigationTarget) {
        this.registry.setRoute("", navigationTarget, Collections.emptyList());
    }

    private void addTarget(Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        this.registry.setRoute("", navigationTarget, parentChain);
    }

    private Class<? extends Component> getTarget() {
        return this.registry.getNavigationTarget("").orElse(null);
    }

    private Class<? extends Component> getTarget(String segment) {
        return this.registry.getNavigationTarget(segment).orElse(null);
    }

    private Class<? extends Component> getTarget(List<String> segments) {
        return this.registry.getNavigationTarget(PathUtil.getPath(segments)).orElse(null);
    }

    @Tag(value="div")
    @Route(value="MyRoute")
    private static class MyRoute
    extends Component {
        private MyRoute() {
        }
    }

    @Tag(value="div")
    private static class Secondary
    extends Component {
        private Secondary() {
        }
    }

    @Tag(value="div")
    private static class MainLayout
    extends Component
    implements RouterLayout {
        private MainLayout() {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class NormalRoute
    extends Component {
        private NormalRoute() {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class HasUrlRoute
    extends Component
    implements HasUrlParameter<String> {
        private HasUrlRoute() {
        }

        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class OptionalRoute
    extends Component
    implements HasUrlParameter<String> {
        private OptionalRoute() {
        }

        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class WildcardRoute
    extends Component
    implements HasUrlParameter<String> {
        private WildcardRoute() {
        }

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondNormalRoute
    extends Component {
        private SecondNormalRoute() {
        }
    }

    @Route(value="item/:long(^[+-]?[0-9]{1,19}$)")
    @Tag(value="div")
    private static class ParameterView
    extends Component {
        private ParameterView() {
        }
    }

    @Tag(value="div")
    @Layout
    private static class DefaultLayout
    extends Component
    implements RouterLayout {
        private DefaultLayout() {
        }
    }

    @Tag(value="div")
    @Layout(value="/view")
    private static class ViewLayout
    extends Component
    implements RouterLayout {
        private ViewLayout() {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondWildcardRoute
    extends Component
    implements HasUrlParameter<String> {
        private SecondWildcardRoute() {
        }

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondHasUrlRoute
    extends Component
    implements HasUrlParameter<String> {
        private SecondHasUrlRoute() {
        }

        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondOptionalRoute
    extends Component
    implements HasUrlParameter<String> {
        private SecondOptionalRoute() {
        }

        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    @Tag(value="div")
    private static class Parent
    extends Component
    implements RouterLayout {
        private Parent() {
        }
    }
}

