/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.TestRouteRegistry;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockUI;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

public class RoutingTestBase {
    protected Router router;

    @BeforeEach
    public void init() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.router = new Router((RouteRegistry)new TestRouteRegistry());
    }

    public static class RouterTestUI
    extends UI {
        public RouterTestUI(Router router) {
            this.getInternals().setSession(RouterTestUI.createMockSession(router));
        }

        private static VaadinSession createMockSession(Router router) {
            VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
            VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
            Mockito.when((Object)session.getService()).thenReturn((Object)service);
            Mockito.when((Object)service.getRouter()).thenReturn((Object)router);
            return session;
        }
    }

    public static class RouterTestMockUI
    extends MockUI {
        public RouterTestMockUI(Router router) {
            super(RouterTestMockUI.createMockSession(router));
        }

        private static VaadinSession createMockSession(Router router) {
            MockVaadinServletService service = new MockVaadinServletService();
            service.setRouter(router);
            return new AlwaysLockedVaadinSession((VaadinService)service);
        }
    }

    @Route(value="greeting/other")
    @PageTitle(value="Custom Title")
    @Tag(value="div")
    public static class OtherGreetingNavigationTarget
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="greeting")
    @PageTitle(value="Custom Title")
    @Tag(value="div")
    public static class GreetingNavigationTarget
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="navigation-target-with-title")
    @PageTitle(value="Custom Title")
    @Tag(value="div")
    public static class NavigationTargetWithTitle
    extends Component {
    }

    @Route(value="foo/bar")
    @Tag(value="div")
    public static class FooBarNavigationTarget
    extends Component {
    }

    @Route(value="foo")
    @Tag(value="div")
    public static class FooNavigationTarget
    extends Component {
    }

    @Route(value="")
    @Tag(value="div")
    public static class RootNavigationTarget
    extends Component {
    }
}

