/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.RouteParam;
import com.vaadin.flow.router.RouteParameters;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RouteParametersTest {
    RouteParametersTest() {
    }

    @Test
    public void getters_provide_correct_values() {
        RouteParameters parameters = this.getParameters();
        Assertions.assertEquals((Object)"foo", parameters.get("string").get(), (String)"Wrong value");
        Assertions.assertEquals((Object)"123", parameters.get("integer").get(), (String)"Wrong value");
        Assertions.assertEquals((Object)"12345678900", parameters.get("long").get(), (String)"Wrong value");
        Assertions.assertEquals((Object)"path/to/foo/bar", parameters.get("varargs").get(), (String)"Wrong value");
        Assertions.assertEquals((Integer)123, (Integer)((Integer)parameters.getInteger("integer").get()), (String)"Wrong value");
        Assertions.assertEquals((Long)123L, (Long)((Long)parameters.getLong("integer").get()), (String)"Wrong value");
        Assertions.assertEquals((Long)12345678900L, (Long)((Long)parameters.getLong("long").get()), (String)"Wrong value");
        Assertions.assertEquals(Arrays.asList("foo"), (Object)parameters.getWildcard("string"), (String)"Wrong value");
        Assertions.assertEquals(Arrays.asList("123"), (Object)parameters.getWildcard("integer"), (String)"Wrong value");
        Assertions.assertEquals(Arrays.asList("12345678900"), (Object)parameters.getWildcard("long"), (String)"Wrong value");
        Assertions.assertEquals(Arrays.asList("path", "to", "foo", "bar"), (Object)parameters.getWildcard("varargs"), (String)"Wrong value");
    }

    @Test
    public void getters_provide_empty_values() {
        RouteParameters parameters = this.getParameters();
        Assertions.assertFalse((boolean)parameters.get("foo").isPresent(), (String)"Getting the String value of a non-existing parameter should return empty Optional");
        Assertions.assertFalse((boolean)parameters.getInteger("foo").isPresent(), (String)"Getting the Integer value of a non-existing parameter should return empty Optional");
        Assertions.assertFalse((boolean)parameters.getLong("foo").isPresent(), (String)"Getting the Long value of a non-existing parameter should return empty Optional");
        Assertions.assertTrue((boolean)parameters.getWildcard("foo").isEmpty(), (String)"Getting the Wildcard value of a non-existing parameter should return empty List");
    }

    @Test
    public void integer_getter_stringParameter_throws() {
        RouteParameters parameters = this.getParameters();
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> parameters.getInteger("string"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Couldn't parse 'string' parameter value 'foo' as integer"));
    }

    @Test
    public void integer_getter_longParameter_throws() {
        RouteParameters parameters = this.getParameters();
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> parameters.getInteger("long"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Couldn't parse 'long' parameter value '12345678900' as integer"));
    }

    @Test
    public void integer_getter_varaargsParameter_throws() {
        RouteParameters parameters = this.getParameters();
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> parameters.getInteger("varargs"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Couldn't parse 'varargs' parameter value 'path/to/foo/bar' as integer"));
    }

    @Test
    public void long_getter_varaargsParameter_throws() {
        RouteParameters parameters = this.getParameters();
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> parameters.getLong("varargs"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Couldn't parse 'varargs' parameter value 'path/to/foo/bar' as long"));
    }

    @Test
    public void long_getter_stringParameter_throws() {
        RouteParameters parameters = this.getParameters();
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> parameters.getLong("string"));
        Assertions.assertTrue((boolean)ex.getMessage().contains("Couldn't parse 'string' parameter value 'foo' as long"));
    }

    @Test
    public void varargs_initializer_throws_exception() {
        try {
            new RouteParameters(new RouteParam[]{new RouteParam("int", "123"), new RouteParam("int", "123")});
            Assertions.fail((String)"RouteParameters initializer should have failed with same parameter defined more than once.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private RouteParameters getParameters() {
        return new RouteParameters(new RouteParam[]{new RouteParam("string", "foo"), new RouteParam("integer", "123"), new RouteParam("long", "12345678900"), new RouteParam("varargs", "path/to/foo/bar")});
    }
}

