/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.UsageStatisticsExporter;
import java.util.stream.Collectors;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.node.ObjectNode;

class UsageStatisticsExporterTest {
    UsageStatisticsExporterTest() {
    }

    @Test
    public void should_append_script_element_to_the_body() {
        Document document = new Document("");
        Element html = document.appendElement("html");
        html.appendElement("body");
        UsageStatisticsExporter.exportUsageStatisticsToDocument((Document)document);
        String entries = UsageStatistics.getEntries().map(entry -> {
            ObjectNode json = JacksonUtils.createObjectNode();
            json.put("is", entry.getName());
            json.put("version", entry.getVersion());
            return json.toString();
        }).collect(Collectors.joining(","));
        String expected = StringUtil.normaliseWhitespace((String)("window.Vaadin = window.Vaadin || {};\nwindow.Vaadin.registrations = window.Vaadin.registrations || [];\nwindow.Vaadin.registrations.push(" + entries + ");"));
        Elements bodyInlineElements = document.body().getElementsByTag("script");
        String htmlContent = ((Element)bodyInlineElements.get(0)).childNode(0).outerHtml();
        htmlContent = htmlContent.replace("\r", "");
        htmlContent = htmlContent.replace("\n", " ");
        Assertions.assertEquals((Object)StringUtil.normaliseWhitespace((String)expected), (Object)htmlContent);
    }
}

