/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.Range;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RangeTest {
    RangeTest() {
    }

    @Test
    public void startAfterEndTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Range.between((int)10, (int)9));
    }

    @Test
    public void negativeLengthTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Range.withLength((int)10, (int)-1));
    }

    @Test
    public void constructorEquivalenceTest() {
        Assertions.assertEquals((Object)Range.withOnly((int)10), (Object)Range.between((int)10, (int)11), (String)"10 == [10,11[");
        Assertions.assertEquals((Object)Range.between((int)10, (int)20), (Object)Range.withLength((int)10, (int)10), (String)"[10,20[ == 10, length 10");
        Assertions.assertEquals((Object)Range.withOnly((int)10), (Object)Range.withLength((int)10, (int)1), (String)"10 == 10, length 1");
    }

    @Test
    public void boundsTest() {
        Range range = Range.between((int)0, (int)10);
        Assertions.assertEquals((int)0, (int)range.getStart(), (String)"between(0, 10) start");
        Assertions.assertEquals((int)10, (int)range.getEnd(), (String)"between(0, 10) end");
        Range single = Range.withOnly((int)10);
        Assertions.assertEquals((int)10, (int)single.getStart(), (String)"withOnly(10) start");
        Assertions.assertEquals((int)11, (int)single.getEnd(), (String)"withOnly(10) end");
        Range length = Range.withLength((int)10, (int)5);
        Assertions.assertEquals((int)10, (int)length.getStart(), (String)"withLength(10, 5) start");
        Assertions.assertEquals((int)15, (int)length.getEnd(), (String)"withLength(10, 5) end");
    }

    @Test
    public void equalsTest() {
        Range range1 = Range.between((int)0, (int)10);
        Range range2 = Range.withLength((int)0, (int)11);
        Assertions.assertTrue((!range1.equals(null) ? 1 : 0) != 0, (String)"null");
        Assertions.assertTrue((boolean)range1.equals((Object)range1), (String)"reflexive");
        Assertions.assertEquals((Object)range1.equals((Object)range2), (Object)range2.equals((Object)range1), (String)"symmetric");
    }

    @Test
    public void containsTest() {
        boolean start = false;
        int end = 10;
        Range range = Range.between((int)0, (int)10);
        Assertions.assertTrue((boolean)range.contains(0), (String)"start should be contained");
        Assertions.assertTrue((!range.contains(-1) ? 1 : 0) != 0, (String)"start-1 should not be contained");
        Assertions.assertTrue((!range.contains(10) ? 1 : 0) != 0, (String)"end should not be contained");
        Assertions.assertTrue((boolean)range.contains(9), (String)"end-1 should be contained");
        Assertions.assertTrue((boolean)Range.between((int)0, (int)10).contains(5), (String)"[0..10[ contains 5");
        Assertions.assertTrue((!Range.between((int)5, (int)5).contains(5) ? 1 : 0) != 0, (String)"empty range does not contain 5");
    }

    @Test
    public void emptyTest() {
        Assertions.assertTrue((boolean)Range.between((int)0, (int)0).isEmpty(), (String)"[0..0[ should be empty");
        Assertions.assertTrue((boolean)Range.withLength((int)0, (int)0).isEmpty(), (String)"Range of length 0 should be empty");
        Assertions.assertTrue((!Range.between((int)0, (int)1).isEmpty() ? 1 : 0) != 0, (String)"[0..1[ should not be empty");
        Assertions.assertTrue((!Range.withLength((int)0, (int)1).isEmpty() ? 1 : 0) != 0, (String)"Range of length 1 should not be empty");
    }

    @Test
    public void splitTest() {
        Range startRange = Range.between((int)0, (int)10);
        Range[] splitRanges = startRange.splitAt(5);
        Assertions.assertEquals((Object)Range.between((int)0, (int)5), (Object)splitRanges[0], (String)"[0..10[ split at 5, lower");
        Assertions.assertEquals((Object)Range.between((int)5, (int)10), (Object)splitRanges[1], (String)"[0..10[ split at 5, upper");
    }

    @Test
    public void split_valueBefore() {
        Range range = Range.between((int)10, (int)20);
        Range[] splitRanges = range.splitAt(5);
        Assertions.assertEquals((Object)Range.between((int)10, (int)10), (Object)splitRanges[0]);
        Assertions.assertEquals((Object)range, (Object)splitRanges[1]);
    }

    @Test
    public void split_valueAfter() {
        Range range = Range.between((int)10, (int)20);
        Range[] splitRanges = range.splitAt(25);
        Assertions.assertEquals((Object)range, (Object)splitRanges[0]);
        Assertions.assertEquals((Object)Range.between((int)20, (int)20), (Object)splitRanges[1]);
    }

    @Test
    public void emptySplitTest() {
        Range range = Range.between((int)5, (int)10);
        Range[] split1 = range.splitAt(0);
        Assertions.assertTrue((boolean)split1[0].isEmpty(), (String)"split1, [0]");
        Assertions.assertEquals((Object)range, (Object)split1[1], (String)"split1, [1]");
        Range[] split2 = range.splitAt(15);
        Assertions.assertEquals((Object)range, (Object)split2[0], (String)"split2, [0]");
        Assertions.assertTrue((boolean)split2[1].isEmpty(), (String)"split2, [1]");
    }

    @Test
    public void lengthTest() {
        Assertions.assertEquals((int)5, (int)Range.withLength((int)10, (int)5).length(), (String)"withLength length");
        Assertions.assertEquals((int)5, (int)Range.between((int)10, (int)15).length(), (String)"between length");
        Assertions.assertEquals((int)1, (int)Range.withOnly((int)10).length(), (String)"withOnly 10 length");
    }

    @Test
    public void intersectsTest() {
        Assertions.assertTrue((boolean)Range.between((int)0, (int)10).intersects(Range.between((int)5, (int)15)), (String)"[0..10[ intersects [5..15[");
        Assertions.assertTrue((!Range.between((int)0, (int)10).intersects(Range.between((int)10, (int)20)) ? 1 : 0) != 0, (String)"[0..10[ does not intersect [10..20[");
    }

    @Test
    public void intersects_emptyInside() {
        Assertions.assertTrue((boolean)Range.between((int)5, (int)5).intersects(Range.between((int)0, (int)10)), (String)"[5..5[ does intersect with [0..10[");
        Assertions.assertTrue((boolean)Range.between((int)0, (int)10).intersects(Range.between((int)5, (int)5)), (String)"[0..10[ does intersect with [5..5[");
    }

    @Test
    public void intersects_emptyOutside() {
        Assertions.assertTrue((!Range.between((int)15, (int)15).intersects(Range.between((int)0, (int)10)) ? 1 : 0) != 0, (String)"[15..15[ does not intersect with [0..10[");
        Assertions.assertTrue((!Range.between((int)0, (int)10).intersects(Range.between((int)15, (int)15)) ? 1 : 0) != 0, (String)"[0..10[ does not intersect with [15..15[");
    }

    @Test
    public void subsetTest() {
        Assertions.assertTrue((boolean)Range.between((int)5, (int)10).isSubsetOf(Range.between((int)0, (int)20)), (String)"[5..10[ is subset of [0..20[");
        Range range = Range.between((int)0, (int)10);
        Assertions.assertTrue((boolean)range.isSubsetOf(range), (String)"range is subset of self");
        Assertions.assertTrue((!Range.between((int)0, (int)10).isSubsetOf(Range.between((int)5, (int)15)) ? 1 : 0) != 0, (String)"[0..10[ is not subset of [5..15[");
    }

    @Test
    public void offsetTest() {
        Assertions.assertEquals((Object)Range.between((int)5, (int)15), (Object)Range.between((int)0, (int)10).offsetBy(5));
    }

    @Test
    public void rangeStartsBeforeTest() {
        Range former = Range.between((int)0, (int)5);
        Range latter = Range.between((int)1, (int)5);
        Assertions.assertTrue((boolean)former.startsBefore(latter), (String)"former should starts before latter");
        Assertions.assertTrue((!latter.startsBefore(former) ? 1 : 0) != 0, (String)"latter shouldn't start before latter");
        Assertions.assertTrue((!Range.between((int)0, (int)5).startsBefore(Range.between((int)0, (int)10)) ? 1 : 0) != 0, (String)"no overlap allowed");
    }

    @Test
    public void rangeStartsAfterTest() {
        Range former = Range.between((int)0, (int)5);
        Range latter = Range.between((int)5, (int)10);
        Assertions.assertTrue((boolean)latter.startsAfter(former), (String)"latter should start after former");
        Assertions.assertTrue((!former.startsAfter(latter) ? 1 : 0) != 0, (String)"former shouldn't start after latter");
        Assertions.assertTrue((!Range.between((int)5, (int)10).startsAfter(Range.between((int)0, (int)6)) ? 1 : 0) != 0, (String)"no overlap allowed");
    }

    @Test
    public void rangeEndsBeforeTest() {
        Range former = Range.between((int)0, (int)5);
        Range latter = Range.between((int)5, (int)10);
        Assertions.assertTrue((boolean)former.endsBefore(latter), (String)"latter should end before former");
        Assertions.assertTrue((!latter.endsBefore(former) ? 1 : 0) != 0, (String)"former shouldn't end before latter");
        Assertions.assertTrue((!Range.between((int)5, (int)10).endsBefore(Range.between((int)9, (int)15)) ? 1 : 0) != 0, (String)"no overlap allowed");
    }

    @Test
    public void rangeEndsAfterTest() {
        Range former = Range.between((int)1, (int)5);
        Range latter = Range.between((int)1, (int)6);
        Assertions.assertTrue((boolean)latter.endsAfter(former), (String)"latter should end after former");
        Assertions.assertTrue((!former.endsAfter(latter) ? 1 : 0) != 0, (String)"former shouldn't end after latter");
        Assertions.assertTrue((!Range.between((int)0, (int)10).endsAfter(Range.between((int)5, (int)10)) ? 1 : 0) != 0, (String)"no overlap allowed");
    }

    @Test
    public void combine_notOverlappingFirstSmaller() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)11, (int)20);
        Assertions.assertThrows(IllegalArgumentException.class, () -> r1.combineWith(r2));
    }

    @Test
    public void combine_notOverlappingSecondLarger() {
        Range r1 = Range.between((int)11, (int)20);
        Range r2 = Range.between((int)0, (int)10);
        Assertions.assertThrows(IllegalArgumentException.class, () -> r1.combineWith(r2));
    }

    @Test
    public void combine_firstEmptyNotOverlapping() {
        Range r1 = Range.between((int)15, (int)15);
        Range r2 = Range.between((int)0, (int)10);
        Assertions.assertThrows(IllegalArgumentException.class, () -> r1.combineWith(r2));
    }

    @Test
    public void combine_secondEmptyNotOverlapping() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)15, (int)15);
        Assertions.assertThrows(IllegalArgumentException.class, () -> r1.combineWith(r2));
    }

    @Test
    public void combine_barelyOverlapping() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)10, (int)20);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assertions.assertEquals((Object)combined1, (Object)combined2);
        Assertions.assertEquals((int)0, (int)combined1.getStart());
        Assertions.assertEquals((int)20, (int)combined1.getEnd());
    }

    @Test
    public void combine_subRange() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)2, (int)8);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assertions.assertEquals((Object)combined1, (Object)combined2);
        Assertions.assertEquals((Object)r1, (Object)combined1);
    }

    @Test
    public void combine_intersecting() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)5, (int)15);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assertions.assertEquals((Object)combined1, (Object)combined2);
        Assertions.assertEquals((int)0, (int)combined1.getStart());
        Assertions.assertEquals((int)15, (int)combined1.getEnd());
    }

    @Test
    public void combine_emptyInside() {
        Range r1 = Range.between((int)0, (int)10);
        Range r2 = Range.between((int)5, (int)5);
        Range combined1 = r1.combineWith(r2);
        Range combined2 = r2.combineWith(r1);
        Assertions.assertEquals((Object)combined1, (Object)combined2);
        Assertions.assertEquals((Object)r1, (Object)combined1);
    }

    @Test
    public void expand_basic() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = r1.expand(2, 3);
        Assertions.assertEquals((Object)Range.between((int)3, (int)13), (Object)r2);
    }

    @Test
    public void expand_negativeLegal() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = r1.expand(-2, -2);
        Assertions.assertEquals((Object)Range.between((int)7, (int)8), (Object)r2);
        Range r3 = r1.expand(-3, -2);
        Assertions.assertEquals((Object)Range.between((int)8, (int)8), (Object)r3);
        Range r4 = r1.expand(3, -8);
        Assertions.assertEquals((Object)Range.between((int)2, (int)2), (Object)r4);
    }

    @Test
    public void expand_negativeIllegal1() {
        Range r1 = Range.between((int)5, (int)10);
        Assertions.assertThrows(IllegalArgumentException.class, () -> r1.expand(-3, -3));
    }

    @Test
    public void expand_negativeIllegal2() {
        Range r1 = Range.between((int)5, (int)10);
        Assertions.assertThrows(IllegalArgumentException.class, () -> r1.expand(3, -9));
    }

    @Test
    public void restrictTo_fullyInside() {
        Range r2;
        Range r3;
        Range r1 = Range.between((int)5, (int)10);
        Assertions.assertTrue((r1 == (r3 = r1.restrictTo(r2 = Range.between((int)4, (int)11))) ? 1 : 0) != 0);
    }

    @Test
    public void restrictTo_fullyOutside() {
        Range r3;
        Range r1 = Range.between((int)4, (int)11);
        Range r2 = Range.between((int)5, (int)10);
        Assertions.assertTrue((r2 == (r3 = r1.restrictTo(r2)) ? 1 : 0) != 0);
    }

    @Test
    public void restrictTo_notInterstecting() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)15, (int)20);
        Range r3 = r1.restrictTo(r2);
        Assertions.assertTrue((boolean)r3.isEmpty(), (String)"Non-intersecting ranges should produce an empty result");
        Range r4 = r2.restrictTo(r1);
        Assertions.assertTrue((boolean)r4.isEmpty(), (String)"Non-intersecting ranges should produce an empty result");
    }

    @Test
    public void restrictTo_startOutside() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)7, (int)15);
        Range r3 = r1.restrictTo(r2);
        Assertions.assertEquals((Object)Range.between((int)7, (int)10), (Object)r3);
        Assertions.assertEquals((Object)r2.restrictTo(r1), (Object)r3);
    }

    @Test
    public void restrictTo_endOutside() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)4, (int)7);
        Range r3 = r1.restrictTo(r2);
        Assertions.assertEquals((Object)Range.between((int)5, (int)7), (Object)r3);
        Assertions.assertEquals((Object)r2.restrictTo(r1), (Object)r3);
    }

    @Test
    public void restrictTo_empty() {
        Range r1 = Range.between((int)5, (int)10);
        Range r2 = Range.between((int)0, (int)0);
        Range r3 = r1.restrictTo(r2);
        Assertions.assertTrue((boolean)r3.isEmpty());
        Range r4 = r2.restrictTo(r1);
        Assertions.assertTrue((boolean)r4.isEmpty());
    }
}

