/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JacksonUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class ConstantPoolTest {
    private ConstantPool constantPool = new ConstantPool();

    ConstantPoolTest() {
    }

    @Test
    public void newConstantPool_noNewItems() {
        Assertions.assertFalse((boolean)this.constantPool.hasNewConstants());
        Assertions.assertEquals((int)0, (int)JacksonUtils.getKeys((JsonNode)this.constantPool.dumpConstants()).size());
    }

    @Test
    public void valueIsRegistered() {
        ConstantPoolKey reference = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        String constantId = this.constantPool.getConstantId(reference);
        Assertions.assertTrue((boolean)this.constantPool.hasNewConstants());
        ObjectNode dump = this.constantPool.dumpConstants();
        Assertions.assertEquals((int)1, (int)JacksonUtils.getKeys((JsonNode)dump).size());
        Assertions.assertEquals((Object)"{}", (Object)dump.get(constantId).toString());
    }

    @Test
    public void sameValue_sameId() {
        ConstantPoolKey reference = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        String constantId = this.constantPool.getConstantId(reference);
        this.constantPool.dumpConstants();
        String otherId = this.constantPool.getConstantId(new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode()));
        Assertions.assertEquals((Object)constantId, (Object)otherId);
        Assertions.assertFalse((boolean)this.constantPool.hasNewConstants());
    }

    @Test
    public void differentValue_differentId() {
        ConstantPoolKey reference = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        String constantId = this.constantPool.getConstantId(reference);
        this.constantPool.dumpConstants();
        String otherId = this.constantPool.getConstantId(new ConstantPoolKey((JsonNode)JacksonUtils.createArrayNode()));
        Assertions.assertNotEquals((Object)constantId, (Object)otherId);
        Assertions.assertTrue((boolean)this.constantPool.hasNewConstants());
    }

    @Test
    public void constantPoolKey_exportedDirectly_idCreated() {
        ConstantPoolKey constantPoolKey = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        ObjectNode message = JacksonUtils.createObjectNode();
        constantPoolKey.export(message);
        Assertions.assertTrue((boolean)message.has(constantPoolKey.getId()));
    }
}

