/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ElementBindEnabledTest
extends SignalsUnitTest {
    ElementBindEnabledTest() {
    }

    @Test
    public void bindEnabled_elementAttachedBefore_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertTrue((boolean)element.isEnabled());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindEnabled((Signal)signal);
        Assertions.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementAttachedAfter_bindingActive() {
        Element element = new Element("foo");
        Assertions.assertTrue((boolean)element.isEnabled());
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindEnabled((Signal)signal);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementAttached_bindingActive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)false);
        element.bindEnabled((Signal)signal);
        Assertions.assertFalse((boolean)element.isEnabled());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)element.isEnabled());
        signal.set(null);
        Assertions.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementNotAttached_bindingInactive() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        signal.set((Object)false);
        Assertions.assertTrue((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementDetached_bindingInactive() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        element.removeFromParent();
        signal.set((Object)false);
        Assertions.assertTrue((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_elementReAttached_bindingActivate() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        element.removeFromParent();
        signal.set((Object)false);
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_setEnabledAndBindEnabledWhileBindingIsActive_throwException() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.bindEnabled((Signal)new ValueSignal((Object)true));
        Assertions.assertThrows(BindingActiveException.class, () -> element.setEnabled(false));
        Assertions.assertThrows(BindingActiveException.class, () -> element.bindEnabled((Signal)new ValueSignal((Object)true)));
        Assertions.assertTrue((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_nullSignal_throwsNPE() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        Assertions.assertThrows(NullPointerException.class, () -> element.bindEnabled(null));
    }

    @Test
    public void bindEnabled_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        Assertions.assertTrue((boolean)element.isEnabled());
        SignalBindingFeature feature = (SignalBindingFeature)element.getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("enabled");
        signal.set((Object)false);
        Assertions.assertTrue((boolean)element.isEnabled());
        element.setEnabled(false);
        Assertions.assertFalse((boolean)element.isEnabled());
    }

    @Test
    public void bindEnabled_lazyInitSignalBindingFeature() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        element.setEnabled(false);
        element.isEnabled();
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> Assertions.fail((String)"SignalBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)true);
        element.bindEnabled((Signal)signal);
        element.getNode().getFeatureIfInitialized(SignalBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"SignalBindingFeature should be initialized after binding a signal"));
    }

    @Test
    public void bindEnabled_implicitlyDisabledComponent_isEnabledReturnsFalse() {
        TestComponent component = new TestComponent();
        component.bindEnabled((Signal)new ValueSignal((Object)true));
        TestComponent parent = new TestComponent();
        parent.setEnabled(false);
        parent.add(new Component[]{component});
        UI.getCurrent().add(new Component[]{parent});
        Assertions.assertFalse((boolean)component.isEnabled());
    }

    @Test
    public void bindEnabled_implicitlyDisabledComponent_detach_componentBecomesEnabled() {
        TestComponent component = new TestComponent();
        component.bindEnabled((Signal)new ValueSignal((Object)true));
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        UI.getCurrent().add(new Component[]{parent});
        parent.setEnabled(false);
        parent.remove(new Component[]{component});
        Assertions.assertTrue((boolean)component.isEnabled());
    }

    @Test
    public void bindEnabled_explicitlyDisabledComponent_enableParent_componentRemainsDisabled() {
        TestComponent component = new TestComponent();
        component.bindEnabled((Signal)new ValueSignal((Object)false));
        TestComponent parent = new TestComponent();
        parent.add(new Component[]{component});
        UI.getCurrent().add(new Component[]{parent});
        parent.setEnabled(false);
        Assertions.assertFalse((boolean)component.isEnabled());
        parent.setEnabled(true);
        Assertions.assertFalse((boolean)component.isEnabled());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component
    implements HasComponents {
        private TestComponent() {
        }
    }
}

