/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HtmlBindHtmlContentTest
extends SignalsUnitTest {
    @Test
    public void bindHtmlContent_componentAttachedBefore_bindingActive() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        Assertions.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentAttachedAfter_bindingActive() {
        Html html = new Html("<div id='a'>init</div>");
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        UI.getCurrent().add(new Component[]{html});
        Assertions.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentAttached_bindingActive_updatesOnChange() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>v1</div>");
        html.bindHtmlContent((Signal)signal);
        Assertions.assertEquals((Object)"v1", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
        signal.set((Object)"<div id='c'>v2</div>");
        Assertions.assertEquals((Object)"v2", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"c", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentNotAttached_bindingInactive() {
        Html html = new Html("<div id='a'>init</div>");
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        signal.set((Object)"<div id='c'>ignored</div>");
        Assertions.assertEquals((Object)"init", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"a", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentDetached_bindingInactive() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        html.getElement().removeFromParent();
        signal.set((Object)"<div id='c'>ignored</div>");
        Assertions.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_componentReAttached_bindingActivate() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        html.getElement().removeFromParent();
        signal.set((Object)"<div id='c'>after2</div>");
        UI.getCurrent().add(new Component[]{html});
        Assertions.assertEquals((Object)"after2", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"c", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_withNullValue_recordsErrorAndDoesNotChange() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        signal.set(null);
        Assertions.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
        Assertions.assertEquals((int)1, (int)this.events.size());
        Assertions.assertEquals(NullPointerException.class, ((ErrorEvent)this.events.getFirst()).getThrowable().getClass());
        this.events.clear();
    }

    @Test
    public void bindHtmlContent_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        Assertions.assertEquals((Object)"after", (Object)html.getInnerHtml());
        SignalBindingFeature feature = (SignalBindingFeature)html.getElement().getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("htmlContent");
        signal.set((Object)"<div id='c'>ignored</div>");
        Assertions.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
        html.setHtmlContent("<div id='d'>manual</div>");
        Assertions.assertEquals((Object)"manual", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"d", (Object)html.getElement().getAttribute("id"));
    }

    @Test
    public void bindHtmlContent_nullSignal_throwsNPE() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        Assertions.assertThrows(NullPointerException.class, () -> html.bindHtmlContent(null));
    }

    @Test
    public void bindHtmlContent_setterAndRebindWhileActive_throwException() {
        Html html = new Html("<div id='a'>init</div>");
        UI.getCurrent().add(new Component[]{html});
        ValueSignal signal = new ValueSignal((Object)"<div id='b'>after</div>");
        html.bindHtmlContent((Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> html.setHtmlContent("<div id='c'>manual</div>"));
        Assertions.assertThrows(BindingActiveException.class, () -> html.bindHtmlContent((Signal)new ValueSignal((Object)"<div>x</div>")));
        Assertions.assertEquals((Object)"after", (Object)html.getInnerHtml());
        Assertions.assertEquals((Object)"b", (Object)html.getElement().getAttribute("id"));
    }
}

