/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HasValueBindReadOnlyTest
extends SignalsUnitTest {
    @Test
    public void bindReadOnly_elementAttachedBefore_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertFalse((boolean)component.isReadOnly());
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assertions.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementAttachedAfter_bindingActive() {
        TestComponent component = new TestComponent();
        Assertions.assertFalse((boolean)component.isReadOnly());
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assertions.assertTrue((boolean)component.isReadOnly());
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.isReadOnly());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementNotAttached_bindingInactive() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementDetached_bindingInactive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        component.removeFromParent();
        signal.set((Object)false);
        Assertions.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_elementReAttached_bindingActivate() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        component.removeFromParent();
        signal.set((Object)false);
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_bindOrSetReadOnlyWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        component.bindReadOnly((Signal)new ValueSignal((Object)true));
        Assertions.assertThrows(BindingActiveException.class, () -> component.bindReadOnly((Signal)new ValueSignal((Object)false)));
        Assertions.assertThrows(BindingActiveException.class, () -> component.setReadOnly(false));
        Assertions.assertTrue((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_nullSignal_throwsNPE() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertThrows(NullPointerException.class, () -> component.bindReadOnly(null));
    }

    @Test
    public void bindReadOnly_nullSignalValue_setsReadOnlyToFalse() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindReadOnly((Signal)signal);
        Assertions.assertTrue((boolean)component.isReadOnly());
        signal.set(null);
        Assertions.assertFalse((boolean)component.isReadOnly());
    }

    @Test
    public void bindReadOnly_toggleSignalValue_readOnlyUpdates() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindReadOnly((Signal)signal);
        Assertions.assertFalse((boolean)component.isReadOnly());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.isReadOnly());
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.isReadOnly());
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.isReadOnly());
    }

    @Tag(value="input")
    private static class TestComponent
    extends AbstractField<TestComponent, String> {
        public TestComponent() {
            super((Object)"");
        }

        protected void setPresentationValue(String newPresentationValue) {
        }
    }
}

