/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class HasSizeUnitTest {
    @Test
    public void setWidthFloat() {
        HasSizeComponent c = new HasSizeComponent();
        for (Unit unit : Unit.values()) {
            c.setWidth(100.0f, unit);
            Assert.assertEquals((Object)("100.0" + unit.toString()), (Object)c.getWidth());
        }
    }

    @Test
    public void setMinWidthFloat() {
        HasSizeComponent c = new HasSizeComponent();
        for (Unit unit : Unit.values()) {
            c.setMinWidth(100.0f, unit);
            Assert.assertEquals((Object)("100.0" + unit.toString()), (Object)c.getMinWidth());
        }
    }

    @Test
    public void setMaxWidthFloat() {
        HasSizeComponent c = new HasSizeComponent();
        for (Unit unit : Unit.values()) {
            c.setMaxWidth(100.0f, unit);
            Assert.assertEquals((Object)("100.0" + unit.toString()), (Object)c.getMaxWidth());
        }
    }

    @Test
    public void setHeightFloat() {
        HasSizeComponent c = new HasSizeComponent();
        for (Unit unit : Unit.values()) {
            c.setHeight(100.0f, unit);
            Assert.assertEquals((Object)("100.0" + unit.toString()), (Object)c.getHeight());
        }
    }

    @Test
    public void setMinHeightFloat() {
        HasSizeComponent c = new HasSizeComponent();
        for (Unit unit : Unit.values()) {
            c.setMinHeight(100.0f, unit);
            Assert.assertEquals((Object)("100.0" + unit.toString()), (Object)c.getMinHeight());
        }
    }

    @Test
    public void setMaxHeightFloat() {
        HasSizeComponent c = new HasSizeComponent();
        for (Unit unit : Unit.values()) {
            c.setMaxHeight(100.0f, unit);
            Assert.assertEquals((Object)("100.0" + unit.toString()), (Object)c.getMaxHeight());
        }
    }

    @Test
    public void getUnit() {
        for (Unit unit : Unit.values()) {
            String cssSize = "100.0" + unit.toString();
            Optional theUnit = Unit.getUnit((String)cssSize);
            Assert.assertTrue((boolean)theUnit.isPresent());
            Assert.assertEquals(theUnit.get(), (Object)unit);
        }
    }

    @Test
    public void getSize() {
        float size;
        Object cssSize;
        for (Unit unit : Unit.values()) {
            cssSize = "100.0" + unit.toString();
            size = Unit.getSize((String)cssSize);
            Assert.assertEquals((double)100.0, (double)size, (double)0.01);
        }
        for (Unit unit : Unit.values()) {
            cssSize = unit.toString();
            size = Unit.getSize((String)cssSize);
            Assert.assertEquals((double)0.0, (double)size, (double)0.01);
        }
    }

    @Test(expected=NumberFormatException.class)
    public void getSizeException() {
        String cssSize = "10a0px";
        float size = Unit.getSize((String)cssSize);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSizeNoUnit() {
        String cssSize = "100";
        float size = Unit.getSize((String)cssSize);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSizeNoValidUnit() {
        String cssSize = "100p";
        float size = Unit.getSize((String)cssSize);
    }

    @Tag(value="div")
    public static class HasSizeComponent
    extends Component
    implements HasSize {
    }
}

