/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBusUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.MappedToDomEvent;
import com.vaadin.flow.internal.ReflectionCache;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.junit.Assert;
import org.junit.Test;

public class ComponentEventBusUtilTest {
    @Test
    public void domEvent_constructorCached() {
        ReflectionCache cache = ComponentEventBusUtil.cache;
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        cache.clear();
        Assert.assertFalse((boolean)cache.contains(MappedToDomEvent.class));
        component.addListener(MappedToDomEvent.class, (ComponentEventListener & Serializable)e -> {});
        Assert.assertTrue((boolean)cache.contains(MappedToDomEvent.class));
    }

    @Test
    public void domEvent_dataExpressionCached() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ReflectionCache cache = ComponentEventBusUtil.cache;
        cache.clear();
        Assert.assertFalse((boolean)cache.contains(MappedToDomEvent.class));
        component.addListener(MappedToDomEvent.class, (ComponentEventListener & Serializable)e -> {});
        Assert.assertTrue((boolean)cache.contains(MappedToDomEvent.class));
    }

    @Test
    public void domEvent_innerEventClass() {
        try {
            ComponentEventBusUtil.getEventConstructor(InnerClass.class);
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)("Cannot instantiate '" + InnerClass.class.getName() + "'. Make sure the class is static if it is an inner class."), (Object)exception.getMessage());
        }
    }

    @Test
    public void domEvent_nestedEventClass() {
        Constructor ctor = ComponentEventBusUtil.getEventConstructor(NestedClass.class);
        Assert.assertNotNull((Object)ctor);
    }

    @Test
    public void domEvent_localEventClass() {
        @DomEvent(value="dom-event")
        class LocalClass
        extends ComponentEvent<Component> {
            public LocalClass(Component source, boolean fromClient) {
                super(source, fromClient);
            }
        }
        try {
            ComponentEventBusUtil.getEventConstructor(LocalClass.class);
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)("Cannot instantiate local class '" + LocalClass.class.getName() + "'. Move class declaration outside the method."), (Object)exception.getMessage());
        }
    }

    @DomEvent(value="dom-event")
    public class InnerClass
    extends ComponentEvent<Component> {
        public InnerClass(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }

    @DomEvent(value="dom-event")
    public static class NestedClass
    extends ComponentEvent<Component> {
        public NestedClass(Component source, boolean fromClient) {
            super(source, fromClient);
        }
    }
}

