/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.EventWithBeanData;
import com.vaadin.flow.component.InvalidMappedToDomEvent;
import com.vaadin.flow.component.KeyPressEvent;
import com.vaadin.flow.component.KeyUpEvent;
import com.vaadin.flow.component.MappedDomEventWithComponentData;
import com.vaadin.flow.component.MappedDomEventWithRouterLinkData;
import com.vaadin.flow.component.MappedToDomEvent;
import com.vaadin.flow.component.MappedToDomEventMultipleConstructors;
import com.vaadin.flow.component.MappedToDomEventWithAllowInert;
import com.vaadin.flow.component.MappedToDomEventWithElementData;
import com.vaadin.flow.component.MappedToDomInvalidEventData;
import com.vaadin.flow.component.MappedToDomNoDataEvent;
import com.vaadin.flow.component.ServerEvent;
import com.vaadin.flow.component.ServerNoDataEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.TestComponentWithServerEvent;
import com.vaadin.flow.component.internal.KeyboardEvent;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.MessageDigestUtil;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.shared.Registration;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class ComponentEventBusTest {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private int calls = 0;

    private void fireDomEvent(Component component, String domEvent, JsonNode eventData) {
        Element e = component.getElement();
        ((ElementListenerMap)e.getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(e, domEvent, eventData));
    }

    @Test
    public void mappedDomEvent_fire() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        component.addListener(MappedToDomEvent.class, eventTracker);
        component.getEventBus().fireEvent((ComponentEvent)new MappedToDomEvent(component));
        eventTracker.assertEventCalled(component, false);
        Assert.assertEquals((long)32L, (long)((MappedToDomEvent)((Object)eventTracker.getEvent())).getSomeData());
        Assert.assertEquals((Object)"Default constructor", (Object)((MappedToDomEvent)((Object)eventTracker.getEvent())).getMoreData());
        eventTracker.reset();
        component.getEventBus().fireEvent((ComponentEvent)new MappedToDomEvent(component, true));
        eventTracker.assertEventCalled(component, true);
        Assert.assertEquals((long)12L, (long)((MappedToDomEvent)((Object)eventTracker.getEvent())).getSomeData());
        Assert.assertEquals((Object)"Two arg constructor", (Object)((MappedToDomEvent)((Object)eventTracker.getEvent())).getMoreData());
    }

    @Test
    public void serverEvent_fire() {
        AtomicInteger eventHandlerCalled = new AtomicInteger(0);
        AtomicReference<BigDecimal> dataValueInEvent = new AtomicReference<BigDecimal>(new BigDecimal(0));
        TestComponentWithServerEvent component = new TestComponentWithServerEvent();
        component.addServerEventListener((ComponentEventListener<ServerEvent>)(ComponentEventListener & Serializable)e -> {
            eventHandlerCalled.incrementAndGet();
            dataValueInEvent.set(e.getSomeValue());
        });
        component.fireEvent(new ServerEvent(component, new BigDecimal("12.22")));
        Assert.assertEquals((long)1L, (long)eventHandlerCalled.get());
        Assert.assertEquals((Object)new BigDecimal("12.22"), (Object)dataValueInEvent.get());
    }

    @Test
    public void serverNoDataEvent_fire() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        c.addListener(ServerNoDataEvent.class, eventTracker);
        c.fireEvent(new ServerNoDataEvent(c, false));
        eventTracker.assertEventCalled(c, false);
        Assert.assertFalse((boolean)((ServerNoDataEvent)((Object)eventTracker.getEvent())).isFromClient());
    }

    @Test
    public void serverNoDataEvent_fire_noListeners() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        c.fireEvent(new ServerNoDataEvent(c, false));
    }

    @Test
    public void mappedDomEvent_fire_noListeners() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        this.fireDomEvent(c, "dom-event", this.createMinimalEventData());
    }

    @Test
    public void mappedDomEvent_fire_missingData() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        EventTracker eventListener = new EventTracker();
        c.addListener(MappedToDomEvent.class, eventListener);
        this.fireDomEvent(c, "dom-event", this.createData("event.someData", 2));
        eventListener.assertEventCalled(c, true);
        Assert.assertEquals((long)2L, (long)((MappedToDomEvent)((Object)eventListener.getEvent())).getSomeData());
        Assert.assertNull((Object)((MappedToDomEvent)((Object)eventListener.getEvent())).getMoreData());
        Assert.assertFalse((boolean)((MappedToDomEvent)((Object)eventListener.getEvent())).getPrimitiveBoolean());
        Assert.assertNull((Object)((MappedToDomEvent)((Object)eventListener.getEvent())).getObjectBoolean());
    }

    @Test
    public void mappedDomEventWithElementEventData_clientReportsElement_mapsElement() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent child = new ComponentTest.TestComponent();
        component.getElement().appendChild(new Element[]{child.getElement()});
        ui.add(new Component[]{component});
        EventTracker listener = new EventTracker();
        component.addListener(MappedToDomEventWithElementData.class, listener);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("element", child.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        Assert.assertEquals((Object)child.getElement(), (Object)((MappedToDomEventWithElementData)((Object)listener.getEvent())).getElement());
    }

    @Test
    public void mappedDomEventWithComponentEventData_clientReportsTypeComponent_mapsComponent() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent child = new ComponentTest.TestComponent();
        component.getElement().appendChild(new Element[]{child.getElement()});
        ui.add(new Component[]{component});
        EventTracker listener = new EventTracker();
        component.addListener(MappedDomEventWithComponentData.class, listener);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("component", child.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        Assert.assertEquals((Object)child, (Object)((MappedDomEventWithComponentData)((Object)listener.getEvent())).getComponent());
    }

    @Test
    public void mappedDomEventWithComponentEventData_clientReportsConcreteComponents_mapsComponents() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent child = new ComponentTest.TestComponent();
        RouterLink routerLink = new RouterLink();
        component.getElement().appendChild(new Element[]{child.getElement()});
        child.getElement().appendChild(new Element[]{routerLink.getElement()});
        ui.add(new Component[]{component});
        EventTracker listener = new EventTracker();
        component.addListener(MappedDomEventWithRouterLinkData.class, listener);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("component", child.getElement().getNode().getId(), "router.link", routerLink.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        Assert.assertEquals((Object)routerLink, (Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getRouterLink());
        Assert.assertEquals((Object)child, (Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getComponent());
    }

    @Test
    public void mappedDomEventWithComponentEventData_clientReportsMissingComponent_mapsComponentAndNull() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent child = new ComponentTest.TestComponent();
        RouterLink routerLink = new RouterLink();
        component.getElement().appendChild(new Element[]{child.getElement()});
        child.getElement().appendChild(new Element[]{routerLink.getElement()});
        ui.add(new Component[]{component});
        EventTracker listener = new EventTracker();
        component.addListener(MappedDomEventWithRouterLinkData.class, listener);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("component", routerLink.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        Assert.assertNull((Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getRouterLink());
        Assert.assertEquals((Object)routerLink, (Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getComponent());
        listener.reset();
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("router.link", routerLink.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        Assert.assertEquals((Object)routerLink, (Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getRouterLink());
        Assert.assertNull((Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getComponent());
        listener.reset();
    }

    @Test
    public void mappedDomEventWithComponentEventData_clientReportsSiblingComponentToEventSource_mapsComponents() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent child = new ComponentTest.TestComponent();
        RouterLink routerLink = new RouterLink();
        ui.add(new Component[]{component, child, routerLink});
        EventTracker listener = new EventTracker();
        component.addListener(MappedDomEventWithRouterLinkData.class, listener);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("component", component.getElement().getNode().getId(), "router.link", routerLink.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        Assert.assertEquals((Object)routerLink, (Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getRouterLink());
        Assert.assertEquals((Object)component, (Object)((MappedDomEventWithRouterLinkData)((Object)listener.getEvent())).getComponent());
    }

    @Test
    public void mappedDomEventWithComponentEventData_clientReportsElementMissing_returnsNull() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent child = new ComponentTest.TestComponent();
        component.getElement().appendChild(new Element[]{child.getElement()});
        ui.add(new Component[]{component});
        EventTracker listener = new EventTracker();
        component.addListener(MappedDomEventWithComponentData.class, listener);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("component", -1));
        listener.assertEventCalled(component, true);
        Assert.assertNull((Object)((MappedDomEventWithComponentData)((Object)listener.getEvent())).getComponent());
    }

    @Test
    public void mappedDomEventWithComponentEventData_clientReportsMissingNodeIdReported_returnsNull() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent child = new ComponentTest.TestComponent();
        component.getElement().appendChild(new Element[]{child.getElement()});
        ui.add(new Component[]{component});
        EventTracker listener = new EventTracker();
        component.addListener(MappedDomEventWithComponentData.class, listener);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("component", 999999999));
        listener.assertEventCalled(component, true);
        Assert.assertNull((Object)((MappedDomEventWithComponentData)((Object)listener.getEvent())).getComponent());
    }

    @Test
    public void mappedDomEventWithElementOrComponentEventData_clientReportsStateNodeForInvisibleComponent_returnsNull() {
        MockUI ui = new MockUI();
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentTest.TestComponent invisible = new ComponentTest.TestComponent();
        component.getElement().appendChild(new Element[]{invisible.getElement()});
        ui.add(new Component[]{component});
        EventTracker listener = new EventTracker();
        component.addListener(MappedToDomEventWithElementData.class, listener);
        invisible.setVisible(false);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("element", invisible.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        Assert.assertNull((String)"Invisible elements/components should not be reported", (Object)((MappedToDomEventWithElementData)((Object)listener.getEvent())).getElement());
        listener.reset();
        EventTracker second = new EventTracker();
        component.addListener(MappedDomEventWithComponentData.class, second);
        this.fireDomEvent(component, "dom-event", this.createStateNodeIdData("component", invisible.getElement().getNode().getId()));
        listener.assertEventCalled(component, true);
        second.assertEventCalled(component, true);
        Assert.assertNull((String)"Invisible elements/components should not be reported", (Object)((MappedToDomEventWithElementData)((Object)listener.getEvent())).getElement());
        Assert.assertNull((String)"Invisible elements/components should not be reported", (Object)((MappedDomEventWithComponentData)((Object)second.getEvent())).getComponent());
    }

    private JsonNode createStateNodeIdData(String key, int value) {
        return this.createData("]" + key, value);
    }

    private JsonNode createStateNodeIdData(String key, int value, String key2, int value2) {
        return this.createData("]" + key, value, "]" + key2, value2);
    }

    private JsonNode createData(String key, Object value) {
        ObjectNode data = JacksonUtils.createObjectNode();
        data.set(key, JacksonCodec.encodeWithoutTypeInfo((Object)value));
        return data;
    }

    private JsonNode createData(String key, Object value, String key2, Object value2) {
        ObjectNode data = JacksonUtils.createObjectNode();
        data.set(key, JacksonCodec.encodeWithoutTypeInfo((Object)value));
        data.set(key2, JacksonCodec.encodeWithoutTypeInfo((Object)value2));
        return data;
    }

    private JsonNode createCompleteEventData(int someData, String moreData) {
        ObjectNode data = JacksonUtils.createObjectNode();
        data.set("event.someData", JacksonCodec.encodeWithoutTypeInfo((Object)someData));
        data.set("event.moreData", JacksonCodec.encodeWithoutTypeInfo((Object)moreData));
        data.set("event.primitiveBoolean", JacksonCodec.encodeWithoutTypeInfo((Object)false));
        data.set("event.objectBoolean", JacksonCodec.encodeWithoutTypeInfo(null));
        return data;
    }

    private JsonNode createMinimalEventData() {
        return this.createCompleteEventData(0, "");
    }

    @Test
    public void domEvent_removeListener() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        Registration remover = component.addListener(MappedToDomEvent.class, eventTracker);
        remover.remove();
        JsonNode eventData = this.createCompleteEventData(42, "1");
        this.fireDomEvent(component, "dom-event", eventData);
        eventTracker.assertEventNotCalled();
        this.assertNoListeners(component.getEventBus());
    }

    private void assertNoListeners(ComponentEventBus eventBus) {
        Assert.assertTrue((boolean)eventBus.componentEventData.isEmpty());
    }

    @Test
    public void domEvent_fireClientEvent() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        component.addListener(MappedToDomEvent.class, eventTracker);
        JsonNode eventData = this.createCompleteEventData(42, "1");
        this.fireDomEvent(component, "dom-event", eventData);
        eventTracker.assertEventCalled(component, true);
        MappedToDomEvent event = (MappedToDomEvent)((Object)eventTracker.getEvent());
        Assert.assertEquals((long)42L, (long)event.getSomeData());
        Assert.assertEquals((Object)"1", (Object)event.getMoreData());
        Assert.assertFalse((boolean)event.getPrimitiveBoolean());
        Assert.assertNull((Object)event.getObjectBoolean());
    }

    @Test
    public void domEvent_fireServerEvent() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        component.addListener(MappedToDomEvent.class, eventTracker);
        JsonNode eventData = this.createCompleteEventData(42, "1");
        this.fireDomEvent(component, "dom-event", eventData);
        eventTracker.assertEventCalled(component, true);
        MappedToDomEvent event = (MappedToDomEvent)((Object)eventTracker.getEvent());
        Assert.assertEquals((long)42L, (long)event.getSomeData());
        Assert.assertEquals((Object)"1", (Object)event.getMoreData());
        Assert.assertFalse((boolean)event.getPrimitiveBoolean());
        Assert.assertNull((Object)event.getObjectBoolean());
    }

    @Test
    public void nonDomEvent_removeListener() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        Registration remover = component.addListener(ServerEvent.class, eventTracker);
        remover.remove();
        component.fireEvent(new ServerEvent(component, new BigDecimal("12.2")));
        eventTracker.assertEventNotCalled();
        this.assertNoListeners(component.getEventBus());
    }

    @Test
    public void nonDomEvent_fireEvent() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        component.addListener(ServerEvent.class, eventTracker);
        component.fireEvent(new ServerEvent(component, new BigDecimal("12.2")));
        eventTracker.assertEventCalled(component, false);
    }

    @Test
    public void domEvent_addListenerWithDomListenerConsumer() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        component.getEventBus().addListener(MappedToDomEvent.class, eventTracker, domRegistration -> domRegistration.debounce(200));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonDomEvent_addListenerWithDomListenerConsumer_throws() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        component.getEventBus().addListener(ServerEvent.class, eventTracker, domRegistration -> domRegistration.debounce(200));
    }

    @Test
    public void domEvent_addSameListenerTwice() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        ComponentEventListener & Serializable listener = (ComponentEventListener & Serializable)e -> ++this.calls;
        Registration reg1 = component.addListener(MappedToDomEvent.class, listener);
        Registration reg2 = component.addListener(MappedToDomEvent.class, listener);
        Assert.assertEquals((long)1L, (long)component.getEventBus().componentEventData.size());
        Assert.assertEquals((long)2L, (long)((ArrayList)component.getEventBus().componentEventData.get(MappedToDomEvent.class)).size());
        this.fireDomEvent(component, "dom-event", this.createMinimalEventData());
        Assert.assertEquals((long)2L, (long)this.calls);
        reg1.remove();
        Assert.assertEquals((long)1L, (long)component.getEventBus().componentEventData.size());
        Assert.assertEquals((long)1L, (long)((ArrayList)component.getEventBus().componentEventData.get(MappedToDomEvent.class)).size());
        this.fireDomEvent(component, "dom-event", this.createMinimalEventData());
        Assert.assertEquals((long)3L, (long)this.calls);
        reg2.remove();
        Assert.assertEquals((long)0L, (long)component.getEventBus().componentEventData.size());
        this.fireDomEvent(component, "dom-event", this.createMinimalEventData());
        Assert.assertEquals((long)3L, (long)this.calls);
    }

    @Test
    public void multipleEventsForSameDomEvent_removeListener() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        EventTracker eventTracker2 = new EventTracker();
        Registration remover = component.addListener(MappedToDomEvent.class, eventTracker);
        Registration remover2 = component.addListener(MappedToDomNoDataEvent.class, eventTracker2);
        remover.remove();
        JsonNode eventData = this.createCompleteEventData(42, "1");
        this.fireDomEvent(component, "dom-event", eventData);
        eventTracker.assertEventNotCalled();
        eventTracker2.assertEventCalled(component, true);
        remover2.remove();
        this.assertNoListeners(component.getEventBus());
    }

    @Test
    public void multipleEventsForSameDomEvent_fireEvent() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        EventTracker eventTracker2 = new EventTracker();
        component.addListener(MappedToDomEvent.class, eventTracker);
        component.addListener(MappedToDomNoDataEvent.class, eventTracker2);
        JsonNode eventData = this.createCompleteEventData(42, "19");
        this.fireDomEvent(component, "dom-event", eventData);
        eventTracker.assertEventCalled(component, true);
        Assert.assertEquals((Object)"19", (Object)((MappedToDomEvent)((Object)eventTracker.getEvent())).getMoreData());
        Assert.assertEquals((long)42L, (long)((MappedToDomEvent)((Object)eventTracker.getEvent())).getSomeData());
        Assert.assertEquals((Object)component, (Object)((MappedToDomEvent)((Object)eventTracker.getEvent())).getSource());
        eventTracker2.assertEventCalled(component, true);
    }

    @Test
    public void multipleListenersForSameEvent_fireEvent() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        EventTracker eventTracker2 = new EventTracker();
        component.addListener(MappedToDomEvent.class, eventTracker);
        component.addListener(MappedToDomEvent.class, eventTracker2);
        JsonNode eventData = this.createCompleteEventData(42, "19");
        this.fireDomEvent(component, "dom-event", eventData);
        eventTracker.assertEventCalled(component, true);
        eventTracker2.assertEventCalled(component, true);
        Assert.assertEquals((Object)"19", (Object)((MappedToDomEvent)((Object)eventTracker.getEvent())).getMoreData());
        Assert.assertEquals((Object)"19", (Object)((MappedToDomEvent)((Object)eventTracker2.getEvent())).getMoreData());
        Assert.assertEquals((long)42L, (long)((MappedToDomEvent)((Object)eventTracker.getEvent())).getSomeData());
        Assert.assertEquals((long)42L, (long)((MappedToDomEvent)((Object)eventTracker2.getEvent())).getSomeData());
        Assert.assertEquals((Object)component, (Object)((MappedToDomEvent)((Object)eventTracker.getEvent())).getSource());
        Assert.assertEquals((Object)component, (Object)((MappedToDomEvent)((Object)eventTracker2.getEvent())).getSource());
    }

    @Test
    public void multipleListenersForSameEvent_removeListener() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        EventTracker eventTracker2 = new EventTracker();
        Registration remover = component.addListener(MappedToDomEvent.class, eventTracker);
        Registration remover2 = component.addListener(MappedToDomEvent.class, eventTracker2);
        remover.remove();
        JsonNode eventData = this.createCompleteEventData(42, "19");
        this.fireDomEvent(component, "dom-event", eventData);
        eventTracker.assertEventNotCalled();
        eventTracker2.assertEventCalled(component, true);
        Assert.assertEquals((Object)"19", (Object)((MappedToDomEvent)((Object)eventTracker2.getEvent())).getMoreData());
        Assert.assertEquals((long)42L, (long)((MappedToDomEvent)((Object)eventTracker2.getEvent())).getSomeData());
        Assert.assertEquals((Object)component, (Object)((MappedToDomEvent)((Object)eventTracker2.getEvent())).getSource());
        remover2.remove();
        this.assertNoListeners(component.getEventBus());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidEventConstructor_addListener() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        c.addListener(InvalidMappedToDomEvent.class, (ComponentEventListener & Serializable)e -> {});
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidEventDataInConstructor_addListener() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        c.addListener(MappedToDomInvalidEventData.class, (ComponentEventListener & Serializable)e -> {});
    }

    @Test(expected=IllegalArgumentException.class)
    public void multipleEventDataConstructors_addListener() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        c.addListener(MappedToDomEventMultipleConstructors.class, (ComponentEventListener & Serializable)e -> {});
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasListeners_nullEventType_throws() {
        new ComponentEventBus((Component)new ComponentTest.TestComponent()).hasListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getListeners_nullEventType_throws() {
        new ComponentEventBus((Component)new ComponentTest.TestComponent()).getListeners(null);
    }

    @Test
    public void getListeners_eventType_listenersCollection() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        Registration remover = component.addListener(MappedToDomEvent.class, eventTracker);
        Collection listeners = component.getListeners(MappedToDomEvent.class);
        Assert.assertEquals((long)1L, (long)listeners.size());
        remover.remove();
    }

    @Test
    public void getListeners_subclassOfEventType_listenersCollection() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        EventTracker eventTracker2 = new EventTracker();
        Registration remover = component.addListener(KeyPressEvent.class, eventTracker);
        Registration remover2 = component.addListener(KeyUpEvent.class, eventTracker2);
        Collection listeners = component.getListeners(KeyboardEvent.class);
        Assert.assertEquals((long)2L, (long)listeners.size());
        remover.remove();
        remover2.remove();
    }

    @Test
    public void getListeners_notExistingEventType_emptyListenersCollection() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        Registration remover = component.addListener(MappedToDomEvent.class, eventTracker);
        Collection listeners = component.getListeners(ServerEvent.class);
        Assert.assertTrue((boolean)listeners.isEmpty());
        remover.remove();
    }

    @Test
    public void testFireEvent_noListeners_eventBusNotCreated() {
        final AtomicInteger eventBusCreated = new AtomicInteger();
        ComponentTest.TestComponent c = new ComponentTest.TestComponent(){

            @Override
            public ComponentEventBus getEventBus() {
                eventBusCreated.incrementAndGet();
                return super.getEventBus();
            }
        };
        c.fireEvent(new ServerEvent(c, new BigDecimal(0)));
        Assert.assertEquals((long)0L, (long)eventBusCreated.get());
    }

    @Test
    public void eventUnregisterListener_insideListener() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        c.addListener(ServerEvent.class, (ComponentEventListener & Serializable)e -> e.unregisterListener());
        Assert.assertTrue((boolean)c.hasListener(ServerEvent.class));
        c.fireEvent(new ServerEvent(c, new BigDecimal(0)));
        Assert.assertFalse((boolean)c.hasListener(ServerEvent.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void eventUnregisterListener_insideListenerTwiceThrows() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        c.addListener(ServerEvent.class, (ComponentEventListener & Serializable)e -> {
            e.unregisterListener();
            e.unregisterListener();
        });
        c.fireEvent(new ServerEvent(c, new BigDecimal(0)));
    }

    @Test(expected=IllegalStateException.class)
    public void eventUnregisterListener_outsideListenerTwiceThrows() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        AtomicReference storedEvent = new AtomicReference();
        c.addListener(ServerEvent.class, (ComponentEventListener & Serializable)e -> storedEvent.set(e));
        c.fireEvent(new ServerEvent(c, new BigDecimal(0)));
        ((ServerEvent)((Object)storedEvent.get())).unregisterListener();
    }

    @Test
    public void addListener_eventDataExpressionsPresent_constantPoolKeyNotCreatedAfterEachExpression() {
        TestButton button = new TestButton();
        try (MockedStatic util = Mockito.mockStatic(MessageDigestUtil.class);){
            util.when(() -> MessageDigestUtil.sha256((String)Mockito.anyString())).thenReturn((Object)new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
            button.addClickListener((ComponentEventListener & Serializable)event -> {});
            util.verifyNoInteractions();
        }
    }

    @Test
    public void addListener_nullListener_failFast() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("component event listener cannot be null");
        TestButton button = new TestButton();
        button.addListener(ServerEvent.class, null);
    }

    @Test
    public void eventWithBeanParameter_beanDeserialized() {
        ComponentTest.TestComponent c = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        c.addListener(EventWithBeanData.class, eventTracker);
        ObjectNode detailNode = JacksonUtils.createObjectNode();
        detailNode.put("clientX", 100);
        detailNode.put("clientY", 200);
        detailNode.put("button", 0);
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.set("event.detail", (JsonNode)detailNode);
        ((ElementListenerMap)c.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(c.getElement(), "bean-event", (JsonNode)eventData));
        Assert.assertEquals((String)"Event should have been fired", (long)1L, (long)eventTracker.getCalls());
        EventWithBeanData event = (EventWithBeanData)((Object)eventTracker.getEvent());
        Assert.assertNotNull((String)"Event should not be null", (Object)((Object)event));
        Assert.assertNotNull((String)"Details should not be null", (Object)event.getDetails());
        Assert.assertEquals((String)"ClientX should be 100", (long)100L, (long)event.getDetails().getClientX());
        Assert.assertEquals((String)"ClientY should be 200", (long)200L, (long)event.getDetails().getClientY());
        Assert.assertEquals((String)"Button should be 0", (long)0L, (long)event.getDetails().getButton());
    }

    @Test
    public void inertElement_domEventWithoutAllowInert_listenerNotCalled() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        InertData inertData = (InertData)component.getElement().getNode().getFeature(InertData.class);
        inertData.setInertSelf(true);
        inertData.generateChangesFromEmpty();
        EventTracker eventTracker = new EventTracker();
        component.addListener(MappedToDomNoDataEvent.class, eventTracker);
        this.fireDomEvent(component, "dom-event", (JsonNode)JacksonUtils.createObjectNode());
        eventTracker.assertEventNotCalled();
    }

    @Test
    public void inertElement_domEventWithAllowInert_listenerCalled() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        InertData inertData = (InertData)component.getElement().getNode().getFeature(InertData.class);
        inertData.setInertSelf(true);
        inertData.generateChangesFromEmpty();
        EventTracker eventTracker = new EventTracker();
        component.addListener(MappedToDomEventWithAllowInert.class, eventTracker);
        this.fireDomEvent(component, "dom-event", (JsonNode)JacksonUtils.createObjectNode());
        eventTracker.assertEventCalled(component, true);
    }

    @Test
    public void nonInertElement_domEventWithAllowInert_listenerCalled() {
        ComponentTest.TestComponent component = new ComponentTest.TestComponent();
        EventTracker eventTracker = new EventTracker();
        component.addListener(MappedToDomEventWithAllowInert.class, eventTracker);
        this.fireDomEvent(component, "dom-event", (JsonNode)JacksonUtils.createObjectNode());
        eventTracker.assertEventCalled(component, true);
    }

    private static class EventTracker<T extends ComponentEvent<?>>
    implements ComponentEventListener<T> {
        private AtomicInteger eventHandlerCalled = new AtomicInteger(0);
        private AtomicReference<T> eventObject = new AtomicReference<Object>(null);

        private EventTracker() {
        }

        public void onComponentEvent(T e) {
            this.eventHandlerCalled.incrementAndGet();
            Assert.assertNull((String)"Event object must be explicitly set to null before firing an event", this.eventObject.get());
            this.eventObject.set(e);
        }

        public int getCalls() {
            return this.eventHandlerCalled.get();
        }

        public T getEvent() {
            return (T)((ComponentEvent)this.eventObject.get());
        }

        public void reset() {
            this.eventObject.set(null);
            this.eventHandlerCalled.set(0);
        }

        public void assertEventCalled(ComponentTest.TestComponent source, boolean fromClient) {
            Assert.assertEquals((long)1L, (long)this.getCalls());
            Assert.assertEquals((Object)source, (Object)this.getEvent().getSource());
            Assert.assertEquals((Object)fromClient, (Object)this.getEvent().isFromClient());
        }

        public void assertEventNotCalled() {
            Assert.assertEquals((long)0L, (long)this.getCalls());
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            EventTracker o = (EventTracker)obj;
            return this.eventHandlerCalled.get() == o.eventHandlerCalled.get() && this.eventObject.equals(o.eventObject);
        }
    }

    @Tag(value="button")
    private class TestButton
    extends Component
    implements ClickNotifier {
        private TestButton() {
        }
    }
}

