/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.internal.ComponentTracker;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ComponentTrackerTest {
    private Object previousDisabled;
    private Field disabledField;

    ComponentTrackerTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.disabledField = ComponentTracker.class.getDeclaredField("disabled");
        this.disabledField.setAccessible(true);
        this.previousDisabled = this.disabledField.get(null);
        this.disabledField.set(null, false);
    }

    @AfterEach
    public void teardown() throws Exception {
        this.disabledField.set(null, this.previousDisabled);
    }

    @Test
    public void createLocationTracked() {
        Component1 c1 = new Component1();
        Component1 c2 = new Component1();
        int c1Line = 74;
        this.assertCreateLocation(c1, c1Line, this.getClass().getName());
        this.assertCreateLocation(c2, c1Line + 2, this.getClass().getName());
    }

    @Test
    public void attachLocationTracked() {
        Component1 c1 = new Component1();
        Component1 c2 = new Component1();
        Component1 c3 = new Component1();
        Layout layout = new Layout(c1);
        int c1Line = 85;
        this.assertCreateLocation(c1, c1Line, this.getClass().getName());
        layout.add(new Component[]{c2});
        this.assertAttachLocation(c2, c1Line + 10, this.getClass().getName());
        layout.add(new Component[]{c3});
        layout.remove(new Component[]{c3});
        layout.add(new Component[]{c3});
        this.assertAttachLocation(c3, c1Line + 17, this.getClass().getName());
    }

    @Test
    public void offsetApplied() {
        Component1 c1 = new Component1();
        Component1 c2 = new Component1();
        Component1 c3 = new Component1();
        int c1Line = 109;
        this.assertCreateLocation(c1, c1Line, this.getClass().getName());
        ComponentTracker.refreshLocation((ComponentTracker.Location)ComponentTracker.findCreate((Component)c1), (int)3);
        this.assertCreateLocation(c2, c1Line + 1 + 3, this.getClass().getName());
        ComponentTracker.refreshLocation((ComponentTracker.Location)ComponentTracker.findCreate((Component)c2), (int)1);
        this.assertCreateLocation(c3, c1Line + 2 + 3 + 1, this.getClass().getName());
    }

    @Test
    public void memoryIsReleased() throws Exception {
        Field createThrowableField = ComponentTracker.class.getDeclaredField("createThrowable");
        Field attachThrowableField = ComponentTracker.class.getDeclaredField("attachThrowable");
        createThrowableField.setAccessible(true);
        attachThrowableField.setAccessible(true);
        Map createMap = (Map)createThrowableField.get(null);
        Map attachMap = (Map)attachThrowableField.get(null);
        createMap.clear();
        attachMap.clear();
        new Layout(new Component1());
        Assertions.assertEquals((int)2, (int)createMap.size());
        Assertions.assertEquals((int)1, (int)attachMap.size());
        Assertions.assertTrue((boolean)this.isCleared(createMap));
        Assertions.assertTrue((boolean)this.isCleared(attachMap));
    }

    @Test
    public void ordinalValueSet() {
        Component1 c1 = new Component1();
        Component1 c2 = new Component1();
        Layout layout = new Layout(new Component[0]);
        layout.add(new Component[]{c1});
        layout.add(new Component[]{c2});
        this.assertCreateLocationOrdinalValueLower(c1, c2);
        this.assertAttachLocationOrdinalValueLower(c1, c2);
    }

    @Test
    public void attachOrderChangesOrdinal() {
        Component1 c1 = new Component1();
        Component1 c2 = new Component1();
        Layout layout = new Layout(new Component[0]);
        layout.add(new Component[]{c2});
        layout.add(new Component[]{c1});
        this.assertCreateLocationOrdinalValueLower(c1, c2);
        this.assertAttachLocationOrdinalValueLower(c2, c1);
    }

    @Test
    public void createOrderChangesOrdinal() {
        Component1 c2 = new Component1();
        Component1 c1 = new Component1();
        Layout layout = new Layout(new Component[0]);
        layout.add(new Component[]{c1});
        layout.add(new Component[]{c2});
        this.assertCreateLocationOrdinalValueLower(c2, c1);
        this.assertAttachLocationOrdinalValueLower(c1, c2);
    }

    @Test
    public void componentsHaveDifferentOrdinalWhenCreatedInSameLine() {
        Component[] components = new Component[]{new Component1(), new Component1()};
        new Layout(components);
        this.assertCreateLocation(components[0], 183, this.getClass().getName());
        this.assertCreateLocation(components[1], 183, this.getClass().getName());
        this.assertCreateLocationOrdinalValueLower(components[0], components[1]);
        this.assertAttachLocationOrdinalValueLower(components[0], components[1]);
    }

    private boolean isCleared(Map<?, ?> map) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            System.gc();
            if (map.isEmpty()) {
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    private void assertCreateLocation(Component c, int lineNumber, String name) {
        ComponentTracker.Location location = ComponentTracker.findCreate((Component)c);
        Assertions.assertEquals((int)lineNumber, (int)location.lineNumber());
        Assertions.assertEquals((Object)name, (Object)location.className());
        ComponentTracker.Location locationFromArray = this.getLocationFromArray(ComponentTracker.findCreateLocations((Component)c));
        Assertions.assertEquals((int)lineNumber, (int)locationFromArray.lineNumber());
        Assertions.assertEquals((Object)name, (Object)locationFromArray.className());
    }

    private void assertAttachLocation(Component c, int lineNumber, String name) {
        ComponentTracker.Location location = ComponentTracker.findAttach((Component)c);
        Assertions.assertEquals((int)lineNumber, (int)location.lineNumber());
        Assertions.assertEquals((Object)name, (Object)location.className());
        ComponentTracker.Location locationFromArray = this.getLocationFromArray(ComponentTracker.findAttachLocations((Component)c));
        Assertions.assertEquals((int)lineNumber, (int)locationFromArray.lineNumber());
        Assertions.assertEquals((Object)name, (Object)locationFromArray.className());
    }

    private ComponentTracker.Location getLocationFromArray(ComponentTracker.Location[] locations) {
        return Stream.of(locations).filter(l -> l.className().equals(ComponentTrackerTest.class.getName())).findFirst().orElseThrow();
    }

    private void assertLocationValueIsLower(Component componentWithLowerOrdinalVal, Component componentWithHigherOrdinalVal, Function<Component, ComponentTracker.Location> findLocationFn, Function<Component, ComponentTracker.Location[]> findLocationArrFn) {
        ComponentTracker.Location locationC1 = findLocationFn.apply(componentWithLowerOrdinalVal);
        ComponentTracker.Location locationC2 = findLocationFn.apply(componentWithHigherOrdinalVal);
        Assertions.assertTrue((locationC2.ordinal() > locationC1.ordinal() ? 1 : 0) != 0);
        ComponentTracker.Location locationFromArrayC1 = this.getLocationFromArray(findLocationArrFn.apply(componentWithLowerOrdinalVal));
        ComponentTracker.Location locationFromArrayC2 = this.getLocationFromArray(findLocationArrFn.apply(componentWithHigherOrdinalVal));
        Assertions.assertTrue((locationFromArrayC2.ordinal() > locationFromArrayC1.ordinal() ? 1 : 0) != 0);
    }

    private void assertCreateLocationOrdinalValueLower(Component c1, Component c2) {
        this.assertLocationValueIsLower(c1, c2, ComponentTracker::findCreate, ComponentTracker::findCreateLocations);
    }

    private void assertAttachLocationOrdinalValueLower(Component c1, Component c2) {
        this.assertLocationValueIsLower(c1, c2, ComponentTracker::findAttach, ComponentTracker::findAttachLocations);
    }

    @Tag(value="component1")
    public static class Component1
    extends Component {
    }

    @Tag(value="layout")
    public static class Layout
    extends Component
    implements HasComponents {
        public Layout(Component ... components) {
            this.add(components);
        }
    }
}

