/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateVite
implements FallibleCommand,
Serializable {
    private final Options options;
    private final Set<String> webComponentTags;
    private static final String[] reactPluginTemplatesUsedInStarters = new String[]{TaskUpdateVite.getSimplifiedTemplate("vite.config-react.ts"), TaskUpdateVite.getSimplifiedTemplate("vite.config-react-swc.ts")};
    static final String FILE_SYSTEM_ROUTER_DEPENDENCY = "@vaadin/hilla-file-router/vite-plugin.js";

    TaskUpdateVite(Options options, Set<String> webComponentTags) {
        this.options = options;
        this.webComponentTags = webComponentTags;
    }

    private static String getSimplifiedTemplate(String string) {
        return TaskUpdateVite.simplifyTemplate(TaskUpdateVite.getTemplate(string));
    }

    private static String getTemplate(String string) {
        try {
            return StringUtil.toUTF8String(TaskUpdateVite.class.getResourceAsStream(string));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String simplifyTemplate(String text) {
        return text.replace("\n", "").replace("\r", "").replace("\t", "").replace(" ", "");
    }

    @Override
    public void execute() {
        try {
            this.createConfig();
            this.createGeneratedConfig();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createConfig() throws IOException {
        File configFile = new File(this.options.getNpmFolder(), "vite.config.ts");
        if (configFile.exists()) {
            if (!this.replaceWithDefault(configFile)) {
                return;
            }
            this.log().info("Replacing vite.config.ts with the default version as the React plugin is now automatically included");
        }
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("vite.config.ts");
        Files.copy(resource, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.log().debug("Created vite configuration file: '{}'", (Object)configFile);
    }

    private boolean replaceWithDefault(File configFile) throws IOException {
        String text = TaskUpdateVite.simplifyTemplate(Files.readString(configFile.toPath(), StandardCharsets.UTF_8));
        for (String template : reactPluginTemplatesUsedInStarters) {
            if (!text.equals(template)) continue;
            return true;
        }
        return false;
    }

    private void createGeneratedConfig() throws IOException {
        File generatedConfigFile = new File(this.options.getNpmFolder(), "vite.generated.ts");
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("vite.generated.ts");
        String template = StringUtil.toUTF8String(resource);
        template = template.replace("#settingsImport#", "./" + this.options.getBuildDirectoryName() + "/vaadin-dev-server-settings.json").replace("#buildFolder#", "./" + this.options.getBuildDirectoryName()).replace("#webComponentTags#", this.webComponentTags == null || this.webComponentTags.isEmpty() ? "" : String.join((CharSequence)";", this.webComponentTags)).replace("#frontendExtraFileExtensions#", this.getFrontendExtraFileExtensions());
        template = this.updateFileSystemRouterVitePlugin(template);
        template = this.updateTailwindCssVitePlugin(template);
        FileIOUtils.writeIfChanged(generatedConfigFile, template);
        this.log().debug("Created vite generated configuration file: '{}'", (Object)generatedConfigFile);
    }

    private String getFrontendExtraFileExtensions() {
        Optional<List<String>> frontendExtraFileExtensions = Optional.ofNullable(this.options.getFrontendExtraFileExtensions());
        if (frontendExtraFileExtensions.isPresent() && frontendExtraFileExtensions.get().size() > 0) {
            return frontendExtraFileExtensions.get().stream().map(ext -> ext.replace("'", "\\'")).map(ext -> ext.trim()).map(ext -> ext.startsWith(".") ? ext : "." + ext).collect(Collectors.joining("', '", ", '", "'"));
        }
        return "";
    }

    private String updateFileSystemRouterVitePlugin(String template) {
        if (this.options.isReactEnabled() && FrontendBuildUtils.isHillaUsed(this.options.getFrontendDirectory(), this.options.getClassFinder())) {
            return template.replace("//#vitePluginFileSystemRouterImport#", "import vitePluginFileSystemRouter from '@vaadin/hilla-file-router/vite-plugin.js';").replace("//#vitePluginFileSystemRouter#", "vitePluginFileSystemRouter({isDevMode: devMode}),");
        }
        return template.replace("//#vitePluginFileSystemRouterImport#", "").replace("//#vitePluginFileSystemRouter#", "");
    }

    private String updateTailwindCssVitePlugin(String template) {
        if (FrontendBuildUtils.isTailwindCssEnabled(this.options)) {
            return template.replace("//#tailwindcssVitePluginImport#", "import tailwindcss from '@tailwindcss/vite';").replace("//#tailwindcssVitePlugin#", "tailwindcss(),");
        }
        return template.replace("//#tailwindcssVitePluginImport#", "").replace("//#tailwindcssVitePlugin#", "");
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

