/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TaskGenerateWebComponentBootstrap
extends AbstractTaskClientGenerator {
    private final File frontendGeneratedDirectory;
    private Options options;

    TaskGenerateWebComponentBootstrap(Options options) {
        this.frontendGeneratedDirectory = new File(options.getFrontendDirectory(), "generated/");
        this.options = options;
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("import './%s';%n", "vaadin-featureflags.js"));
        lines.add("import 'Frontend/generated/flow/generated-flow-webcomponent-imports.js';");
        lines.add("import { init } from 'Frontend/generated/jar-resources/FlowClient.js';");
        lines.add("init();");
        this.applyCssImportWhenNoTheme(lines);
        return String.join((CharSequence)"\n", lines);
    }

    private void applyCssImportWhenNoTheme(List<String> lines) {
        ThemeDefinition themeDefinition = this.options.getFrontendDependenciesScanner().getThemeDefinition();
        if (themeDefinition == null || "".equals(themeDefinition.getName())) {
            lines.add("import './css.generated.js';");
            lines.add("import { applyCss } from './css.generated.js';");
            lines.add("applyCss(document);");
            lines.add("");
        }
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.frontendGeneratedDirectory, "vaadin-web-component.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }
}

