/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.frontend.AbstractFileGeneratorFallibleCommand;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class TaskGenerateReactFiles
extends AbstractFileGeneratorFallibleCommand {
    public static final String CLASS_PACKAGE = "com/vaadin/flow/server/frontend/%s";
    private Options options;
    protected static String NO_IMPORT = "Faulty configuration of server-side routes.\nThe server route definition is missing from the '%1$s' file\n\nTo have working Flow routes add the following to the '%1$s' file:\n    import Flow from 'Frontend/generated/flow/Flow';\n    import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n    export const { router, routes } = new RouterConfigurationBuilder()\n        .withFallback(Flow)\n        // .withFileRoutes() or .withReactRoutes()\n        // ...\n        .build();\n\n    OR\n\n    import { createBrowserRouter, RouteObject } from 'react-router';\n    import { serverSideRoutes } from 'Frontend/generated/flow/Flow';\n\n    function build() {\n        const routes = [...serverSideRoutes] as RouteObject[];\n        return {\n            router: createBrowserRouter(routes),\n            routes\n        };\n    }\n    export const { router, routes } = build();\n\n";
    protected static String MISSING_ROUTES_EXPORT = "Routes need to be exported as 'routes' for server navigation handling.\nroutes.tsx should contain\n'export const { router, routes } = new RouterConfigurationBuilder()\n   // routes building\n   .build();'\nOR\n'export { router } = ...\n// Some other code here\nexport { routes } = ...'\nOR\n'export const routes = [...serverSideRoutes] as RouteObject[];'\n";
    private static final String FLOW_TSX = "Flow.tsx";
    private static final String VAADIN_REACT_TSX = "vaadin-react.tsx";
    private static final String REACT_ADAPTER_TEMPLATE = "ReactAdapter.template";
    private static final String REACT_ADAPTER_TSX = "ReactAdapter.tsx";
    private static final String LAYOUTS_JSON = "layouts.json";
    static final String FLOW_FLOW_TSX = "flow/Flow.tsx";
    static final String FLOW_REACT_ADAPTER_TSX = "flow/ReactAdapter.tsx";
    static final String JSX_TRANSFORM_INDEX = "jsx-dev-transform/index.ts";
    static final String JSX_TRANSFORM_RUNTIME = "jsx-dev-transform/jsx-runtime.ts";
    static final String JSX_TRANSFORM_DEV_RUNTIME = "jsx-dev-transform/jsx-dev-runtime.ts";
    private static final String ROUTES_JS_IMPORT_PATH_TOKEN = "%routesJsImportPath%";
    private static final Pattern SERVER_ROUTE_PATTERN = Pattern.compile("import\\s+\\{[\\s\\S]*(?:serverSideRoutes)+[\\s\\S]*\\}\\s+from\\s+(\"|'|`)Frontend\\/generated\\/flow\\/Flow(\\.js)?\\1;[\\s\\S]+\\.{3}serverSideRoutes");
    private static final Pattern FALLBACK_COMPONENT_PATTERN = Pattern.compile("import\\s+(\\w+)\\s+from\\s+(\"|'|`)Frontend\\/generated\\/flow\\/Flow(\\.js)?\\2;[\\s\\S]+withFallback\\(\\s*\\1\\s*\\)");
    private static final Pattern ROUTES_EXPORT_PATTERN = Pattern.compile("export\\s+(const\\s+)?(\\{[\\s\\S]*(router[\\s\\S]*routes|routes[\\s\\S]*router)[\\s\\S]*}|routes)");

    TaskGenerateReactFiles(Options options) {
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.options.isReactEnabled()) {
            this.doExecute();
        } else {
            this.cleanup();
        }
    }

    private void doExecute() throws ExecutionFailedException {
        File frontendDirectory = this.options.getFrontendDirectory();
        File frontendGeneratedFolder = this.options.getFrontendGeneratedFolder();
        File flowTsx = new File(frontendGeneratedFolder, FLOW_FLOW_TSX);
        File vaadinReactTsx = new File(frontendGeneratedFolder, VAADIN_REACT_TSX);
        File reactAdapterTsx = new File(frontendGeneratedFolder, FLOW_REACT_ADAPTER_TSX);
        File routesTsx = new File(frontendDirectory, "routes.tsx");
        File frontendGeneratedFolderRoutesTsx = new File(frontendGeneratedFolder, "routes.tsx");
        try {
            boolean isHillaUsed;
            this.writeFile(flowTsx, this.getFileContent(FLOW_TSX));
            this.writeFile(new File(frontendGeneratedFolder, JSX_TRANSFORM_INDEX), this.getFileContent(JSX_TRANSFORM_INDEX));
            this.writeFile(new File(frontendGeneratedFolder, JSX_TRANSFORM_DEV_RUNTIME), this.getFileContent(JSX_TRANSFORM_DEV_RUNTIME));
            this.writeFile(new File(frontendGeneratedFolder, JSX_TRANSFORM_RUNTIME), this.getFileContent(JSX_TRANSFORM_RUNTIME));
            this.writeFile(vaadinReactTsx, this.getVaadinReactTsContent(routesTsx.exists()));
            this.writeLayoutsJson(this.options.getClassFinder().getAnnotatedClasses(Layout.class));
            if (this.fileAvailable(REACT_ADAPTER_TEMPLATE)) {
                String reactAdapterContent = this.getFileContent(REACT_ADAPTER_TEMPLATE);
                reactAdapterContent = reactAdapterContent.replace("{{VAADIN_VERSION}}", Version.getFullVersion());
                this.writeFile(reactAdapterTsx, reactAdapterContent);
            }
            this.writeFile(frontendGeneratedFolderRoutesTsx, this.getFileContent((isHillaUsed = FrontendBuildUtils.isHillaUsed(frontendDirectory, this.options.getClassFinder())) ? "routes.tsx" : "routes-flow.tsx"));
            if (routesTsx.exists()) {
                this.track(routesTsx);
                String routesContent = Files.readString(routesTsx.toPath(), StandardCharsets.UTF_8);
                routesContent = StringUtil.removeComments(routesContent);
                if (this.missingServerRouteImport(routesContent) && this.serverRoutesAvailable()) {
                    throw new ExecutionFailedException(String.format(NO_IMPORT, routesTsx.getPath()));
                }
                if (TaskGenerateReactFiles.missingRoutesExport(routesContent)) {
                    throw new ExecutionFailedException(MISSING_ROUTES_EXPORT);
                }
            }
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Failed to read file content", e);
        }
    }

    public static void writeLayouts(Options options, Collection<Class<?>> layoutsClasses) {
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(options);
        try {
            task.writeLayoutsJson(layoutsClasses);
        }
        catch (ExecutionFailedException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioEx = (IOException)throwable;
                throw new UncheckedIOException(ioEx);
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private void writeLayoutsJson(Collection<Class<?>> layoutClasses) throws ExecutionFailedException {
        this.writeFile(new File(this.options.getFrontendGeneratedFolder(), LAYOUTS_JSON), this.layoutsContent(layoutClasses));
    }

    private String layoutsContent(Collection<Class<?>> layoutClasses) {
        ArrayNode availableLayouts = JacksonUtils.createArrayNode();
        for (Class<?> layout : layoutClasses) {
            if (!layout.isAnnotationPresent(Layout.class)) continue;
            ObjectNode layoutObject = JacksonUtils.createObjectNode();
            layoutObject.put("path", layout.getAnnotation(Layout.class).value());
            availableLayouts.add((JsonNode)layoutObject);
        }
        return availableLayouts.toString();
    }

    private void cleanup() throws ExecutionFailedException {
        try {
            File frontendDirectory = this.options.getFrontendDirectory();
            File frontendGeneratedFolder = this.options.getFrontendGeneratedFolder();
            File flowTsx = new File(frontendGeneratedFolder, FLOW_FLOW_TSX);
            File vaadinReactTsx = new File(frontendGeneratedFolder, VAADIN_REACT_TSX);
            File reactAdapterTsx = new File(frontendGeneratedFolder, FLOW_REACT_ADAPTER_TSX);
            File frontendGeneratedFolderRoutesTsx = new File(frontendGeneratedFolder, "routes.tsx");
            File layoutsJson = new File(frontendGeneratedFolder, LAYOUTS_JSON);
            FileIOUtils.deleteFileQuietly(flowTsx);
            FileIOUtils.deleteFileQuietly(new File(frontendGeneratedFolder, JSX_TRANSFORM_INDEX));
            FileIOUtils.deleteFileQuietly(new File(frontendGeneratedFolder, JSX_TRANSFORM_DEV_RUNTIME));
            FileIOUtils.deleteFileQuietly(new File(frontendGeneratedFolder, JSX_TRANSFORM_RUNTIME));
            FileIOUtils.deleteFileQuietly(layoutsJson);
            FileIOUtils.deleteFileQuietly(vaadinReactTsx);
            FileIOUtils.deleteFileQuietly(reactAdapterTsx);
            FileIOUtils.deleteFileQuietly(frontendGeneratedFolderRoutesTsx);
            File routesTsx = new File(frontendDirectory, "routes.tsx");
            if (routesTsx.exists()) {
                String defaultRoutesContent = Files.readString(routesTsx.toPath(), StandardCharsets.UTF_8);
                if (FileIOUtils.compareIgnoringIndentationEOLAndWhiteSpace(defaultRoutesContent, this.getFileContent("routes.tsx"), String::equals)) {
                    routesTsx.delete();
                    this.log().debug("Default {} file has been removed.", (Object)"routes.tsx");
                } else {
                    Files.copy(routesTsx.toPath(), new File(frontendDirectory, "routes.tsx.flowBackup").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    routesTsx.delete();
                    this.log().warn("Custom {} file has been removed. Backup is created in {}.flowBackup file.", (Object)"routes.tsx", (Object)"routes.tsx");
                }
            }
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Failed to clean up .tsx files", e);
        }
    }

    private String getVaadinReactTsContent(boolean frontendRoutesTsExists) throws IOException {
        return this.getFileContent(VAADIN_REACT_TSX).replace(ROUTES_JS_IMPORT_PATH_TOKEN, frontendRoutesTsExists ? "Frontend/routes.js" : "Frontend/generated/routes.js");
    }

    private boolean fileAvailable(String fileName) {
        return this.options.getClassFinder().getClassLoader().getResource(CLASS_PACKAGE.formatted(fileName)) != null;
    }

    private boolean missingServerRouteImport(String routesContent) {
        return !FALLBACK_COMPONENT_PATTERN.matcher(routesContent).find() && !SERVER_ROUTE_PATTERN.matcher(routesContent).find();
    }

    private boolean serverRoutesAvailable() {
        return !this.options.getClassFinder().getAnnotatedClasses(Route.class).isEmpty();
    }

    private static boolean missingRoutesExport(String routesContent) {
        return !ROUTES_EXPORT_PATTERN.matcher(routesContent).find();
    }

    private void writeFile(File target, String content) throws ExecutionFailedException {
        try {
            this.writeIfChanged(target, content);
        }
        catch (IOException exception) {
            String errorMessage = String.format("Error writing '%s'", target);
            throw new ExecutionFailedException(errorMessage, exception);
        }
    }

    protected String getFileContent(String fileName) throws IOException {
        String indexTemplate;
        try (InputStream indexTsStream = this.options.getClassFinder().getClassLoader().getResourceAsStream(CLASS_PACKAGE.formatted(fileName));){
            indexTemplate = StringUtil.toUTF8String(indexTsStream);
        }
        return indexTemplate;
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

