/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.DevBundleUtils;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.frontend.AbstractFileGeneratorFallibleCommand;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyNpmAssetsFiles
extends AbstractFileGeneratorFallibleCommand {
    private final Options options;
    private final File staticOutput;

    TaskCopyNpmAssetsFiles(Options options) {
        this.options = options;
        if (options.isDevBundleBuild()) {
            this.staticOutput = new File(DevBundleUtils.getDevBundleFolder(options.getNpmFolder(), options.getBuildDirectoryName()), "webapp/VAADIN/static/assets/");
        } else {
            String webappResources = options.getWebappResourcesDirectory() == null ? FrontendUtils.getUnixPath(options.getNpmFolder().toPath().resolve(Paths.get(options.getBuildDirectoryName(), "classes", "META-INF/VAADIN/webapp/").normalize())) : options.getWebappResourcesDirectory().getPath();
            this.staticOutput = new File(webappResources, "VAADIN/static/assets/");
        }
    }

    @Override
    public void execute() {
        if (!this.options.copyAssets()) {
            return;
        }
        if (this.hasAssets()) {
            long start = System.nanoTime();
            this.log().info("Copying npm assets from node_modules ...");
            Map<String, List<String>> assets = this.options.getFrontendDependenciesScanner().getAssets();
            this.copyNpmAssets(assets);
            if (!this.options.isProductionMode()) {
                assets = this.options.getFrontendDependenciesScanner().getDevAssets();
                this.copyNpmAssets(assets);
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            this.log().info("Copying npm assets done. Took {} ms.", (Object)ms);
        }
    }

    private boolean hasAssets() {
        return !this.options.getFrontendDependenciesScanner().getAssets().isEmpty() || !this.options.getFrontendDependenciesScanner().getDevAssets().isEmpty();
    }

    private void copyNpmAssets(Map<String, List<String>> npmAssets) {
        npmAssets.forEach((npmModule, npmAssetList) -> npmAssetList.stream().filter(Predicate.not(String::isBlank)).forEach(npmAsset -> this.handleAsset((String)npmModule, (String)npmAsset)));
    }

    private void handleAsset(String npmModule, String npmAsset) {
        Rule rule = this.getRule(npmAsset, npmModule);
        File npmModuleDir = new File(this.options.getNodeModulesFolder(), npmModule);
        List<Path> paths = this.collectFiles(npmModuleDir.toPath(), rule.copyRule);
        Path basePath = this.getBasePath(npmModuleDir.toPath(), rule.copyRule);
        paths.stream().map(Path::toFile).forEach(file -> this.copyFileToTarget((File)file, rule, basePath));
    }

    private Rule getRule(String npmAsset, String npmModule) {
        String[] split = npmAsset.split(":");
        if (split.length != 2) {
            throw new InvalidParameterException("Invalid npm asset: " + npmAsset + " for npm module: " + npmModule);
        }
        Rule rule = new Rule(split[0].strip(), split[1].strip());
        this.log().debug("Rule {} to {}", (Object)rule.copyRule, (Object)rule.targetFolder);
        return rule;
    }

    private void copyFileToTarget(File file, Rule copyRule, Path basePath) {
        File baseDestinationFolder = new File(this.staticOutput, copyRule.targetFolder);
        Path relativePath = basePath.relativize(file.toPath());
        File destFile = new File(baseDestinationFolder, relativePath.toString());
        if (!destFile.exists() || destFile.lastModified() < file.lastModified()) {
            this.log().debug("Copying npm file {} to {}", (Object)file.getAbsolutePath(), (Object)destFile.getAbsolutePath());
            try {
                Files.createDirectories(destFile.toPath().getParent(), new FileAttribute[0]);
                Files.copy(file.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to copy project frontend resources from '%s' to '%s'", file, destFile), e);
            }
        }
    }

    private Path getBasePath(Path npmModuleDir, String copyRule) {
        int lastSlash;
        String basePathStr = copyRule;
        if (basePathStr.startsWith("/")) {
            basePathStr = basePathStr.substring(1);
        }
        int wildcardIndex = -1;
        if (basePathStr.contains("*")) {
            wildcardIndex = basePathStr.indexOf(42);
        } else if (basePathStr.contains("?")) {
            wildcardIndex = basePathStr.indexOf(63);
        }
        if (wildcardIndex != -1 && (lastSlash = (basePathStr = basePathStr.substring(0, wildcardIndex)).lastIndexOf(47)) != -1) {
            return npmModuleDir.resolve(basePathStr.substring(0, lastSlash));
        }
        return npmModuleDir;
    }

    private List<Path> collectFiles(Path basePath, String matcherPattern) {
        ArrayList<Path> filePaths = new ArrayList<Path>();
        if (!basePath.toFile().exists()) {
            return filePaths;
        }
        Object pattern = matcherPattern.startsWith("**") ? matcherPattern : (matcherPattern.startsWith("/") ? "**" + matcherPattern : "**/" + matcherPattern);
        this.log().debug("getting files using pattern {}", pattern);
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + (String)pattern);
        filePaths.addAll(this.getFileNames(basePath, matcher));
        this.log().debug("Paths amount {}", (Object)filePaths.size());
        return filePaths;
    }

    private List<Path> getFileNames(Path dir, PathMatcher matcher) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    fileNames.addAll(this.getFileNames(path, matcher));
                    continue;
                }
                if (!matcher.matches(path)) continue;
                fileNames.add(path);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to walk through directory", e);
        }
        return fileNames;
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private record Rule(String copyRule, String targetFolder) {
    }
}

