/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.CoreFeatureFlagProvider;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class FrontendBuildUtils {
    public static boolean isReactModuleAvailable(Options options) {
        try {
            options.getClassFinder().loadClass("com.vaadin.flow.component.react.ReactAdapterComponent");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isTailwindCssEnabled(Options options) {
        return options.getFeatureFlags().isEnabled(CoreFeatureFlagProvider.TAILWIND_CSS);
    }

    protected static boolean isPlatformMajorVersionUpdated(ClassFinder finder, File npmFolder, File nodeModules, File buildDirectory) throws IOException {
        Optional<String> platformVersion = FrontendBuildUtils.getVaadinVersion(finder);
        if (platformVersion.isPresent()) {
            JsonNode vaadinJsonContents = FrontendBuildUtils.getBundleVaadinContent(buildDirectory);
            if (!vaadinJsonContents.has("vaadinVersion") && nodeModules.exists()) {
                vaadinJsonContents = FrontendBuildUtils.getVaadinJsonContents(npmFolder);
            }
            if (!vaadinJsonContents.has("vaadinVersion")) {
                return false;
            }
            FrontendVersion jsonVersion = new FrontendVersion(vaadinJsonContents.get("vaadinVersion").asString());
            FrontendVersion platformsVersion = new FrontendVersion(platformVersion.get());
            return jsonVersion.getMajorVersion() != platformsVersion.getMajorVersion();
        }
        return false;
    }

    private static JsonNode getBundleVaadinContent(File buildDirectory) throws IOException {
        File vaadinJsonFile = new File(new File(buildDirectory, "dev-bundle"), "vaadin.json");
        if (!vaadinJsonFile.exists()) {
            return JacksonUtils.createObjectNode();
        }
        String fileContent = Files.readString(vaadinJsonFile.toPath(), StandardCharsets.UTF_8);
        ObjectNode vaadinJsonContents = JacksonUtils.readTree(fileContent);
        return vaadinJsonContents;
    }

    protected static boolean isPlatformVersionUpdated(ClassFinder finder, File npmFolder, File nodeModules) throws IOException {
        Optional<String> platformVersion = FrontendBuildUtils.getVaadinVersion(finder);
        if (platformVersion.isPresent() && nodeModules.exists()) {
            ObjectNode vaadinJsonContents = FrontendBuildUtils.getVaadinJsonContents(npmFolder);
            if (!vaadinJsonContents.has("vaadinVersion")) {
                return true;
            }
            return !Objects.equals(vaadinJsonContents.get("vaadinVersion").asString(), platformVersion.get());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Optional<String> getVaadinVersion(ClassFinder finder) {
        URL coreVersionsResource = finder.getResource("vaadin-core-versions.json");
        if (coreVersionsResource == null) {
            return Optional.empty();
        }
        try (InputStream vaadinVersionsStream = coreVersionsResource.openStream();){
            ObjectNode versionsJson = JacksonUtils.readTree(StringUtil.toUTF8String(vaadinVersionsStream));
            if (!versionsJson.has("platform")) return Optional.empty();
            Optional<String> optional = Optional.of(versionsJson.get("platform").asString());
            return optional;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Platform.class).error("Unable to determine version information", (Throwable)e);
        }
        return Optional.empty();
    }

    static File getVaadinJsonFile(File npmFolder) {
        return new File(new File(npmFolder, "node_modules/"), ".vaadin/vaadin.json");
    }

    static ObjectNode getVaadinJsonContents(File npmFolder) throws IOException {
        File vaadinJsonFile = FrontendBuildUtils.getVaadinJsonFile(npmFolder);
        if (vaadinJsonFile.exists()) {
            String fileContent = Files.readString(vaadinJsonFile.toPath(), StandardCharsets.UTF_8);
            return JacksonUtils.readTree(fileContent);
        }
        return JacksonUtils.createObjectNode();
    }

    public static String getJarResourceString(String jarImport, ClassFinder finder) {
        String string;
        block10: {
            URL resource = finder.getResource("META-INF/frontend/" + jarImport);
            if (resource == null) {
                resource = finder.getResource("META-INF/resources/frontend/" + jarImport);
            }
            if (resource == null) {
                return null;
            }
            InputStream frontendContent = resource.openStream();
            try {
                string = FrontendUtils.streamToString(frontendContent);
                if (frontendContent == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (frontendContent != null) {
                        try {
                            frontendContent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            frontendContent.close();
        }
        return string;
    }

    public static boolean isHillaUsed(File frontendDirectory, ClassFinder classFinder) {
        return FrontendBuildUtils.isHillaAvailable(classFinder) && FrontendUtils.isHillaViewsUsed(frontendDirectory);
    }

    static boolean isHillaAvailable(ClassFinder classFinder) {
        try {
            classFinder.loadClass("com.vaadin.hilla.EndpointController");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

