/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBuildUtils {
    private static Logger getLogger() {
        return LoggerFactory.getLogger(BundleBuildUtils.class);
    }

    public static void copyPackageLockFromBundle(Options options) {
        try {
            if (FrontendBuildUtils.isPlatformMajorVersionUpdated(options.getClassFinder(), options.getNodeModulesFolder(), options.getNpmFolder(), options.getBuildDirectory())) {
                BundleBuildUtils.getLogger().info("Platform version updated. Skipping bundle lock file copy.");
                return;
            }
        }
        catch (IOException ioe) {
            BundleBuildUtils.getLogger().debug("Failed to validate platform version change.", (Throwable)ioe);
        }
        String lockFile = options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        File packageLock = new File(options.getNpmFolder(), lockFile);
        if (packageLock.exists()) {
            return;
        }
        try {
            BundleBuildUtils.copyAppropriatePackageLock(options, packageLock);
        }
        catch (IOException ioe) {
            BundleBuildUtils.getLogger().error("Failed to copy existing `" + lockFile + "` to use", (Throwable)ioe);
        }
    }

    private static void copyAppropriatePackageLock(Options options, File packageLock) throws IOException {
        File devPackageLock;
        String packageLockFile;
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        String string = packageLockFile = options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        if (devBundleFolder.exists() && (devPackageLock = new File(devBundleFolder, packageLockFile)).exists()) {
            Files.copy(devPackageLock.toPath(), packageLock.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        boolean hillaUsed = FrontendBuildUtils.isHillaUsed(options.getFrontendDirectory(), options.getClassFinder());
        URL resource = null;
        if (hillaUsed) {
            resource = options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-" + packageLockFile);
        }
        if (resource == null) {
            if (hillaUsed) {
                BundleBuildUtils.getLogger().debug("The '{}' template for hybrid application could not be found in dev-bundle JAR. Fallback to standard template.", (Object)packageLockFile);
            }
            resource = options.getClassFinder().getResource("vaadin-dev-bundle/" + packageLockFile);
        }
        if (resource != null) {
            String filecontents = FileIOUtils.urlToString(resource);
            Files.writeString(packageLock.toPath(), (CharSequence)filecontents, new OpenOption[0]);
        } else {
            BundleBuildUtils.getLogger().debug("The '{}' file cannot be created because the dev-bundle JAR does not contain a suitable template.", (Object)packageLockFile);
        }
    }
}

