/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;

public class ScannerTestComponents {

    public static class UserRouteService {
        public static void registerUserRoute(RouteConfiguration config, String userId) {
            config.setRoute(userId, DynamicComponentClass.class, new Class[]{DynamicLayoutClass.class});
        }
    }

    @Route
    public static class RouteWithService {
        public RouteWithService() {
            UserRouteService.registerUserRoute(RouteConfiguration.forSessionScope(), "donald");
        }
    }

    public static class BeanFactory {
        public static <T> T getBean(Class<T> type) {
            return null;
        }
    }

    @Route
    public static class RouteWithViewBean {
        public RouteWithViewBean() {
            UI.getCurrent().add(new Component[]{BeanFactory.getBean(DynamicComponentClass.class)});
        }
    }

    @Route(value="dynamic-route")
    @JsModule(value="dynamic-route.js")
    public static class RouteWithNestedDynamicRouteClass {
        public RouteWithNestedDynamicRouteClass() {
            this.registerRoute();
        }

        private void registerRoute() {
            RouteConfiguration.forSessionScope().setRoute("foo", DynamicComponentClass.class, new Class[]{DynamicLayoutClass.class});
        }
    }

    @JsModule(value="dynamic-layout.js")
    public static class DynamicLayoutClass
    implements RouterLayout {
        public Element getElement() {
            return null;
        }
    }

    @Route(value="route-3")
    @JsModule.Container(value={@JsModule(value="dynamic-component.js"), @JsModule(value="another-dynamic-component.js")})
    public static class DynamicComponentClassWithTwoImports
    extends Component {
    }

    @JsModule(value="dynamic-component.js")
    public static class DynamicComponentClass
    extends Component {
    }

    @Route(value="css-route-2")
    @CssImport.Container(value={@CssImport(value="./foo.css"), @CssImport(value="./foo.css", include="bar"), @CssImport(value="./foo.css", id="bar"), @CssImport(value="./foo.css", themeFor="bar")})
    public static class CssClass2
    extends CssClass1 {
    }

    @Route(value="css-route-1")
    @CssImport.Container(value={@CssImport(value="./foo.css"), @CssImport(value="./foo.css", include="bar"), @CssImport(value="./foo.css", id="bar"), @CssImport(value="./foo.css", themeFor="bar")})
    public static class CssClass1 {
    }

    @Route(value="route-2")
    public static class RoutedClass
    extends BridgeClass {
    }

    public static class BridgeClass
    extends RoutedClassWithAnnotations {
    }

    @Route(value="route-1")
    @NoTheme
    @JsModule(value="./foo")
    public static class RoutedClassWithAnnotations
    extends RoutedClassWithoutAnnotations {
    }

    @Route
    public static class RoutedClassWithoutAnnotations {
    }

    public static class UnAnnotatedClass {
    }

    @Theme(themeClass=Theme2.class)
    public static class ThemeExporter
    extends WebComponentExporter<RootViewWithoutThemeAnnotation> {
        public ThemeExporter() {
            super("root-view");
        }

        public void configureInstance(WebComponent<RootViewWithoutThemeAnnotation> webComponent, RootViewWithoutThemeAnnotation component) {
        }
    }

    public static class NoThemeExporter
    extends WebComponentExporter<RootViewWithTheme> {
        public NoThemeExporter() {
            super("root-view");
        }

        public void configureInstance(WebComponent<RootViewWithTheme> webComponent, RootViewWithTheme component) {
        }
    }

    @JsModule(value="./my-another-component.js")
    public static class AnotherComponent {
        public static AnotherComponent createMyComponent(String label) {
            return new AnotherComponent();
        }
    }

    @JsModule(value="./my-static-factory.js")
    public static class StaticComponentsFactory {
        public static AnotherComponent createAnotherComponent(String label) {
            return AnotherComponent.createMyComponent(label);
        }
    }

    @JsModule(value="./my-component.js")
    public static class ComponentFactory {
        public MyComponent createMyComponent() {
            return new MyComponent();
        }
    }

    @Route
    public static class ThirdView {
        public void foo() {
            new ComponentFactory().createMyComponent();
            this.add(StaticComponentsFactory.createAnotherComponent(null));
        }

        private void add(Object o) {
        }
    }

    @Route(value="second", layout=RouterLayout2.class)
    @JsModule(value="./view-2.js")
    public static class SecondView
    extends Component {
        public SecondView() {
            new Component3();
        }
    }

    public static class MyComponent
    extends Component {
    }

    @Route(value="", layout=RouterLayout1.class)
    @JsModule(value="./view-1.js")
    @NpmPackage(value="@foo/first-view", version="0.0.1", assets={"first:assets"})
    public static class FirstView
    extends View0 {
        Component1 component1;

        public FirstView() {
            this.createView();
        }

        private void createView() {
            new Component2();
        }
    }

    @Route(value="", layout=RouterLayout2.class)
    @Theme(themeClass=Theme2.class, variant="foo")
    @JsModule(value="./view-2.js")
    public static class RootViewWithMultipleTheme
    extends Component {
        public RootViewWithMultipleTheme() {
            this.createView();
        }

        private void createView() {
            new Component3();
        }
    }

    @Route(value="2", layout=RouterLayout1.class)
    public static class RootView2WithLayoutTheme {
    }

    @Route(value="", layout=RouterLayout1.class)
    public static class RootViewWithLayoutTheme
    extends FirstView {
    }

    @Route(value="", layout=RouterLayout1.class)
    @JsModule(value="./view-3.js")
    @NoTheme
    public static class RootViewWithoutTheme
    extends View0 {
    }

    @Route(value="")
    public static class RootViewWithoutThemeAnnotation
    extends Component {
    }

    @Route(value="")
    @Theme(themeClass=Theme4.class)
    public static class RootViewWithTheme
    extends Component {
    }

    @JavaScript(value="frontend://view-0.js")
    public static abstract class View0
    extends Component {
    }

    @Theme(themeClass=Theme1.class, variant="dark")
    @JsModule(value="./router-layout-2.js")
    public class RouterLayout2
    extends RouterLayout1 {
    }

    @Theme(themeClass=Theme1.class, variant="dark")
    @JsModule(value="./router-layout-1.js")
    public class RouterLayout1
    implements RouterLayout {
        public Element getElement() {
            return null;
        }
    }

    @Tag(value="component-extends")
    @NpmPackage(value="@vaadin/component-extended", version="2.1.0")
    static abstract class GeneratedComponent
    extends Component {
        GeneratedComponent() {
        }
    }

    static class ComponentExtending
    extends GeneratedComponent {
        ComponentExtending() {
        }
    }

    @JsModule(value="./component-3.js")
    @JavaScript(value="frontend://component-3.js")
    @Tag(value="component-3")
    @NpmPackage(value="@vaadin/component-3", version="~2.1.0")
    static class Component3
    extends Component {
        Component3() {
        }
    }

    @JsModule(value="./component-2.js")
    @JavaScript(value="frontend://component-2.js")
    @Tag(value="component-2")
    @NpmPackage(value="@vaadin/component-2", version="222.222.222")
    static class Component2
    extends Component {
        Component2() {
        }
    }

    @JsModule(value="./component-1.js")
    @JavaScript(value="frontend://component-1.js")
    @Tag(value="component-1")
    @NpmPackage(value="@vaadin/component-1", version="1.1.1")
    static class Component1
    extends Component0 {
        Component1() {
        }
    }

    @NpmPackage.Container(value={@NpmPackage(value="@vaadin/component-0", version="=2.1.0"), @NpmPackage(value="@vaadin/component-0", version="^1.1.0"), @NpmPackage(value="@vaadin/vaadin-foo", version="1.23.114-alpha1")})
    @JsModule(value="./component-0.js")
    @JavaScript(value="frontend://component-0.js")
    @Tag(value="component-0")
    static class Component0
    extends Component {
        Component0() {
        }
    }

    @JsModule(value="./theme-default.js")
    static class ThemeDefault
    extends Theme0 {
        ThemeDefault() {
        }
    }

    @JsModule(value="./theme-4.js")
    static class Theme4
    extends Theme0 {
        Theme4() {
        }
    }

    static class Theme2
    extends Theme0 {
        Theme2() {
        }
    }

    static class Theme1
    extends Theme0 {
        Theme1() {
        }
    }

    @NpmPackage(value="@vaadin/theme-0", version="1.1.1")
    @JavaScript(value="frontend://theme-0.js")
    static class Theme0
    implements AbstractTheme {
        public static final String DARK = "dark";
        public static final String FOO = "foo";

        Theme0() {
        }

        public String getBaseUrl() {
            return null;
        }

        public String getThemeUrl() {
            return null;
        }
    }
}

