/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.DepsTests;
import com.vaadin.flow.server.frontend.scanner.EntryPointData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.ScannerDependenciesTest;
import com.vaadin.flow.server.frontend.scanner.ScannerTestComponents;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Test;

public class ScannerCssTest {
    @Test
    public void should_visitCssImports() throws Exception {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.CssClass1.class, ScannerTestComponents.CssClass2.class);
        Assert.assertEquals((long)3L, (long)deps.getEntryPoints().size());
        for (EntryPointData entryPoint : deps.getEntryPoints()) {
            if (entryPoint.getName().equals(UI.class.getName())) continue;
            Assert.assertEquals((String)("Wrong amount of css in " + entryPoint.getName()), (long)4L, (long)entryPoint.getCss().size());
            MatcherAssert.assertThat(entryPoint.getCss().stream().map(CssData::toString).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"value: ./foo.css", "value: ./foo.css include:bar", "value: ./foo.css id:bar", "value: ./foo.css themefor:bar"}));
        }
    }

    @Test
    public void should_gatherCssImportsInOrderPerClass() throws Exception {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(CssClass3.class);
        Assert.assertEquals((long)2L, (long)deps.getEntryPoints().size());
        for (EntryPointData entryPoint : deps.getEntryPoints()) {
            if (entryPoint.getName().equals(UI.class.getName())) continue;
            Assert.assertEquals((String)("Wrong amount of css in " + entryPoint.getName()), (long)4L, (long)entryPoint.getCss().size());
            MatcherAssert.assertThat(entryPoint.getCss().stream().map(CssData::toString).collect(Collectors.toList()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"value: ./foo.css", "value: ./bar.css", "value: ./foofoo.css", "value: ./foobar.css"}));
        }
    }

    @Test
    public void should_sumarizeCssImports() throws Exception {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.CssClass1.class, ScannerTestComponents.CssClass2.class);
        DepsTests.assertImportCount(4, deps.getCss());
    }

    @Route(value="css-route-3")
    @CssImport.Container(value={@CssImport(value="./foo.css"), @CssImport(value="./bar.css"), @CssImport(value="./foofoo.css"), @CssImport(value="./foobar.css")})
    public static class CssClass3 {
    }
}

