/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.scanner.AbstractScannerPwaTest;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FullDependenciesScanner;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockito.Mockito;

public class FullScannerPwaTest
extends AbstractScannerPwaTest {
    private ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);

    @Override
    protected PwaConfiguration getPwaConfiguration(Class<?> ... classes) throws Exception {
        Class<Object> clazz = Object.class;
        ((ClassFinder)Mockito.doReturn(clazz).when((Object)this.finder)).loadClass(PWA.class.getName());
        ((ClassFinder)Mockito.doReturn(this.getPwaAnnotatedClasses(classes)).when((Object)this.finder)).getAnnotatedClasses(clazz);
        FullDependenciesScanner fullDependenciesScanner = new FullDependenciesScanner(this.finder, (SerializableBiFunction & Serializable)(type, annotation) -> this.findPwaAnnotations((Class<?>)type), null, true);
        return fullDependenciesScanner.getPwaConfiguration();
    }

    private Set<Class<?>> getPwaAnnotatedClasses(Class<?>[] classes) {
        HashSet result = new HashSet();
        for (Class<?> clazz : classes) {
            if (((PWA[])clazz.getAnnotationsByType(PWA.class)).length <= 0) continue;
            result.add(clazz);
        }
        return result;
    }

    private List<? extends Annotation> findPwaAnnotations(Class<?> type) {
        return Arrays.asList((PWA[])type.getAnnotationsByType(PWA.class));
    }
}

