/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.DepsTests;
import com.vaadin.flow.server.frontend.scanner.FullDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class FullDependenciesScannerTest {
    private ClassFinder finder;

    @Before
    public void setUp() throws ClassNotFoundException {
        this.finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)this.finder.loadClass(AbstractTheme.class.getName())).thenReturn(AbstractTheme.class);
    }

    @Test
    public void getTheme_noExplicitTheme_noThemeIsDiscovered() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpThemeScanner(Collections.emptySet(), Collections.emptySet(), (SerializableBiFunction & Serializable)(type, annotationType) -> Collections.emptyList());
        ((ClassFinder)Mockito.verify((Object)this.finder)).loadClass(AbstractTheme.class.getName());
        Assert.assertNull((Object)scanner.getTheme());
        Assert.assertEquals((long)0L, (long)scanner.getClasses().size());
    }

    @Test
    public void getTheme_noTheme_noThemeIsDiscovered() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpThemeScanner(Collections.emptySet(), new HashSet(Arrays.asList(NoThemeComponent.class, NoThemeComponent1.class)), (SerializableBiFunction & Serializable)(type, annotationType) -> Collections.emptyList());
        ((ClassFinder)Mockito.verify((Object)this.finder)).loadClass(AbstractTheme.class.getName());
        Assert.assertNull((Object)scanner.getTheme());
        Assert.assertNull((Object)scanner.getThemeDefinition());
        Assert.assertEquals((long)0L, (long)scanner.getClasses().size());
        Assert.assertFalse((boolean)DepsTests.merge(scanner.getModules()).contains("./foo-bar-baz.js"));
    }

    @Test
    public void getTheme_explicitTheme_themeIsDiscovered() throws ClassNotFoundException {
        Mockito.when((Object)this.finder.loadClass(NodeTestComponents.LumoTest.class.getName())).thenReturn(NodeTestComponents.LumoTest.class);
        FullDependenciesScanner scanner = this.setUpThemeScanner(this.getAnnotatedClasses(Theme.class), Collections.emptySet(), (SerializableBiFunction & Serializable)(type, annotationType) -> this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)Theme.class));
        ((ClassFinder)Mockito.verify((Object)this.finder)).loadClass(AbstractTheme.class.getName());
        Assert.assertNotNull((Object)scanner.getTheme());
        Assert.assertEquals((Object)"theme/lumo/", (Object)scanner.getTheme().getThemeUrl());
        Assert.assertEquals(NodeTestComponents.LumoTest.class, (Object)scanner.getThemeDefinition().getTheme());
        Assert.assertEquals((Object)"dark", (Object)scanner.getThemeDefinition().getVariant());
        Assert.assertEquals((long)0L, (long)scanner.getClasses().size());
    }

    @Test
    public void themeWithCssDefined_cssLoaded() throws ClassNotFoundException {
        Mockito.when((Object)this.finder.loadClass(NodeTestComponents.LumoTest.class.getName())).thenReturn(NodeTestComponents.LumoTest.class);
        Mockito.when((Object)this.finder.loadClass(CssImport.class.getName())).thenReturn(CssImport.class);
        Mockito.when((Object)this.finder.getAnnotatedClasses(CssImport.class)).thenReturn(this.getAnnotatedClasses(CssImport.class));
        FullDependenciesScanner scanner = this.setUpThemeScanner(this.getAnnotatedClasses(Theme.class), Collections.emptySet(), (SerializableBiFunction & Serializable)(type, annotationType) -> {
            if (annotationType.equals(CssImport.class)) {
                return this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)CssImport.class);
            }
            return this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)Theme.class);
        });
        ((ClassFinder)Mockito.verify((Object)this.finder)).loadClass(AbstractTheme.class.getName());
        Assert.assertNotNull((Object)scanner.getTheme());
        Assert.assertTrue((boolean)DepsTests.merge(scanner.getCss()).stream().map(CssData::getValue).toList().contains("lumo-css-import.css"));
    }

    @Test
    public void themeWithCssOnClassPath_notDefinedAsTheme_cssNotLoaded() throws ClassNotFoundException {
        Mockito.when((Object)this.finder.loadClass(NodeTestComponents.LumoTest.class.getName())).thenReturn(NodeTestComponents.LumoTest.class);
        Mockito.when((Object)this.finder.loadClass(CssImport.class.getName())).thenReturn(CssImport.class);
        LinkedHashSet<Class> result = new LinkedHashSet<Class>();
        for (Class clazz : Arrays.asList(NoThemeComponent.class, NoThemeComponent1.class, FakeLumoTheme.class)) {
            if (((CssImport[])clazz.getAnnotationsByType(CssImport.class)).length <= 0) continue;
            result.add(clazz);
        }
        Mockito.when((Object)this.finder.getAnnotatedClasses(CssImport.class)).thenReturn(result);
        FullDependenciesScanner scanner = new FullDependenciesScanner(this.finder, (SerializableBiFunction & Serializable)(type, annotation) -> this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)CssImport.class), null, true);
        ((ClassFinder)Mockito.verify((Object)this.finder)).loadClass(AbstractTheme.class.getName());
        Assert.assertNull((Object)scanner.getTheme());
        Assert.assertFalse((boolean)DepsTests.merge(scanner.getCss()).stream().map(CssData::getValue).toList().contains("lumo-css-import.css"));
    }

    @Test(expected=IllegalStateException.class)
    public void getTheme_noThemeAndExplicitTheme_throws() throws ClassNotFoundException {
        this.setUpThemeScanner(this.getAnnotatedClasses(Theme.class), Collections.singleton(NoThemeComponent.class), (SerializableBiFunction & Serializable)(type, annotationType) -> this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)Theme.class));
    }

    @Test(expected=IllegalStateException.class)
    public void getTheme_severalExplicitThemes_throws() throws ClassNotFoundException {
        Set<Class<?>> themeAnnotatedClasses = this.getAnnotatedClasses(Theme.class);
        themeAnnotatedClasses.add(ThemedComponent.class);
        this.setUpThemeScanner(themeAnnotatedClasses, Collections.emptySet(), (SerializableBiFunction & Serializable)(type, annotationType) -> this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)Theme.class));
    }

    @Test
    public void getPackages_returnsAllPackages_getClassesReturnAllPackageAnnotatedComponents() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpAnnotationScanner(NpmPackage.class);
        Map packages = scanner.getPackages();
        Assert.assertEquals(packages.get("@vaadin/vaadin-button"), (Object)"1.1.1");
        Assert.assertEquals(packages.get("@vaadin/vaadin-element-mixin"), (Object)"1.1.2");
        Assert.assertEquals(packages.get("@foo/var-component"), (Object)"1.1.0");
        Assert.assertEquals(packages.get("@webcomponents/webcomponentsjs"), (Object)"2.2.10");
        Assert.assertEquals(packages.get("images"), (Object)"1.1.1");
        Assert.assertEquals((long)5L, (long)packages.size());
        Set visitedClasses = scanner.getClasses();
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.LocalP3Template.class.getName()));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.BUTTON_COMPONENT_FQN));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.VaadinElementMixin.class.getName()));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.ExtraImport.class.getName()));
    }

    @Test
    public void getAllPackages_returnsAllPackages_packagesAreOrganized_getClassesReturnAllPackageAnnotatedComponents() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpAnnotationScanner(NpmPackage.class);
        Map packages = scanner.getPackages();
        Map devPackages = scanner.getDevPackages();
        Assert.assertEquals(packages.get("@vaadin/vaadin-button"), (Object)"1.1.1");
        Assert.assertEquals(packages.get("@vaadin/vaadin-element-mixin"), (Object)"1.1.2");
        Assert.assertEquals(packages.get("@foo/var-component"), (Object)"1.1.0");
        Assert.assertEquals(packages.get("@webcomponents/webcomponentsjs"), (Object)"2.2.10");
        Assert.assertEquals(packages.get("images"), (Object)"1.1.1");
        Assert.assertEquals(devPackages.get("vite-plugin-pwa"), (Object)"0.16.5");
        Assert.assertEquals((long)5L, (long)packages.size());
        Assert.assertEquals((long)1L, (long)devPackages.size());
        Set visitedClasses = scanner.getClasses();
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.LocalP3Template.class.getName()));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.BUTTON_COMPONENT_FQN));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.VaadinElementMixin.class.getName()));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.ExtraImport.class.getName()));
    }

    @Test
    public void getScripts_returnAllScripts_orderPerClassIsPreserved_getClassesReturnAllJSAnnotatedComponents() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpAnnotationScanner(JavaScript.class);
        DepsTests.assertImports(scanner.getScripts(), "experimental-Connector.js", "javascript/a.js", "javascript/b.js", "javascript/c.js", "ExampleConnector.js");
        Set visitedClasses = scanner.getClasses();
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.VaadinBowerComponent.class.getName()));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.JavaScriptOrder.class.getName()));
    }

    @Test
    public void getScripts_returnAllJsModules_orderPerClassIsPreserved_getClassesReturnAllJSAnnotatedComponents() throws ClassNotFoundException {
        ArrayList<String> expectedModulesInOrder = new ArrayList<String>();
        expectedModulesInOrder.add("jsmodule/h.js");
        expectedModulesInOrder.add("jsmodule/g.js");
        FullDependenciesScanner scanner = this.setUpAnnotationScanner(JsModule.class);
        DepsTests.assertImportsWithFilter(scanner.getModules(), jsmodule -> expectedModulesInOrder.contains(jsmodule), (String[])expectedModulesInOrder.toArray(String[]::new));
        Set visitedClasses = scanner.getClasses();
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.VaadinBowerComponent.class.getName()));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.JavaScriptOrder.class.getName()));
    }

    @Test
    public void getCss_returnAllCss_orderPerClassIsPreserved_getClassesReturnAllCssAnnotatedComponents() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpAnnotationScanner(CssImport.class);
        ArrayList<CssData> expected = new ArrayList<CssData>();
        expected.add(this.createCssData("@vaadin/vaadin-mixed-component/bar.css", null, null, null));
        expected.add(this.createCssData("./foo.css", null, null, null));
        expected.add(this.createCssData("./foo.css", null, "bar", null));
        expected.add(this.createCssData("./foo.css", "baz", null, null));
        expected.add(this.createCssData("./foo.css", "baz", "bar", null));
        expected.add(this.createCssData("./foo.css", null, null, "foo-bar"));
        expected.add(this.createCssData("./foo.css", null, "bar", "foo-bar"));
        DepsTests.assertCss(scanner.getCss(), expected);
        Set visitedClasses = scanner.getClasses();
        Assert.assertEquals((long)2L, (long)visitedClasses.size());
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.FlatImport.class.getName()));
        Assert.assertTrue((boolean)visitedClasses.contains(NodeTestComponents.LumoTest.class.getName()));
    }

    @Test
    public void getModules_noTheme_returnAllModules_orderPerClassIsPreserved_getClassesReturnAllModuleAnnotatedComponents() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpAnnotationScanner(JsModule.class);
        DepsTests.assertImportCount(20, scanner.getModules());
        this.assertJsModules(DepsTests.merge(scanner.getModules()));
        Set classes = scanner.getClasses();
        Assert.assertEquals((long)14L, (long)classes.size());
        this.assertJsModulesClasses(classes);
    }

    @Test
    public void getModules_explcitTheme_returnAllModulesExcludingNotUsedTheme_getClassesReturnAllModuleAnnotatedComponents() throws ClassNotFoundException {
        Class<Object> clazz = Object.class;
        Mockito.when((Object)this.finder.loadClass(JsModule.class.getName())).thenReturn(clazz);
        Mockito.when((Object)this.finder.getAnnotatedClasses(clazz)).thenReturn(this.getAnnotatedClasses(JsModule.class));
        Class<Throwable> themeClass = Throwable.class;
        Mockito.when((Object)this.finder.loadClass(Theme.class.getName())).thenReturn(themeClass);
        Set<Class<?>> themeClasses = this.getAnnotatedClasses(Theme.class);
        themeClasses.add(FakeLumoTheme.class);
        Mockito.when((Object)this.finder.getAnnotatedClasses(themeClass)).thenReturn(themeClasses);
        Assert.assertTrue((themeClasses.size() >= 2 ? 1 : 0) != 0);
        Mockito.when((Object)this.finder.loadClass(NodeTestComponents.LumoTest.class.getName())).thenReturn(NodeTestComponents.LumoTest.class);
        Mockito.when((Object)this.finder.loadClass(FakeLumoTheme.class.getName())).thenReturn(FakeLumoTheme.class);
        FullDependenciesScanner scanner = new FullDependenciesScanner(this.finder, (SerializableBiFunction & Serializable)(type, annotation) -> {
            if (annotation.equals(clazz)) {
                return this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)JsModule.class);
            }
            if (annotation.equals(themeClass)) {
                return this.findAnnotations((Class<?>)type, (Class<? extends Annotation>)Theme.class);
            }
            Assert.fail();
            return null;
        }, null, true);
        DepsTests.assertImportCount(28, scanner.getModules());
        List<String> modules = DepsTests.merge(scanner.getModules());
        this.assertJsModules(modules);
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-lumo-styles/color.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-lumo-styles/typography.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-lumo-styles/sizing.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-lumo-styles/spacing.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-lumo-styles/style.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-lumo-styles/icons.js"));
        Assert.assertFalse((boolean)modules.contains("./foo-bar-baz.js"));
        Set classes = scanner.getClasses();
        Assert.assertEquals((long)14L, (long)classes.size());
        this.assertJsModulesClasses(classes);
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.LumoTest.class.getName()));
        Assert.assertFalse((boolean)classes.contains(FakeLumoTheme.class.getName()));
    }

    @Test
    public void getAllPackageAssets_returnsAllPackages_collectsAssets() throws ClassNotFoundException {
        FullDependenciesScanner scanner = this.setUpAnnotationScanner(NpmPackage.class);
        Map assets = scanner.getAssets();
        Map devAssets = scanner.getDevAssets();
        Assert.assertEquals((long)2L, (long)assets.size());
        Assert.assertEquals((long)1L, (long)devAssets.size());
        Assert.assertTrue((boolean)assets.containsKey("@vaadin/vaadin-button"));
        Assert.assertTrue((boolean)assets.containsKey("images"));
        Assert.assertTrue((boolean)devAssets.containsKey("vite-plugin-pwa"));
        Assert.assertEquals((long)1L, (long)((List)assets.get("@vaadin/vaadin-button")).size());
        Assert.assertEquals((long)2L, (long)((List)assets.get("images")).size());
        Assert.assertEquals((long)1L, (long)((List)devAssets.get("vite-plugin-pwa")).size());
        Assert.assertEquals((Object)"img/arrow*:img", ((List)assets.get("@vaadin/vaadin-button")).get(0));
        Assert.assertEquals((Object)"frown/**:pwa", ((List)devAssets.get("vite-plugin-pwa")).get(0));
    }

    private CssData createCssData(String value, String id, String include, String themefor) {
        return new CssData(value, id, include, themefor);
    }

    private List<? extends Annotation> findAnnotations(Class<?> type, Class<? extends Annotation> annotationType) {
        return Arrays.asList(type.getAnnotationsByType(annotationType));
    }

    private Set<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotationType) {
        Class<?>[] classes = NodeTestComponents.class.getDeclaredClasses();
        Arrays.sort(classes, Comparator.comparing(Class::getName));
        LinkedHashSet result = new LinkedHashSet();
        for (Class<?> clazz : classes) {
            if (clazz.getAnnotationsByType(annotationType).length <= 0) continue;
            result.add(clazz);
        }
        return result;
    }

    private FullDependenciesScanner setUpAnnotationScanner(Class<? extends Annotation> annotationType) throws ClassNotFoundException {
        Class<Object> clazz = Object.class;
        Mockito.when((Object)this.finder.loadClass(annotationType.getName())).thenReturn(clazz);
        Mockito.when((Object)this.finder.getAnnotatedClasses(clazz)).thenReturn(this.getAnnotatedClasses(annotationType));
        return new FullDependenciesScanner(this.finder, (SerializableBiFunction & Serializable)(type, annotation) -> this.findAnnotations((Class<?>)type, annotationType), null, true);
    }

    private FullDependenciesScanner setUpThemeScanner(Set<Class<?>> themedClasses, Set<Class<?>> noThemeClasses, SerializableBiFunction<Class<?>, Class<? extends Annotation>, List<? extends Annotation>> annotationFinder) throws ClassNotFoundException {
        Class<Object> fakeThemeClass = Object.class;
        Class<Throwable> fakeNoThemeClass = Throwable.class;
        Mockito.when((Object)this.finder.loadClass(Theme.class.getName())).thenReturn(fakeThemeClass);
        Mockito.when((Object)this.finder.loadClass(NoTheme.class.getName())).thenReturn(fakeNoThemeClass);
        Mockito.when((Object)this.finder.getAnnotatedClasses(fakeThemeClass)).thenReturn(themedClasses);
        Mockito.when((Object)this.finder.getAnnotatedClasses(fakeNoThemeClass)).thenReturn(noThemeClasses);
        return new FullDependenciesScanner(this.finder, annotationFinder, null, true){};
    }

    private void assertJsModules(List<String> modules) {
        Assert.assertTrue((boolean)modules.contains("@polymer/iron-icon/iron-icon.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-date-picker/src/vaadin-date-picker.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-date-picker/src/vaadin-month-calendar.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-element-mixin/vaadin-element-mixin.js"));
        Assert.assertTrue((boolean)modules.contains("./foo-dir/vaadin-npm-component.js"));
        Assert.assertTrue((boolean)modules.contains("vaadin-mixed-component/src/vaadin-mixed-component.js"));
        Assert.assertTrue((boolean)modules.contains("./local-template.js"));
        Assert.assertTrue((boolean)modules.contains("3rdparty/component.js"));
        Assert.assertTrue((boolean)modules.contains("./local-p3-template.js"));
        Assert.assertTrue((boolean)modules.contains("unresolved/component"));
        Assert.assertTrue((boolean)modules.contains("./foo.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-mixed-component/src/vaadin-mixed-component.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-mixed-component/src/vaadin-something-else.js"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-mixed-component/src/vaadin-something-else"));
        Assert.assertTrue((boolean)modules.contains("@vaadin/vaadin-mixed-component/src/vaadin-custom-themed-component.js"));
        Assert.assertTrue((boolean)modules.contains("./common-js-file.js"));
        Assert.assertTrue((boolean)modules.contains("jsmodule/g.js"));
        List modulesPerClass = modules.stream().filter(module -> module.startsWith("@vaadin/vaadin-date-picker")).collect(Collectors.toList());
        Assert.assertEquals((Object)"@vaadin/vaadin-date-picker/src/vaadin-date-picker.js", modulesPerClass.get(0));
        Assert.assertEquals((Object)"@vaadin/vaadin-date-picker/src/vaadin-month-calendar.js", modulesPerClass.get(1));
        modulesPerClass = modules.stream().filter(module -> module.startsWith("@vaadin/vaadin-mixed-component")).collect(Collectors.toList());
        Assert.assertEquals((Object)"@vaadin/vaadin-mixed-component/src/vaadin-mixed-component.js", modulesPerClass.get(0));
        Assert.assertEquals((Object)"@vaadin/vaadin-mixed-component/src/vaadin-something-else.js", modulesPerClass.get(1));
        Assert.assertEquals((Object)"@vaadin/vaadin-mixed-component/src/vaadin-something-else", modulesPerClass.get(2));
        Assert.assertEquals((Object)"@vaadin/vaadin-mixed-component/src/vaadin-custom-themed-component.js", modulesPerClass.get(3));
    }

    private void assertJsModulesClasses(Set<String> classes) {
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.ICON_COMPONENT_FQN));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.VaadinBowerComponent.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.VaadinElementMixin.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.VaadinNpmComponent.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.VaadinMixedComponent.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.LocalTemplate.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.LocalP3Template.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.UnresolvedComponent.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.FlatImport.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.MainLayout.class.getName()));
        Assert.assertTrue((boolean)classes.contains(NodeTestComponents.JavaScriptOrder.class.getName()));
    }

    @NoTheme
    private static class NoThemeComponent
    extends Component {
        private NoThemeComponent() {
        }
    }

    @NoTheme
    private static class NoThemeComponent1
    extends Component {
        private NoThemeComponent1() {
        }
    }

    @JsModule(value="./foo-bar-baz.js")
    public static class FakeLumoTheme
    implements AbstractTheme {
        public String getBaseUrl() {
            return "foo";
        }

        public String getThemeUrl() {
            return null;
        }
    }

    @Theme(themeClass=FakeLumoTheme.class)
    public static class ThemedComponent
    extends Component {
    }
}

