/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.CssData;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;

public class DepsTests {
    public static final String UI_IMPORT = "@vaadin/common-frontend/ConnectionIndicator.js";

    public static <T> List<T> merge(Map<ChunkInfo, List<T>> values) {
        LinkedHashSet result = new LinkedHashSet();
        values.forEach((key, value) -> result.addAll(value));
        return new ArrayList(result);
    }

    public static void assertImports(Map<ChunkInfo, List<String>> actualUrls, String ... expectedUrls) {
        List actual = DepsTests.merge(actualUrls);
        Assert.assertEquals(List.of(expectedUrls), actual);
    }

    public static void assertImportsExcludingUI(Map<ChunkInfo, List<String>> actualUrls, String ... expectedUrls) {
        for (ChunkInfo key : actualUrls.keySet()) {
            actualUrls.get(key).removeIf(imp -> imp.equals(UI_IMPORT));
        }
        DepsTests.assertImports(actualUrls, expectedUrls);
    }

    public static void assertImportsWithFilter(Map<ChunkInfo, List<String>> actualUrls, Predicate<String> filter, String ... expectedUrls) {
        Assert.assertEquals(List.of(expectedUrls), DepsTests.merge(actualUrls).stream().filter(filter).collect(Collectors.toList()));
    }

    public static void assertHasImports(Map<ChunkInfo, List<String>> modules, String ... urls) {
        List all = DepsTests.merge(modules);
        Assert.assertTrue((boolean)all.containsAll(List.of(urls)));
    }

    static void assertCss(Map<ChunkInfo, List<CssData>> actual, List<CssData> expected) {
        List all = DepsTests.merge(actual);
        Assert.assertEquals(expected, all);
    }

    public static <T> void assertImportCount(int expected, Map<ChunkInfo, List<T>> imports) {
        Assert.assertEquals((long)expected, (long)DepsTests.merge(imports).size());
    }
}

