/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.internal.Platform;
import com.vaadin.flow.server.frontend.installer.InstallationException;
import com.vaadin.flow.server.frontend.installer.NodeInstaller;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class NodeInstallerTest {
    @Rule
    public final TemporaryFolder tmpDir = new TemporaryFolder();
    private String baseDir;

    @Before
    public void setup() {
        this.baseDir = this.tmpDir.getRoot().getAbsolutePath();
    }

    @Test
    public void installNodeFromFileSystem_NodeIsInstalledToTargetDirectory() throws IOException {
        Platform platform = Platform.guess();
        String nodeExec = platform.isWindows() ? "node.exe" : "node";
        String prefix = String.format("node-%s-%s", "v24.12.0", platform.getNodeClassifier(new FrontendVersion("v24.12.0")));
        File targetDir = new File(this.baseDir + "/installation");
        Assert.assertFalse((String)"Clean test should not contain a installation folder", (boolean)targetDir.exists());
        File downloadDir = this.tmpDir.newFolder("v24.12.0");
        File archiveFile = new File(downloadDir, prefix + "." + platform.getArchiveExtension());
        archiveFile.createNewFile();
        Path tempArchive = archiveFile.toPath();
        if (platform.getArchiveExtension().equals("zip")) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempArchive, new OpenOption[0]));){
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/" + nodeExec));
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/node_modules/npm/bin/npm"));
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/node_modules/npm/bin/npm.cmd"));
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/npm.cmd"));
                zipOutputStream.closeEntry();
            }
        }
        File tempDir = this.tmpDir.newFolder("archiveContent");
        File nodeDir = new File(tempDir, prefix);
        File binDir = new File(nodeDir, "bin");
        File libDir = new File(nodeDir, "lib");
        File libNodeModulesDir = new File(libDir, "node_modules");
        File npmDir = new File(libNodeModulesDir, "npm");
        File npmBinDir = new File(npmDir, "bin");
        binDir.mkdirs();
        npmBinDir.mkdirs();
        new File(binDir, nodeExec).createNewFile();
        new File(binDir, "npm").createNewFile();
        new File(binDir, "npx").createNewFile();
        new File(npmBinDir, "npm").createNewFile();
        new File(npmBinDir, "npm.cmd").createNewFile();
        try (OutputStream fo = Files.newOutputStream(tempArchive, new OpenOption[0]);
             GzipCompressorOutputStream gzo = new GzipCompressorOutputStream(fo);
             TarArchiveOutputStream o = new TarArchiveOutputStream((OutputStream)gzo);){
            TarArchiveEntry dirEntry = new TarArchiveEntry(prefix + "/");
            o.putArchiveEntry(dirEntry);
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(binDir, nodeExec), prefix + "/bin/" + nodeExec));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(binDir, "npm"), prefix + "/bin/npm"));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(binDir, "npx"), prefix + "/bin/npx"));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(npmBinDir, "npm"), prefix + "/lib/node_modules/npm/bin/npm"));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(npmBinDir, "npm.cmd"), prefix + "/lib/node_modules/npm/bin/npm.cmd"));
            o.closeArchiveEntry();
        }
        NodeInstaller nodeInstaller = new NodeInstaller(targetDir, Collections.emptyList()).setNodeVersion("v24.12.0").setNodeDownloadRoot(new File(this.baseDir).toPath().toUri());
        try {
            nodeInstaller.install();
        }
        catch (InstallationException e) {
            throw new IllegalStateException("Failed to install Node", e);
        }
        String versionedNodeDir = "node-v24.12.0";
        String nodeInstallPath = platform.isWindows() ? versionedNodeDir + "/" + nodeExec : versionedNodeDir + "/bin/" + nodeExec;
        Assert.assertTrue((String)"node should have been installed", (boolean)new File(targetDir, nodeInstallPath).exists());
        String npmInstallPath = platform.isWindows() ? versionedNodeDir + "/node_modules/npm/bin/npm" : versionedNodeDir + "/lib/node_modules/npm/bin/npm";
        Assert.assertTrue((String)"npm should have been copied to node_modules", (boolean)new File(targetDir, npmInstallPath).exists());
        String npmBinPath = platform.isWindows() ? versionedNodeDir + "/npm.cmd" : versionedNodeDir + "/bin/npm";
        Assert.assertTrue((String)"npm should be available in bin", (boolean)new File(targetDir, npmBinPath).exists());
    }

    @Test
    public void testGuess_whenOsIsLinuxAndAlpineReleaseFileExists_unofficialNodeDownloadPathReturned() {
        try (MockedStatic os = Mockito.mockStatic(Platform.OS.class);
             MockedStatic paths = Mockito.mockStatic(Paths.class);
             MockedStatic files = Mockito.mockStatic(Files.class);){
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.LINUX);
            Path alpineReleaseFilePath = Paths.get("/etc/alpine-release", new String[0]);
            paths.when(() -> Paths.get("/etc/alpine-release", new String[0])).thenReturn((Object)alpineReleaseFilePath);
            files.when(() -> Files.exists(alpineReleaseFilePath, new LinkOption[0])).thenReturn((Object)true);
            Platform platform = Platform.guess();
            Assert.assertEquals((Object)"https://unofficial-builds.nodejs.org/download/release/", (Object)NodeInstaller.getDownloadRoot((Platform)platform));
            FrontendVersion frontendVersion = (FrontendVersion)Mockito.mock(FrontendVersion.class);
            Assert.assertTrue((boolean)platform.getNodeClassifier(frontendVersion).contains("-musl"));
        }
    }

    @Test
    public void testGuess_whenOsIsLinuxAndAlpineReleaseFileDoesNotExist_officialNodeDownloadPathReturned() {
        try (MockedStatic os = Mockito.mockStatic(Platform.OS.class);){
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.LINUX);
            Platform platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)NodeInstaller.getDownloadRoot((Platform)platform));
            FrontendVersion frontendVersion = (FrontendVersion)Mockito.mock(FrontendVersion.class);
            Assert.assertFalse((boolean)platform.getNodeClassifier(frontendVersion).contains("-musl"));
        }
    }

    @Test
    public void testGuess_whenOsIsAnythingOtherThanLinuxAlpineRelease_officialNodeDownloadPathReturned() {
        try (MockedStatic os = Mockito.mockStatic(Platform.OS.class);){
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.WINDOWS);
            Platform platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)NodeInstaller.getDownloadRoot((Platform)platform));
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.MAC);
            platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)NodeInstaller.getDownloadRoot((Platform)platform));
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.SUN_OS);
            platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)NodeInstaller.getDownloadRoot((Platform)platform));
        }
    }
}

