/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.VersionsJsonFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.node.ObjectNode;

public class VersionsJsonFilterTest {
    private static final ObjectNode TEST_VERSION_JSON = JacksonUtils.readTree((String)"{\n    \"@vaadin/vaadin-progress-bar\": \"1.1.2\",\n    \"@vaadin/vaadin-upload\":  \"4.2.2\",\n    \"@polymer/iron-list\":  \"2.0.19\",\n    \"enforced\": \"1.5.0\",\n    \"platform\": \"foo\"\n  }\n\n");

    @Test
    public void filterPlatformVersions_dependencies() throws IOException {
        this.assertFilterPlatformVersions("dependencies");
    }

    @Test
    public void filterPlatformVersions_devDependencies() throws IOException {
        this.assertFilterPlatformVersions("devDependencies");
    }

    @Test
    public void filterPlatformDependenciesVersions_multipleUserChanged_correctlyIgnored() throws IOException {
        this.assertFilterPlatformVersions_multipleUserChanged_correctlyIgnored("dependencies");
    }

    @Test
    public void filterPlatformDevDependenciesVersions_multipleUserChanged_correctlyIgnored() throws IOException {
        this.assertFilterPlatformVersions_multipleUserChanged_correctlyIgnored("devDependencies");
    }

    @Test
    public void missingVaadinDependencies_allDependenciesShouldBeUserHandled() throws IOException {
        this.assertMissingVaadinDependencies_allDependenciesSholdBeUserHandled("dependencies");
    }

    @Test
    public void missingVaadinDevDependencies_allDependenciesSholdBeUserHandled() throws IOException {
        this.assertMissingVaadinDependencies_allDependenciesSholdBeUserHandled("devDependencies");
    }

    @Test
    public void testGetFilteredVersions_whenErrorHappens_versionOriginParameterIsUsedInErrorLogs() throws IOException {
        String pkgJson = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("versions/no_vaadin_package.json")), (Charset)StandardCharsets.UTF_8);
        ObjectNode packageJson = JacksonUtils.readTree((String)pkgJson);
        VersionsJsonFilter filter = new VersionsJsonFilter(packageJson, "dependencies");
        String versionOrigin = "dummy-origin.json";
        Logger logger = (Logger)Mockito.spy(Logger.class);
        try (MockedStatic loggerFactoryMocked = Mockito.mockStatic(LoggerFactory.class);){
            loggerFactoryMocked.when(() -> LoggerFactory.getLogger(FrontendVersion.class)).thenReturn((Object)logger);
            ObjectNode sourceJsonMocked = this.getMockedJsonNode();
            Mockito.when((Object)sourceJsonMocked.get(Mockito.anyString())).thenThrow(new Throwable[]{new ClassCastException()});
            filter.getFilteredVersions(sourceJsonMocked, versionOrigin);
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).warn("Ignoring error while parsing frontend dependency version for package '{}' in '{}'", (Object)"test", (Object)versionOrigin);
            sourceJsonMocked = this.getMockedJsonNode();
            String nfeMessage = "NFE MSG";
            Mockito.when((Object)sourceJsonMocked.get(Mockito.anyString())).thenThrow(new Throwable[]{new NumberFormatException(nfeMessage)});
            filter.getFilteredVersions(sourceJsonMocked, versionOrigin);
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).warn("Ignoring error while parsing frontend dependency version in {}: {}", (Object)versionOrigin, (Object)nfeMessage);
        }
    }

    private ObjectNode getMockedJsonNode() {
        ObjectNode jsonObject = (ObjectNode)Mockito.mock(ObjectNode.class);
        Mockito.when((Object)jsonObject.propertyNames()).thenReturn(Arrays.stream(new String[]{"test"}).toList());
        Mockito.when((Object)jsonObject.has("test")).thenReturn((Object)true);
        return jsonObject;
    }

    private void assertMissingVaadinDependencies_allDependenciesSholdBeUserHandled(String depKey) throws IOException {
        String pkgJson = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("versions/no_vaadin_package.json")), (Charset)StandardCharsets.UTF_8);
        VersionsJsonFilter filter = new VersionsJsonFilter(JacksonUtils.readTree((String)pkgJson), depKey);
        ObjectNode filteredJson = filter.getFilteredVersions(TEST_VERSION_JSON, "versions/versions.json");
        Assert.assertTrue((boolean)filteredJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)filteredJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)filteredJson.has("@polymer/iron-list"));
        Assert.assertEquals((Object)"1.1.2", (Object)filteredJson.get("@vaadin/vaadin-progress-bar").asString());
    }

    private void assertFilterPlatformVersions_multipleUserChanged_correctlyIgnored(String depKey) throws IOException {
        String versions = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("versions/user_versions.json")), (Charset)StandardCharsets.UTF_8);
        String pkgJson = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("versions/user_package.json")), (Charset)StandardCharsets.UTF_8);
        VersionsJsonFilter filter = new VersionsJsonFilter(JacksonUtils.readTree((String)pkgJson), depKey);
        ObjectNode filteredJson = filter.getFilteredVersions(JacksonUtils.readTree((String)versions), "versions/user_versions.json");
        List<String> expectedKeys = Arrays.asList("@vaadin/vaadin-notification", "@vaadin/vaadin-overlay", "@vaadin/vaadin-select", "@vaadin/vaadin-split-layout", "@vaadin/vaadin-tabs");
        for (String string : expectedKeys) {
            Assert.assertTrue((String)String.format("Key '%s' was expected, but not found", string), (boolean)filteredJson.has(string));
        }
        List<String> droppedKeys = Arrays.asList("flow", "core", "platform");
        for (String key : droppedKeys) {
            Assert.assertFalse((String)String.format("User managed key '%s' was found.", key), (boolean)filteredJson.has(key));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("@vaadin/vaadin-notification", "1.4.0");
        hashMap.put("@vaadin/vaadin-overlay", "3.2.19");
        hashMap.put("@vaadin/vaadin-select", "2.1.7");
        hashMap.put("@vaadin/vaadin-split-layout", "4.1.1");
        hashMap.put("@vaadin/vaadin-tabs", "3.0.5");
        for (Map.Entry entry : hashMap.entrySet()) {
            Assert.assertEquals((String)String.format("Got wrong version for '%s'", entry.getKey()), entry.getValue(), (Object)filteredJson.get((String)entry.getKey()).asString());
        }
    }

    private void assertFilterPlatformVersions(String depKey) throws IOException {
        String pkgJson = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("versions/package.json")), (Charset)StandardCharsets.UTF_8);
        VersionsJsonFilter filter = new VersionsJsonFilter(JacksonUtils.readTree((String)pkgJson), depKey);
        ObjectNode filteredJson = filter.getFilteredVersions(TEST_VERSION_JSON, "versions/versions.json");
        Assert.assertTrue((boolean)filteredJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)filteredJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)filteredJson.has("@polymer/iron-list"));
        Assert.assertEquals((String)"'progress-bar' should be the same in package and versions", (Object)"1.1.2", (Object)filteredJson.get("@vaadin/vaadin-progress-bar").asString());
        Assert.assertEquals((String)"'upload' should be the same in package and versions", (Object)"4.2.2", (Object)filteredJson.get("@vaadin/vaadin-upload").asString());
        Assert.assertEquals((String)"'enforced' version should come from platform (upgrade)", (Object)"1.5.0", (Object)filteredJson.get("enforced").asString());
        Assert.assertEquals((String)"'iron-list' version should come from platform (downgrade)", (Object)"2.0.19", (Object)filteredJson.get("@polymer/iron-list").asString());
    }
}

