/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class UpdateThemedImportsTest
extends NodeUpdateTestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private File importsFile;
    private File frontendDirectory;
    private File nodeModulesPath;
    private TaskUpdateImports updater;

    @Before
    public void setup() throws Exception {
        File tmpRoot = this.temporaryFolder.getRoot();
        this.frontendDirectory = new File(tmpRoot, "./src/main/frontend/");
        this.nodeModulesPath = new File(tmpRoot, "node_modules/");
        this.importsFile = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        Assert.assertTrue((boolean)this.nodeModulesPath.mkdirs());
        this.createImport("./src/subfolder/sub-template.js", "");
        this.createImport("./src/client-side-template.js", "import 'xx' from './subfolder/sub-template.js';import '@vaadin/vaadin-button/src/vaadin-button.js'");
        this.createImport("./src/client-side-no-themed-template.js", "");
        this.createImport("./src/main-template.js", "import 'xx' from './client-side-template.js';import \"./client-side-no-themed-template.js\";import './src/wrong-themed-template.js';import '@vaadin/vaadin-button/src/vaadin-button.js'");
        this.createImport("./theme/myTheme/subfolder/sub-template.js", "");
        this.createImport("./theme/myTheme/client-side-template.js", "");
        this.createImport("./theme/myTheme/main-template.js", "");
        this.createImport("theme/myTheme/wrong-themed-template.js", "");
        this.createImport("./foo.css", "");
        this.createImport("@vaadin/vaadin-mixed-component/bar.css", "");
        this.createImport("@vaadin/vaadin-button/src/vaadin-button.js", "");
        this.createImport("@vaadin/vaadin-button/theme/myTheme/vaadin-button.js", "");
        ClassFinder finder = UpdateThemedImportsTest.getClassFinder();
        FrontendDependencies deps = new FrontendDependencies(finder, true, null, true){

            public Map<ChunkInfo, List<String>> getModules() {
                return Collections.singletonMap(ChunkInfo.GLOBAL, List.of("./src/main-template.js"));
            }

            public Map<ChunkInfo, List<String>> getScripts() {
                return Collections.emptyMap();
            }

            public AbstractTheme getTheme() {
                return new MyTheme();
            }

            public ThemeDefinition getThemeDefinition() {
                return new ThemeDefinition(MyTheme.class, "", "");
            }
        };
        Options options = new MockOptions(finder, tmpRoot).withFrontendDirectory(this.frontendDirectory).withBuildDirectory("target").withProductionMode(true);
        this.updater = new TaskUpdateImports((FrontendDependenciesScanner)deps, options);
    }

    @Test
    public void themedClientSideModulesAreWrittenIntoImportsFile() throws Exception {
        this.updater.execute();
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/main-template.js';"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/client-side-template.js';"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/subfolder/sub-template.js';"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"import '@vaadin/vaadin-button/src/vaadin-button.js';"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"import 'theme/myTheme/wrong-themed-template.js';")));
    }

    @Test
    public void noDuplicateImportEntryIsWrittenIntoImportsFile() throws Exception {
        this.updater.execute();
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        int count = StringUtils.countMatches((CharSequence)content, (CharSequence)"import '@vaadin/vaadin-button/src/vaadin-button.js';");
        Assert.assertEquals((String)"Import entries in the imports file should be unique.", (long)1L, (long)count);
    }

    @Test
    public void directoryImportEntryIsResolvedAsIndexJS() throws Exception {
        this.createImport("./src/directory/index.js", "import { xx } from './sub1.js';");
        this.createImport("./src/directory/sub1.js", "");
        this.createImport("./src/main-template.js", "import 'xx' from './directory';");
        this.createImport("./theme/myTheme/directory/index.js", "");
        this.createImport("./theme/myTheme/directory/sub1.js", "");
        this.createImport("./theme/myTheme/main-template.js", "");
        this.updater.execute();
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/main-template.js';"), (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/directory';"), (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/directory/sub1.js';")));
    }

    @Test
    public void directoryImportEntry_avoidRecursion() throws Exception {
        this.createImport("./src/directory/index.js", "import { xx } from '../import2.js';");
        this.createImport("./src/import1.js", "import { xx } from './directory/';");
        this.createImport("./src/import2.js", "import 'xx' from './import1.js';");
        this.createImport("./src/main-template.js", "import 'xx' from './directory';");
        this.createImport("./theme/myTheme/directory", "");
        this.createImport("./theme/myTheme/import1.js", "");
        this.createImport("./theme/myTheme/import2.js", "");
        this.createImport("./theme/myTheme/main-template.js", "");
        this.updater.execute();
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/main-template.js';"), (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/directory';"), (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/import1.js';"), (Matcher)CoreMatchers.containsString((String)"import 'Frontend/theme/myTheme/import2.js';")));
    }

    private void createImport(String path, String content) throws IOException {
        File newFile = this.resolveImportFile(this.frontendDirectory, this.nodeModulesPath, path);
        newFile.getParentFile().mkdirs();
        newFile.delete();
        Assert.assertTrue((boolean)newFile.createNewFile());
        if (content != null) {
            Files.write(newFile.toPath(), Collections.singletonList(content), new OpenOption[0]);
        }
    }

    public static class MyTheme
    implements AbstractTheme {
        public String getBaseUrl() {
            return "src/";
        }

        public String getThemeUrl() {
            return "theme/myTheme/";
        }

        public List<String> getHeaderInlineContents() {
            return Collections.emptyList();
        }
    }
}

