/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.ThemeValidationUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

public class ThemeValidationUtilTest {
    @Test
    public void testObjectsIncludeMethodWithSameElementsInArrays() {
        ArrayNode jsonFromBundle = this.createArrayNode("a", "b", "c");
        ArrayNode projectJson = this.createArrayNode("a", "b", "c");
        ArrayList missedKeys = new ArrayList();
        boolean result = ThemeValidationUtil.objectIncludesEntry((JsonNode)jsonFromBundle, (JsonNode)projectJson, missedKeys);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)missedKeys.isEmpty());
    }

    @Test
    public void testObjectsIncludeMethodWithSameElementsInArraysDifferentOrder() {
        ArrayNode jsonFromBundle = this.createArrayNode("a", "b", "c");
        ArrayNode projectJson = this.createArrayNode("b", "a", "c");
        ArrayList missedKeys = new ArrayList();
        boolean result = ThemeValidationUtil.objectIncludesEntry((JsonNode)jsonFromBundle, (JsonNode)projectJson, missedKeys);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)missedKeys.isEmpty());
    }

    @Test
    public void testObjectsIncludeMethodArraysAreDifferent() {
        ArrayList missedKeysForBundle = new ArrayList();
        ArrayNode jsonFromBundle = this.createArrayNode("a", "c");
        ArrayNode jsonFromProject = this.createArrayNode("a", "b", "c");
        boolean result = ThemeValidationUtil.objectIncludesEntry((JsonNode)jsonFromBundle, (JsonNode)jsonFromProject, missedKeysForBundle);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals(missedKeysForBundle, List.of("\"b\""));
        ArrayList missedKeysForProject = new ArrayList();
        jsonFromBundle = this.createArrayNode("a", "b", "c");
        jsonFromProject = this.createArrayNode("a");
        result = ThemeValidationUtil.objectIncludesEntry((JsonNode)jsonFromProject, (JsonNode)jsonFromBundle, missedKeysForProject);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals(missedKeysForProject, List.of("\"b\"", "\"c\""));
    }

    @Test
    public void testObjectsIncludeMethodBothEmptyArraysAreEmpty() {
        ArrayList missedKeys = new ArrayList();
        boolean result = ThemeValidationUtil.objectIncludesEntry((JsonNode)JacksonUtils.createArrayNode(), (JsonNode)JacksonUtils.createArrayNode(), missedKeys);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)missedKeys.isEmpty());
    }

    @Test
    public void testObjectsIncludeMethodOneArrayIsEmpty() {
        ArrayList missedKeysFromProject = new ArrayList();
        ArrayNode jsonFromBundle = this.createArrayNode("a", "b", "c");
        ArrayNode jsonFromProjectEmpty = this.createArrayNode(new String[0]);
        boolean result = ThemeValidationUtil.objectIncludesEntry((JsonNode)jsonFromBundle, (JsonNode)jsonFromProjectEmpty, missedKeysFromProject);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals(missedKeysFromProject, List.of("\"a\"", "\"b\"", "\"c\""));
        ArrayList missedKeysFromBundle = new ArrayList();
        ArrayNode jsonFromProject = this.createArrayNode("a", "b", "c");
        ArrayNode jsonFromBundleEmpty = this.createArrayNode(new String[0]);
        result = ThemeValidationUtil.objectIncludesEntry((JsonNode)jsonFromBundleEmpty, (JsonNode)jsonFromProject, missedKeysFromBundle);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals(missedKeysFromBundle, List.of("\"a\"", "\"b\"", "\"c\""));
    }

    private ArrayNode createArrayNode(String ... values) {
        ArrayNode array = JacksonUtils.createArrayNode();
        for (String value : values) {
            array.add(value);
        }
        return array;
    }
}

