/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdateSettingsFile;
import com.vaadin.flow.server.frontend.TaskUpdateVite;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import tools.jackson.databind.node.ObjectNode;

public class TaskUpdateViteTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private ClassFinder finder;
    private Options options;

    @Before
    public void setUp() throws IOException {
        this.finder = (ClassFinder)Mockito.spy((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0]));
        this.options = new MockOptions(this.finder, this.temporaryFolder.getRoot()).withBuildDirectory("build");
    }

    @Test
    public void generatedTemplate_correctSettingsPath() throws IOException {
        TaskUpdateVite task = new TaskUpdateVite(this.options, null);
        task.execute();
        File configFile = new File(this.temporaryFolder.getRoot(), "vite.generated.ts");
        String template = IOUtils.toString((URI)configFile.toURI(), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((String)"Settings file folder was not correctly updated.", (boolean)template.contains("./build/vaadin-dev-server-settings.json"));
    }

    @Test
    public void configFileExists_fileNotOverwritten() throws IOException {
        File configFile = new File(this.temporaryFolder.getRoot(), "vite.config.ts");
        String importString = "Hello Fake configuration";
        FileUtils.write((File)configFile, (CharSequence)"Hello Fake configuration", (Charset)StandardCharsets.UTF_8);
        new TaskUpdateVite(this.options, null).execute();
        String template = IOUtils.toString((URI)configFile.toURI(), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Settings file content was changed", (Object)"Hello Fake configuration", (Object)template);
    }

    @Test
    public void generatedConfigFileExists_alwaysOverwritten() throws IOException {
        File generatedConfigFile = new File(this.temporaryFolder.getRoot(), "vite.generated.ts");
        String importString = "Hello Fake generated configuration";
        FileUtils.write((File)generatedConfigFile, (CharSequence)"Hello Fake generated configuration", (Charset)StandardCharsets.UTF_8);
        new TaskUpdateVite(this.options, null).execute();
        String template = IOUtils.toString((URI)generatedConfigFile.toURI(), (Charset)StandardCharsets.UTF_8);
        Assert.assertNotEquals((String)"Generated file should have been overwritten", (Object)"Hello Fake generated configuration", (Object)template);
    }

    @Test
    public void usedSettings_matchThoseCreatedToSettingsFile() throws IOException {
        TaskUpdateVite task = new TaskUpdateVite(this.options, null);
        task.execute();
        File generatedConfigFile = new File(this.temporaryFolder.getRoot(), "vite.generated.ts");
        String template = IOUtils.toString((URI)generatedConfigFile.toURI(), (Charset)StandardCharsets.UTF_8);
        this.options.withFrontendDirectory(this.temporaryFolder.newFolder("./src/main/frontend/")).withBuildDirectory("target").withJarFrontendResourcesFolder(this.temporaryFolder.newFolder("resources"));
        TaskUpdateSettingsFile updateSettings = new TaskUpdateSettingsFile(this.options, "theme", new PwaConfiguration());
        updateSettings.execute();
        File settings = new File(this.temporaryFolder.getRoot(), "target/vaadin-dev-server-settings.json");
        ObjectNode settingsJson = JacksonUtils.readTree((String)IOUtils.toString((URI)settings.toURI(), (Charset)StandardCharsets.UTF_8));
        Matcher matcher = Pattern.compile("settings\\.(?!json)([a-zA-z][a-zA-z0-9]*)").matcher(template);
        StringBuilder faulty = new StringBuilder();
        while (matcher.find()) {
            if (settingsJson.has(matcher.group(1))) continue;
            faulty.append(matcher.group(1)).append('\n');
        }
        Assert.assertTrue((String)("Configuration uses settings keys\n" + String.valueOf(faulty) + "that are not generated in settings file."), (boolean)faulty.toString().isEmpty());
    }

    @Test
    public void generatedTemplate_reactAndHillaUsed_correctFileRouterImport() throws IOException {
        TaskUpdateVite task = new TaskUpdateVite(this.options.withReact(true), null);
        try (MockedStatic util = Mockito.mockStatic(FrontendBuildUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            util.when(() -> FrontendBuildUtils.isHillaUsed((File)((File)Mockito.any()), (ClassFinder)((ClassFinder)Mockito.any()))).thenReturn((Object)true);
            task.execute();
        }
        File configFile = new File(this.temporaryFolder.getRoot(), "vite.generated.ts");
        String template = IOUtils.toString((URI)configFile.toURI(), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((String)"vitePluginFileSystemRouter should be imported.", (boolean)template.contains("import vitePluginFileSystemRouter from '@vaadin/hilla-file-router/vite-plugin.js';"));
        Assert.assertTrue((String)"vitePluginFileSystemRouter({isDevMode: devMode}) should be used.", (boolean)template.contains("vitePluginFileSystemRouter({isDevMode: devMode}),"));
    }

    @Test
    public void generatedTemplate_reactDisabled_correctFileRouterImport() throws IOException {
        TaskUpdateVite task = new TaskUpdateVite(this.options.withReact(false), null);
        task.execute();
        File configFile = new File(this.temporaryFolder.getRoot(), "vite.generated.ts");
        String template = IOUtils.toString((URI)configFile.toURI(), (Charset)StandardCharsets.UTF_8);
        Assert.assertFalse((String)"vitePluginFileSystemRouter should not be imported.", (boolean)template.contains("import vitePluginFileSystemRouter from '@vaadin/hilla-file-router/vite-plugin.js';"));
        Assert.assertFalse((String)"vitePluginFileSystemRouter() should be used.", (boolean)template.contains("vitePluginFileSystemRouter(),"));
    }

    @Test
    public void generatedTemplate_extraFrontendExtension_addedToViteConfiguration() throws IOException {
        this.options.withFrontendExtraFileExtensions(Arrays.asList(".svg", ".ico", "png"));
        TaskUpdateVite task = new TaskUpdateVite(this.options, null);
        task.execute();
        File configFile = new File(this.temporaryFolder.getRoot(), "vite.generated.ts");
        String template = IOUtils.toString((URI)configFile.toURI(), (Charset)StandardCharsets.UTF_8);
        Pattern matchSelection = Pattern.compile("const projectFileExtensions = \\[(.*)];");
        Matcher matcher = matchSelection.matcher(template);
        Assert.assertTrue((String)"No projectFileExtensions found", (boolean)matcher.find());
        Assert.assertEquals((String)"Extra frontend extensions should be added to vite configuration, but was not.", (Object)"'.js', '.js.map', '.ts', '.ts.map', '.tsx', '.tsx.map', '.css', '.css.map', '.svg', '.ico', '.png'", (Object)matcher.group(1));
    }

    @Test
    public void generatedTemplate_noEraFrontendExtension_viteConfigurationWithoutExtraSelections() throws IOException {
        TaskUpdateVite task = new TaskUpdateVite(this.options, null);
        task.execute();
        File configFile = new File(this.temporaryFolder.getRoot(), "vite.generated.ts");
        String template = IOUtils.toString((URI)configFile.toURI(), (Charset)StandardCharsets.UTF_8);
        Pattern matchSelection = Pattern.compile("const projectFileExtensions = \\[(.*)];");
        Matcher matcher = matchSelection.matcher(template);
        Assert.assertTrue((String)"No projectFileExtensions found", (boolean)matcher.find());
        Assert.assertEquals((String)"Extra frontend extensions should be added to vite configuration, but was not.", (Object)"'.js', '.js.map', '.ts', '.ts.map', '.tsx', '.tsx.map', '.css', '.css.map'", (Object)matcher.group(1));
    }
}

