/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.MockLogger;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.testcategory.SlowTests;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
@Category(value={SlowTests.class})
public class TaskRunNpmInstallTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private NodeUpdater nodeUpdater;
    private TaskRunNpmInstall task;
    protected File npmFolder;
    protected ClassFinder finder;
    protected Logger logger = (Logger)Mockito.spy((Object)LoggerFactory.getLogger(NodeUpdater.class));
    @Rule
    public ExpectedException exception = ExpectedException.none();
    protected Options options;

    @Before
    public void setUp() throws IOException, NoSuchFieldException {
        this.npmFolder = this.temporaryFolder.newFolder();
        this.options = new MockOptions(this.npmFolder).withBuildDirectory("target").withBundleBuild(true);
        this.finder = this.options.getClassFinder();
        this.nodeUpdater = new NodeUpdater((FrontendDependenciesScanner)Mockito.mock(FrontendDependencies.class), this.options){

            public void execute() {
            }

            Logger log() {
                return TaskRunNpmInstallTest.this.logger;
            }
        };
        this.task = this.createTask(new ArrayList<String>());
        ReflectTools.setJavaFieldValue((Object)new FrontendTools(new FrontendToolsSettings(this.npmFolder.getAbsolutePath(), (SerializableSupplier & Serializable)() -> this.npmFolder.getAbsolutePath())), (Field)FrontendTools.class.getDeclaredField("activeNodeInstallation"), null);
    }

    protected TaskRunNpmInstall createTask(List<String> additionalPostInstall) {
        this.options.withPostinstallPackages(additionalPostInstall);
        this.options.withNodeVersion("v24.12.0").withNodeDownloadRoot(URI.create("https://nodejs.org/dist/"));
        return new TaskRunNpmInstall(this.getNodeUpdater(), this.options);
    }

    @Test
    public void runNpmInstall_emptyDir_npmInstallIsExecuted() throws ExecutionFailedException, IOException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.getNodeUpdater().modified = false;
        this.ensurePackageJson();
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    @Test
    public void runNpmInstallAndCi_emptyDir_npmInstallAndCiIsExecuted() throws ExecutionFailedException, IOException {
        this.assumeNPMIsInUse();
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.getNodeUpdater().modified = false;
        this.ensurePackageJson();
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
        this.deleteDirectory(nodeModules);
        this.options.withCiBuild(true);
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    @Test
    public void runNpmCi_emptyDir_npmCiFails() throws IOException {
        this.assumeNPMIsInUse();
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.getNodeUpdater().modified = false;
        this.ensurePackageJson();
        this.options.withCiBuild(true);
        Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskRunNpmInstall)this.task).execute());
    }

    @Test
    public void runNpmInstall_nodeModulesContainsStaging_npmInstallIsExecuted() throws ExecutionFailedException, IOException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        File staging = new File(nodeModules, ".staging");
        staging.mkdir();
        this.getNodeUpdater().modified = false;
        this.ensurePackageJson();
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    @Test
    public void runNpmInstall_toolIsChanged_nodeModulesIsRemoved() throws ExecutionFailedException, IOException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.ensurePackageJson();
        this.getNodeUpdater().modified = true;
        File yaml = new File(nodeModules, ".modules.yaml");
        yaml.createNewFile();
        this.task.execute();
        Assert.assertFalse((boolean)yaml.exists());
    }

    @Test
    public void runNpmInstall_toolIsNotChanged_nodeModulesIsNotRemoved() throws ExecutionFailedException, IOException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.getNodeUpdater().modified = true;
        File fakeFile = new File(nodeModules, ".fake.file");
        fakeFile.createNewFile();
        this.ensurePackageJson();
        this.task.execute();
        Assert.assertTrue((boolean)fakeFile.exists());
    }

    @Test
    public void runNpmInstall_nonEmptyDirNoLocalHash_npmInstallIsExecuted() throws IOException, ExecutionFailedException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        new File(nodeModules, "foo").createNewFile();
        this.getNodeUpdater().modified = false;
        this.ensurePackageJson();
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    @Test
    public void runNpmInstall_nonEmptyDirNoHashMatch_npmInstallIsExecuted() throws IOException, ExecutionFailedException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        new File(nodeModules, "foo").createNewFile();
        this.writeLocalHash("faulty");
        this.getNodeUpdater().modified = false;
        this.ensurePackageJson();
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    @Test
    public void runNpmInstall_matchingHash_npmInstallIsNotExecuted() throws IOException, ExecutionFailedException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        new File(nodeModules, "foo").createNewFile();
        this.writeLocalHash("");
        this.getNodeUpdater().modified = false;
        this.task.execute();
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((Logger)Mockito.verify((Object)this.logger)).info((String)captor.capture(), new Object[]{Mockito.matches((String)this.getToolName()), Mockito.matches((String)this.getCommand()), Mockito.matches((String)nodeModules.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\")), Mockito.any(), Mockito.matches((String)"package.json")});
        Assert.assertEquals((Object)"Skipping `{} {}` because the frontend packages are already installed in the folder '{}' and the hash in the file '{}' is the same as in '{}'", (Object)captor.getValue());
    }

    @Test
    public void runNpmInstall_matchingHashButEmptyModules_npmInstallIsExecuted() throws IOException, ExecutionFailedException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.writeLocalHash("");
        this.getNodeUpdater().modified = false;
        this.ensurePackageJson();
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    public void writeLocalHash(String hash) throws IOException {
        ObjectNode localHash = JacksonUtils.createObjectNode();
        localHash.put("hash", hash);
        File localHashFile = new File(this.options.getNodeModulesFolder(), ".vaadin/vaadin.json");
        FileUtils.forceMkdirParent((File)localHashFile);
        this.getNodeUpdater().writePackageFile((JsonNode)localHash, localHashFile);
    }

    @Test
    public void runNpmInstall_modified_npmInstallIsExecuted() throws ExecutionFailedException, IOException {
        this.getNodeUpdater().modified = true;
        this.ensurePackageJson();
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    @Test
    public void runNpmInstall_vaadinHomeNodeIsAFolder_nodeIsReinstalled() throws IOException, ExecutionFailedException {
        this.options.withHomeNodeExecRequired(true).withNodeVersion("v24.12.0").withNodeDownloadRoot(URI.create("https://nodejs.org/dist/"));
        this.assertRunNpmInstallInstallsNewNode_whenVaadinHomeNodeIsAFolder(new TaskRunNpmInstall(this.getNodeUpdater(), this.options));
    }

    @Test
    public void runNpmInstall_externalUpdateOfPackages_npmInstallIsRerun() throws ExecutionFailedException, IOException {
        this.getNodeUpdater().modified = true;
        ObjectNode packageJson = this.getNodeUpdater().getPackageJson();
        this.updatePackageHash(packageJson);
        this.getNodeUpdater().writePackageFile((JsonNode)packageJson);
        this.task.execute();
        File localHashFile = new File(this.options.getNodeModulesFolder(), ".vaadin/vaadin.json");
        Assert.assertTrue((String)"Local has file was not created after install.", (boolean)localHashFile.exists());
        String fileContent = FileUtils.readFileToString((File)localHashFile, (String)StandardCharsets.UTF_8.name());
        ObjectNode localHash = JacksonUtils.readTree((String)fileContent);
        Assert.assertNotEquals((String)"We should have a non empty hash key", (Object)"", (Object)localHash.get("hash").asString());
        packageJson = this.getNodeUpdater().getPackageJson();
        ((ObjectNode)packageJson.get("vaadin").get("dependencies")).put("a-avataaar", "^1.2.5");
        String hash = packageJson.get("vaadin").get("hash").asString();
        this.updatePackageHash(packageJson);
        Assert.assertNotEquals((String)"Hash should have been updated", (Object)hash, (Object)packageJson.get("vaadin").get("hash").asString());
        this.getNodeUpdater().writePackageFile((JsonNode)packageJson);
        this.logger = (Logger)Mockito.mock(Logger.class);
        this.task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    protected void setupEsbuildAndFooInstallation() throws IOException {
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.getNodeUpdater().modified = false;
        File esbuildPackageJson = new File(new File(nodeModules.getParentFile(), "fake-esbuild"), "package.json");
        String esbuildPackageJsonContents = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fake-package-with-postinstall.json"), (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)esbuildPackageJson, (CharSequence)esbuildPackageJsonContents, (Charset)StandardCharsets.UTF_8);
        File fooPackageJson = new File(new File(nodeModules.getParentFile(), "fake-foo"), "package.json");
        String fooPackageJsonContents = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fake-package-with-postinstall.json"), (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)fooPackageJson, (CharSequence)fooPackageJsonContents, (Charset)StandardCharsets.UTF_8);
        File packageJsonFile = this.ensurePackageJson();
        ObjectNode packageJson = this.getNodeUpdater().getPackageJson();
        ((ObjectNode)packageJson.get("devDependencies")).put("esbuild", "./fake-esbuild");
        ((ObjectNode)packageJson.get("devDependencies")).put("foo", "./fake-foo");
        FileUtils.write((File)packageJsonFile, (CharSequence)packageJson.toString(), (Charset)StandardCharsets.UTF_8);
    }

    @Test
    public void runNpmInstall_noPostinstallScript_postIntstallNotExecuted() throws IOException, ExecutionFailedException {
        this.setupEsbuildAndFooInstallation();
        File esbuildPackageJson = new File(new File(this.options.getNodeModulesFolder().getParentFile(), "fake-esbuild"), "package.json");
        ObjectNode esbuildPackageJsonContents = JacksonUtils.readTree((String)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fake-package-with-postinstall.json"), (Charset)StandardCharsets.UTF_8));
        ((ObjectNode)esbuildPackageJsonContents.get("scripts")).remove("postinstall");
        FileUtils.write((File)esbuildPackageJson, (CharSequence)esbuildPackageJsonContents.toString(), (Charset)StandardCharsets.UTF_8);
        this.logger = new MockLogger();
        Assert.assertTrue((boolean)this.logger.isDebugEnabled());
        this.task.execute();
        Assert.assertFalse((String)"esbuild without postinstall should not have been executed", (boolean)((MockLogger)this.logger).getLogs().contains("Running postinstall for 'esbuild'"));
    }

    @Test
    public void runNpmInstall_postInstall_runOnlyForDefaultPackages() throws ExecutionFailedException, IOException {
        this.setupEsbuildAndFooInstallation();
        this.task.execute();
        Assert.assertTrue((String)"Postinstall for 'esbuild' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "esbuild"), "postinstall-file.txt").exists());
        Assert.assertFalse((String)"Postinstall for 'foo' should not have been run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "foo"), "postinstall-file.txt").exists());
    }

    @Test
    public void runNpmInstall_postInstall_runForDefinedAdditionalPackages() throws ExecutionFailedException, IOException {
        this.setupEsbuildAndFooInstallation();
        this.task = this.createTask(Collections.singletonList("foo"));
        this.task.execute();
        Assert.assertTrue((String)"Postinstall for 'esbuild' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "esbuild"), "postinstall-file.txt").exists());
        Assert.assertTrue((String)"Postinstall for 'foo' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "foo"), "postinstall-file.txt").exists());
    }

    @Test(timeout=30000L)
    public void runNpmInstall_postInstallWritingLotsOfOutput_processDoesNotStuck() throws ExecutionFailedException, IOException {
        this.setupEsbuildAndFooInstallation();
        File nodeModules = this.options.getNodeModulesFolder();
        File fooPackageJson = new File(new File(nodeModules.getParentFile(), "fake-foo"), "package.json");
        String fooPackageJsonContents = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fake-package-with-postinstall-writing-to-console.json"), (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)fooPackageJson, (CharSequence)fooPackageJsonContents, (Charset)StandardCharsets.UTF_8);
        this.task = this.createTask(Collections.singletonList("foo"));
        this.task.execute();
        Assert.assertTrue((String)"Postinstall for 'foo' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "foo"), "postinstall-console-file.txt").exists());
    }

    @Test
    public void shouldRunNpmInstallWhenFolderChanges() throws Exception {
        this.setupEsbuildAndFooInstallation();
        String packageJsonHash = this.getNodeUpdater().getPackageJson().get("vaadin").get("hash").asString();
        ObjectNode vaadinJson = JacksonUtils.createObjectNode();
        vaadinJson.put("hash", packageJsonHash);
        vaadinJson.put("projectFolder", this.npmFolder.getAbsolutePath());
        File vaadinJsonFile = this.getNodeUpdater().getVaadinJsonFile();
        FileUtils.writeStringToFile((File)vaadinJsonFile, (String)vaadinJson.toString(), (Charset)StandardCharsets.UTF_8);
        Assert.assertFalse((boolean)this.task.isVaadinHashOrProjectFolderUpdated());
        vaadinJson.put("projectFolder", this.npmFolder.getAbsolutePath() + "foo");
        FileUtils.writeStringToFile((File)vaadinJsonFile, (String)vaadinJson.toString(), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)this.task.isVaadinHashOrProjectFolderUpdated());
    }

    public void updatePackageHash(ObjectNode packageJson) {
        ObjectNode vaadinDep = (ObjectNode)packageJson.get("vaadin").get("dependencies");
        ObjectNode dependencies = JacksonUtils.createObjectNode();
        for (String key : JacksonUtils.getKeys((JsonNode)vaadinDep)) {
            dependencies.put(key, vaadinDep.get(key).asString());
        }
        ObjectNode vaadinDevDep = (ObjectNode)packageJson.get("vaadin").get("devDependencies");
        ObjectNode devDependencies = JacksonUtils.createObjectNode();
        for (String key : JacksonUtils.getKeys((JsonNode)vaadinDevDep)) {
            devDependencies.put(key, vaadinDevDep.get(key).asString());
        }
        packageJson.set("dependencies", (JsonNode)dependencies);
        packageJson.set("devDependencies", (JsonNode)devDependencies);
        ((ObjectNode)packageJson.get("vaadin")).put("hash", TaskUpdatePackages.generatePackageJsonHash((JsonNode)packageJson));
        packageJson.remove("dependencies");
        packageJson.remove("devDependencies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertRunNpmInstallInstallsNewNode_whenVaadinHomeNodeIsAFolder(TaskRunNpmInstall task) throws IOException, ExecutionFailedException {
        String userHome = "user.home";
        String originalHome = System.getProperty(userHome);
        File home = this.temporaryFolder.newFolder();
        System.setProperty(userHome, home.getPath());
        try {
            File homeDir = new File(home, ".vaadin");
            File node = new File(homeDir, FrontendUtils.isWindows() ? "node-v24.12.0/node.exe" : "node-v24.12.0/bin/node");
            FileUtils.forceMkdir((File)node);
            Assert.assertTrue((String)"node executable should be a directory", (boolean)node.isDirectory());
            task.execute();
            Assert.assertFalse((String)"node executable should have been reinstalled", (boolean)node.isDirectory());
            Assert.assertTrue((String)"node executable should be executable", (boolean)node.canExecute());
        }
        finally {
            System.setProperty(userHome, originalHome);
        }
    }

    protected String getRunningMsg() {
        return "Running `" + this.getToolName() + " " + this.getCommand() + "` to resolve and optionally download frontend dependencies. This may take a moment, please stand by...";
    }

    private String getCommand() {
        Object command = "install";
        if (this.options.isCiBuild()) {
            command = "pnpm".equals(this.getToolName()) ? (String)command + " --frozen-lockfile" : "ci";
        }
        return command;
    }

    protected NodeUpdater getNodeUpdater() {
        return this.nodeUpdater;
    }

    protected ClassFinder getClassFinder() {
        return this.finder;
    }

    protected String getToolName() {
        return "npm";
    }

    private File ensurePackageJson() throws IOException {
        File file = new File(this.npmFolder, "package.json");
        if (!file.exists()) {
            ObjectNode packageJson = this.getNodeUpdater().getPackageJson();
            this.getNodeUpdater().writePackageFile((JsonNode)packageJson);
        }
        return file;
    }

    void deleteDirectory(File dir) throws IOException {
        Files.walk(dir.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    @Test
    public void verifyPackageLockAndClean_lockfileVersion3_fileNotRemoved() throws IOException {
        this.assumeNPMIsInUse();
        File packageLockFile = new File(this.npmFolder, "package-lock.json");
        String packageLockContent = "{\n  \"name\": \"test-project\",\n  \"version\": \"1.0.0\",\n  \"lockfileVersion\": 3,\n  \"requires\": true,\n  \"packages\": {}\n}\n";
        FileUtils.write((File)packageLockFile, (CharSequence)packageLockContent, (Charset)StandardCharsets.UTF_8);
        this.task.verifyPackageLockAndClean();
        Assert.assertTrue((String)"package-lock.json with version 3 should not be removed", (boolean)packageLockFile.exists());
    }

    @Test
    public void verifyPackageLockAndClean_lockfileVersion2_fileRemoved() throws IOException {
        this.assumeNPMIsInUse();
        File packageLockFile = new File(this.npmFolder, "package-lock.json");
        String packageLockContent = "{\n  \"name\": \"test-project\",\n  \"version\": \"1.0.0\",\n  \"lockfileVersion\": 2,\n  \"requires\": true,\n  \"packages\": {}\n}\n";
        FileUtils.write((File)packageLockFile, (CharSequence)packageLockContent, (Charset)StandardCharsets.UTF_8);
        this.task.verifyPackageLockAndClean();
        Assert.assertFalse((String)"package-lock.json with version 2 should be removed", (boolean)packageLockFile.exists());
    }

    @Test
    public void verifyPackageLockAndClean_lockfileVersion1_fileRemoved() throws IOException {
        this.assumeNPMIsInUse();
        File packageLockFile = new File(this.npmFolder, "package-lock.json");
        String packageLockContent = "{\n  \"name\": \"test-project\",\n  \"version\": \"1.0.0\",\n  \"lockfileVersion\": 1,\n  \"requires\": true,\n  \"dependencies\": {}\n}\n";
        FileUtils.write((File)packageLockFile, (CharSequence)packageLockContent, (Charset)StandardCharsets.UTF_8);
        this.task.verifyPackageLockAndClean();
        Assert.assertFalse((String)"package-lock.json with version 1 should be removed", (boolean)packageLockFile.exists());
    }

    @Test
    public void verifyPackageLockAndClean_withSpaces_correctlyParsed() throws IOException {
        File packageLockFile = new File(this.npmFolder, "package-lock.json");
        String packageLockContent = "{\n  \"name\": \"test-project\",\n  \"version\": \"1.0.0\",\n  \"lockfileVersion\"  :  3,\n  \"requires\": true,\n  \"packages\": {}\n}\n";
        FileUtils.write((File)packageLockFile, (CharSequence)packageLockContent, (Charset)StandardCharsets.UTF_8);
        this.task.verifyPackageLockAndClean();
        Assert.assertTrue((String)"package-lock.json with version 3 (with spaces) should not be removed", (boolean)packageLockFile.exists());
    }

    @Test
    public void verifyPackageLockAndClean_pnpmEnabled_fileNotChecked() throws IOException {
        this.options.withEnablePnpm(true);
        this.task = this.createTask(new ArrayList<String>());
        File packageLockFile = new File(this.npmFolder, "package-lock.json");
        String packageLockContent = "{\n  \"name\": \"test-project\",\n  \"version\": \"1.0.0\",\n  \"lockfileVersion\": 2,\n  \"requires\": true,\n  \"packages\": {}\n}\n";
        FileUtils.write((File)packageLockFile, (CharSequence)packageLockContent, (Charset)StandardCharsets.UTF_8);
        this.task.verifyPackageLockAndClean();
        Assert.assertTrue((String)"package-lock.json should not be checked when pnpm is enabled", (boolean)packageLockFile.exists());
    }

    @Test
    public void verifyPackageLockAndClean_noLockfile_doesNotThrow() {
        File packageLockFile = new File(this.npmFolder, "package-lock.json");
        Assert.assertFalse((String)"package-lock.json should not exist", (boolean)packageLockFile.exists());
        this.task.verifyPackageLockAndClean();
        Assert.assertFalse((String)"package-lock.json should still not exist", (boolean)packageLockFile.exists());
    }

    private void assumeNPMIsInUse() {
        Assume.assumeTrue((boolean)this.getClass().equals(TaskRunNpmInstallTest.class));
    }
}

