/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.FrontendPluginsUtil;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskInstallFrontendBuildPlugins;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class TaskInstallFrontendBuildPluginsTest {
    public static final String BUILD_DIRECTORY = "target";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File rootFolder;
    private TaskInstallFrontendBuildPlugins task;

    @Before
    public void init() throws IOException {
        this.rootFolder = this.temporaryFolder.newFolder();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.rootFolder).withBuildDirectory(BUILD_DIRECTORY);
        this.task = new TaskInstallFrontendBuildPlugins(options);
    }

    @Test
    public void getPluginsReturnsExpectedList() {
        String[] expectedPlugins = new String[]{"application-theme-plugin", "theme-loader", "theme-live-reload-plugin", "rollup-plugin-postcss-lit-custom", "react-function-location-plugin", "rollup-plugin-vaadin-i18n", "vite-plugin-service-worker"};
        List plugins = FrontendPluginsUtil.getPlugins();
        Assert.assertEquals((String)"Unexpected number of plugins in 'plugins.json'", (long)expectedPlugins.length, (long)plugins.size());
        for (String plugin : expectedPlugins) {
            Assert.assertTrue((String)("'plugins.json' didn't contain '" + plugin + "'"), (boolean)plugins.contains(plugin));
        }
    }

    @Test
    public void webpackPluginsAreCopied() throws IOException {
        this.task.execute();
        this.assertPlugins();
    }

    @Test
    public void pluginsDefineAllScriptFiles() throws IOException {
        for (String plugin : FrontendPluginsUtil.getPlugins()) {
            this.verifyPluginScriptFilesAreDefined(plugin);
        }
    }

    @Test
    public void pluginsNotAddedToPackageJson() throws IOException {
        Options options = new MockOptions(this.rootFolder).withBuildDirectory(BUILD_DIRECTORY);
        NodeUpdater nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)Mockito.mock(FrontendDependencies.class), options){

            public void execute() {
            }
        };
        this.task.execute();
        ObjectNode packageJson = nodeUpdater.getPackageJson();
        JsonNode devDependencies = packageJson.get("devDependencies");
        for (String plugin : FrontendPluginsUtil.getPlugins()) {
            Assert.assertFalse((String)("Plugin " + plugin + " added to packageJson"), (boolean)devDependencies.has("@vaadin/" + plugin));
        }
    }

    private void assertPlugins() throws IOException {
        Assert.assertTrue((String)"No @vaadin folder created", (boolean)Paths.get(this.rootFolder.toString(), BUILD_DIRECTORY, "plugins").toFile().exists());
        for (String plugin : FrontendPluginsUtil.getPlugins()) {
            this.assertPlugin(plugin);
        }
    }

    private void assertPlugin(String plugin) throws IOException {
        File pluginFolder = this.getPluginFolder(plugin);
        ArrayNode files = this.getPluginFiles(pluginFolder);
        for (int i = 0; i < files.size(); ++i) {
            Assert.assertTrue((String)("Missing plugin file " + files.get(i).textValue() + " for " + plugin), (boolean)new File(pluginFolder, files.get(i).textValue()).exists());
        }
    }

    private void verifyPluginScriptFilesAreDefined(String plugin) throws IOException {
        File pluginFolder = new File(this.getClass().getClassLoader().getResource("plugins/" + plugin).getFile());
        ArrayNode files = this.getPluginFiles(pluginFolder);
        ArrayList<String> fileNames = new ArrayList<String>(files.size());
        for (int i = 0; i < files.size(); ++i) {
            Assert.assertTrue((String)("Missing plugin file " + files.get(i).textValue() + " for " + plugin), (boolean)new File(pluginFolder, files.get(i).textValue()).exists());
            fileNames.add(files.get(i).textValue());
        }
        List pluginFiles = Arrays.stream(pluginFolder.listFiles((dir, name) -> FilenameUtils.getExtension((String)name).equals("js"))).map(file -> file.getName()).collect(Collectors.toList());
        for (String fileName : pluginFiles) {
            Assert.assertTrue((String)String.format("Plugin '%s' doesn't define script file '%s' in package.json files", plugin, fileName), (boolean)fileNames.contains(fileName));
        }
    }

    private ArrayNode getPluginFiles(File pluginFolder) throws IOException {
        ObjectNode packageJson = JacksonUtils.readTree((String)FileUtils.readFileToString((File)new File(pluginFolder, "package.json"), (Charset)StandardCharsets.UTF_8));
        return (ArrayNode)packageJson.get("files");
    }

    private File getPluginFolder(String plugin) {
        String pluginString = Paths.get(BUILD_DIRECTORY, "plugins", plugin).toString();
        File pluginFolder = new File(this.rootFolder, pluginString);
        Assert.assertTrue((String)("Missing plugin folder for " + plugin), (boolean)pluginFolder.exists());
        Assert.assertTrue((String)("Missing package.json for " + plugin), (boolean)new File(pluginFolder, "package.json").exists());
        return pluginFolder;
    }
}

