/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentHtml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateWebComponentHtmlTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File frontendFolder;
    private TaskGenerateWebComponentHtml taskGenerateWebComponentHtml;

    @Before
    public void setup() throws IOException {
        this.frontendFolder = this.temporaryFolder.newFolder();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), null).withFrontendDirectory(this.frontendFolder);
        this.taskGenerateWebComponentHtml = new TaskGenerateWebComponentHtml(options);
    }

    @Test
    public void should_loadCorrectContentOfDefaultFile() throws Exception {
        String defaultContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("web-component.html"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Should load correct default content from web-component.html", (Object)defaultContent, (Object)this.taskGenerateWebComponentHtml.getFileContent());
    }

    @Test
    public void should_notOverwriteWebComponentHtml_webComponentHtmlExists() throws Exception {
        File webComponentHtml = new File(this.frontendFolder, "web-component.html");
        Files.createFile(webComponentHtml.toPath(), new FileAttribute[0]);
        this.taskGenerateWebComponentHtml.execute();
        Assert.assertFalse((String)"Should not generate web-component.html while it exists in the frontend folder", (boolean)this.taskGenerateWebComponentHtml.shouldGenerate());
        Assert.assertEquals((Object)"", (Object)IOUtils.toString((URI)webComponentHtml.toURI(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void should_generateWebComponentHtml_webComponentHtmlNotExist() throws Exception {
        String defaultContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("web-component.html"), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((String)"Should generate web-component.html when it doesn't exists in the frontend folder", (boolean)this.taskGenerateWebComponentHtml.shouldGenerate());
        this.taskGenerateWebComponentHtml.execute();
        Assert.assertTrue((String)"The generated file should exists", (boolean)this.taskGenerateWebComponentHtml.getGeneratedFile().exists());
        Assert.assertEquals((String)"Should have default content of web-component.html", (Object)defaultContent, (Object)IOUtils.toString((URI)this.taskGenerateWebComponentHtml.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8));
    }
}

