/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.MockLogger;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateTsDefinitions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@NotThreadSafe
public class TaskGenerateTsDefinitionsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File outputFolder;
    private TaskGenerateTsDefinitions taskGenerateTsDefinitions;

    @Before
    public void setUp() throws IOException {
        this.outputFolder = this.temporaryFolder.newFolder();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.outputFolder);
        this.taskGenerateTsDefinitions = new TaskGenerateTsDefinitions(options);
        TaskGenerateTsDefinitions.warningEmitted = false;
    }

    @Test
    public void should_generateTsDefinitions_TsDefinitionsNotExistAndTsConfigExists() throws Exception {
        Files.createFile(new File(this.outputFolder, "tsconfig.json").toPath(), new FileAttribute[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should generate types.d.ts when tsconfig.json exists and types.d.ts doesn't exist", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        Assert.assertTrue((String)"The generated types.d.ts should not exist", (boolean)this.taskGenerateTsDefinitions.getGeneratedFile().exists());
        Assert.assertEquals((String)"The generated content should be equals the default content", (Object)this.taskGenerateTsDefinitions.getFileContent(), (Object)IOUtils.toString((URI)this.taskGenerateTsDefinitions.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void should_notGenerateTsDefinitions_TsConfigNotExist() throws Exception {
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when tsconfig.json doesn't exist", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        Assert.assertFalse((String)"The types.d.ts should not exist", (boolean)this.taskGenerateTsDefinitions.getGeneratedFile().exists());
    }

    @Test
    public void tsDefinition_upToDate_tsDefinitionNotUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String expectedContent = this.readExpectedContent(false);
        Files.writeString(typesTSfile, (CharSequence)expectedContent, new OpenOption[0]);
        FileTime lastModifiedTime = Files.getLastModifiedTime(typesTSfile, new LinkOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        Assert.assertEquals((String)"types.d.ts should not have been updated", (Object)lastModifiedTime, (Object)Files.getLastModifiedTime(typesTSfile, new LinkOption[0]));
        Assert.assertEquals((String)"types.d.ts should have been replaced", (Object)updatedContent, (Object)expectedContent);
    }

    @Test
    public void tsDefinition_oldFlowContents_tsDefinitionUpdated() throws Exception {
        this.tsDefinition_oldFlowContents_tsDefinitionUpdated(".v1");
        this.tsDefinition_oldFlowContents_tsDefinitionUpdated(".v2");
    }

    private void tsDefinition_oldFlowContents_tsDefinitionUpdated(String suffix) throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        Files.writeString(typesTSfile, (CharSequence)this.readPreviousContent(suffix), new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        Assert.assertEquals((String)"types.d.ts should have been replaced", (Object)updatedContent, (Object)this.readExpectedContent(false));
    }

    @Test
    public void tsDefinition_oldFlowContents_missingLastEOL_tsDefinitionUpdated() throws Exception {
        this.tsDefinition_oldFlowContents_missingLastEOL_tsDefinitionUpdated(".v1");
        this.tsDefinition_oldFlowContents_missingLastEOL_tsDefinitionUpdated(".v2");
    }

    private void tsDefinition_oldFlowContents_missingLastEOL_tsDefinitionUpdated(String suffix) throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        Files.writeString(typesTSfile, (CharSequence)this.readPreviousContent(suffix).replaceFirst("\r?\n$", ""), new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        Assert.assertEquals((String)"types.d.ts should have been replaced", (Object)updatedContent, (Object)this.readExpectedContent(false));
    }

    @Test
    public void tsDefinition_oldHillaContents_tsDefinitionUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String hillaTsDef = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("types.d.ts.hilla.v1"), (Charset)StandardCharsets.UTF_8);
        Files.writeString(typesTSfile, (CharSequence)hillaTsDef, new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)this.readExpectedContent(true)));
        MatcherAssert.assertThat((String)"types.d.ts should contain original content", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)hillaTsDef));
    }

    @Test
    public void tsDefinition_oldHillaContents_ignoringMultilineComments_tsDefinitionUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String hillaTsDef = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("types.d.ts.hilla.v1"), (Charset)StandardCharsets.UTF_8);
        hillaTsDef = hillaTsDef.replaceAll("(?m)^(\\s*declare.*)$", "/* a comment */\n$1\n");
        Files.writeString(typesTSfile, (CharSequence)hillaTsDef, new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)this.readExpectedContent(true)));
        MatcherAssert.assertThat((String)"types.d.ts should contain original content", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)hillaTsDef));
    }

    @Test
    public void tsDefinition_oldHillaContents_ignoringSingleLineComments_tsDefinitionUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String hillaTsDef = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("types.d.ts.hilla.v1"), (Charset)StandardCharsets.UTF_8);
        hillaTsDef = hillaTsDef.replaceAll("(?m)^(\\s*declare.*)$", "// a comment\n$1\n");
        Files.writeString(typesTSfile, (CharSequence)hillaTsDef, new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)this.readExpectedContent(true)));
        MatcherAssert.assertThat((String)"types.d.ts should contain original content", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)hillaTsDef));
    }

    @Test
    public void tsDefinition_oldHillaV2Contents_tsDefinitionUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String hillaTsDef = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("types.d.ts.hilla.v2"), (Charset)StandardCharsets.UTF_8);
        Files.writeString(typesTSfile, (CharSequence)hillaTsDef, new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)this.stripEmptyLines(updatedContent), (Matcher)CoreMatchers.containsString((String)this.stripEmptyLines(this.readExpectedContent(true))));
        MatcherAssert.assertThat((String)"types.d.ts should contain original content", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)hillaTsDef));
    }

    @Test
    public void tsDefinition_oldHillaV2Contents_ignoringMultilineComments_tsDefinitionUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String hillaTsDef = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("types.d.ts.hilla.v2"), (Charset)StandardCharsets.UTF_8);
        hillaTsDef = hillaTsDef.replaceAll("(?m)^(\\s*declare.*)$", "/* a comment */\n$1");
        Files.writeString(typesTSfile, (CharSequence)hillaTsDef, new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)this.stripEmptyLines(updatedContent), (Matcher)CoreMatchers.containsString((String)this.stripEmptyLines(this.readExpectedContent(true))));
        MatcherAssert.assertThat((String)"types.d.ts should contain original content", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)hillaTsDef));
    }

    @Test
    public void tsDefinition_oldHillaV2Contents_ignoringSingleLineComments_tsDefinitionUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String hillaTsDef = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("types.d.ts.hilla.v2"), (Charset)StandardCharsets.UTF_8);
        hillaTsDef = hillaTsDef.replaceAll("(?m)^(\\s*declare.*)$", "// a comment\n$1");
        Files.writeString(typesTSfile, (CharSequence)hillaTsDef, new OpenOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)this.stripEmptyLines(updatedContent), (Matcher)CoreMatchers.containsString((String)this.stripEmptyLines(this.readExpectedContent(true))));
        MatcherAssert.assertThat((String)"types.d.ts should contain original content", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)hillaTsDef));
    }

    @Test
    public void customTsDefinition_missingFlowContents_tsDefinitionUpdatedAndWarningLogged() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String originalContent = "import type { SchemaObject } from \"../../types\";\nexport type SchemaObjectMap = {\n    [Ref in string]?: SchemaObject;\n};\nexport declare const jtdForms: readonly [\"elements\", \"values\", \"discriminator\", \"properties\", \"optionalProperties\", \"enum\", \"type\", \"ref\"];\nexport type JTDForm = typeof jtdForms[number];\n";
        Files.writeString(typesTSfile, (CharSequence)originalContent, new OpenOption[0]);
        MockLogger logger = new MockLogger();
        try (MockedStatic client = Mockito.mockStatic(AbstractTaskClientGenerator.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            client.when(() -> AbstractTaskClientGenerator.log()).thenReturn((Object)logger);
            this.taskGenerateTsDefinitions.execute();
        }
        Assert.assertTrue((boolean)logger.getLogs().contains("\n***************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been updated     *\n*  to the latest version by Vaadin. Previous content has been backed up   *\n*  as a '.bak' file. Please verify that the updated 'types.d.ts' file    *\n*  contains configuration needed for your project, and then delete the    *\n*  backup file.                                                           *\n***************************************************************************\n\n"));
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = Files.readString(typesTSfile);
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)this.readExpectedContent(true)));
        this.assertBackupFileCreated(originalContent);
    }

    @Test
    public void customTsDefinition_v1FlowContents_tsDefinitionUpdatedAndWarningLogged() throws Exception {
        this.customTsDefinition_oldFlowContents_tsDefinitionUpdatedAndWarningLogged(".v1");
    }

    @Test
    public void customTsDefinition_v2FlowContents_tsDefinitionUpdatedAndWarningLogged() throws Exception {
        this.customTsDefinition_oldFlowContents_tsDefinitionUpdatedAndWarningLogged(".v2");
    }

    private void customTsDefinition_oldFlowContents_tsDefinitionUpdatedAndWarningLogged(String suffix) throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String originalContent = "import type { SchemaObject } from \"../../types\";" + System.lineSeparator() + this.readPreviousContent(suffix);
        Files.writeString(typesTSfile, (CharSequence)originalContent, new OpenOption[0]);
        MockLogger logger = new MockLogger();
        try (MockedStatic client = Mockito.mockStatic(AbstractTaskClientGenerator.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            client.when(() -> AbstractTaskClientGenerator.log()).thenReturn((Object)logger);
            this.taskGenerateTsDefinitions.execute();
        }
        Assert.assertTrue((boolean)logger.getLogs().contains("\n***************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been updated     *\n*  to the latest version by Vaadin. Previous content has been backed up   *\n*  as a '.bak' file. Please verify that the updated 'types.d.ts' file    *\n*  contains configuration needed for your project, and then delete the    *\n*  backup file.                                                           *\n***************************************************************************\n\n"));
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        String updatedContent = this.stripEmptyLines(Files.readString(typesTSfile));
        MatcherAssert.assertThat((String)"types.d.ts should have been updated", (Object)updatedContent, (Matcher)CoreMatchers.containsString((String)this.stripEmptyLines(this.readExpectedContent(true))));
        this.assertBackupFileCreated(originalContent);
    }

    @Test
    public void contentUpdateForSecondTime_tsDefinitionUpdatedAndWarningLoggedOnce() throws Exception {
        this.contentUpdateForSecondTime_tsDefinitionUpdatedAndWarningLoggedOnce(".v1");
        TaskGenerateTsDefinitions.warningEmitted = false;
        this.contentUpdateForSecondTime_tsDefinitionUpdatedAndWarningLoggedOnce(".v2");
    }

    private void contentUpdateForSecondTime_tsDefinitionUpdatedAndWarningLoggedOnce(String suffix) throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        String originalContent = "import type { SchemaObject } from \"../../types\";" + System.lineSeparator() + this.readPreviousContent(suffix);
        Files.writeString(typesTSfile, (CharSequence)originalContent, new OpenOption[0]);
        MockLogger logger = new MockLogger();
        try (MockedStatic client = Mockito.mockStatic(AbstractTaskClientGenerator.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            client.when(() -> AbstractTaskClientGenerator.log()).thenReturn((Object)logger);
            this.taskGenerateTsDefinitions.execute();
            Assert.assertTrue((boolean)logger.getLogs().contains("\n***************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been updated     *\n*  to the latest version by Vaadin. Previous content has been backed up   *\n*  as a '.bak' file. Please verify that the updated 'types.d.ts' file    *\n*  contains configuration needed for your project, and then delete the    *\n*  backup file.                                                           *\n***************************************************************************\n\n"));
            logger.clearLogs();
            Files.writeString(typesTSfile, (CharSequence)originalContent, new OpenOption[0]);
            this.taskGenerateTsDefinitions.execute();
        }
        Assert.assertFalse((boolean)logger.getLogs().contains("\n***************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been updated     *\n*  to the latest version by Vaadin. Previous content has been backed up   *\n*  as a '.bak' file. Please verify that the updated 'types.d.ts' file    *\n*  contains configuration needed for your project, and then delete the    *\n*  backup file.                                                           *\n***************************************************************************\n\n"));
    }

    @Test
    public void customTsDefinition_flowContents_tsDefinitionNotUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        Files.writeString(typesTSfile, (CharSequence)"import type { SchemaObject } from \"../../types\";\nexport type SchemaObjectMap = {\n    [Ref in string]?: SchemaObject;\n};\ndeclare module '*.css?inline' {\n  import type { CSSResultGroup } from 'lit';\n  const content: CSSResultGroup;\n  export default content;\n}\ndeclare module 'csstype' {\n  interface Properties {\n    [index: `--${string}`]: any;\n  }\n}\nexport declare const jtdForms: readonly [\"elements\", \"values\", \"discriminator\", \"properties\", \"optionalProperties\", \"enum\", \"type\", \"ref\"];\nexport type JTDForm = typeof jtdForms[number];\n}", new OpenOption[0]);
        FileTime lastModifiedTime = Files.getLastModifiedTime(typesTSfile, new LinkOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        Assert.assertEquals((String)"types.d.ts should not have been updated", (Object)lastModifiedTime, (Object)Files.getLastModifiedTime(typesTSfile, new LinkOption[0]));
    }

    @Test
    public void customTsDefinition_flowContentsDifferentWhiteSpace_tsDefinitionNotUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        Files.writeString(typesTSfile, (CharSequence)"import type { SchemaObject } from \"../../types\";\nexport type SchemaObjectMap = {\n    [Ref in string]?: SchemaObject;\n};\ndeclare module'*.css?inline'{\n  import type {CSSResultGroup} from 'lit';\n  const content: CSSResultGroup;\n  export default content;\n}\ndeclare module 'csstype' {\n  interface Properties {\n    [index:`--${string}`]: any;\n  }\n}\nexport declare const jtdForms: readonly [\"elements\", \"values\", \"discriminator\", \"properties\", \"optionalProperties\", \"enum\", \"type\", \"ref\"];\nexport type JTDForm = typeof jtdForms[number];\n}", new OpenOption[0]);
        FileTime lastModifiedTime = Files.getLastModifiedTime(typesTSfile, new LinkOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        Assert.assertEquals((String)"types.d.ts should not have been updated", (Object)lastModifiedTime, (Object)Files.getLastModifiedTime(typesTSfile, new LinkOption[0]));
    }

    @Test
    public void customTsDefinition_windowsEOL_flowContents_tsDefinitionNotUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        Files.writeString(typesTSfile, (CharSequence)"import type { SchemaObject } from \"../../types\";\nexport type SchemaObjectMap = {\n    [Ref in string]?: SchemaObject;\n};\ndeclare module '*.css?inline' {\n  import type { CSSResultGroup } from 'lit';\n  const content: CSSResultGroup;\n  export default content;\n}\ndeclare module 'csstype' {\n  interface Properties {\n    [index: `--${string}`]: any;\n  }\n}\nexport declare const jtdForms: readonly [\"elements\", \"values\", \"discriminator\", \"properties\", \"optionalProperties\", \"enum\", \"type\", \"ref\"];\nexport type JTDForm = typeof jtdForms[number];\n}".replace("\n", "\r\n"), new OpenOption[0]);
        FileTime lastModifiedTime = Files.getLastModifiedTime(typesTSfile, new LinkOption[0]);
        this.taskGenerateTsDefinitions.execute();
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        Assert.assertEquals((String)"types.d.ts should not have been updated", (Object)lastModifiedTime, (Object)Files.getLastModifiedTime(typesTSfile, new LinkOption[0]));
    }

    @Test
    public void customTsDefinition_flowContentsNotMatching_tsDefinitionNotUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        Files.writeString(typesTSfile, (CharSequence)"import type { SchemaObject } from \"../../types\";\nexport type SchemaObjectMap = {\n    [Ref in string]?: SchemaObject;\n};\ndeclare module '*.css?inline' {\n  something\n  import type { CSSResultGroup } from 'lit';\n  custom\n  const content: CSSResultGroup;\n  added\n  export default content;\n}\nexport declare const jtdForms: readonly [\"elements\", \"values\", \"discriminator\", \"properties\", \"optionalProperties\", \"enum\", \"type\", \"ref\"];\nexport type JTDForm = typeof jtdForms[number];\n}", new OpenOption[0]);
        FileTime lastModifiedTime = Files.getLastModifiedTime(typesTSfile, new LinkOption[0]);
        ExecutionFailedException exception = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskGenerateTsDefinitions)this.taskGenerateTsDefinitions).execute());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"\n****************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been customized.  *\n*  Make sure the exact following configuration is present in that file:    *\n*                                                                          *\n%s\n*                                                                          *\n*  As an alternative you can rename the file, make Vaadin re-generate it,  *\n*  and then update it with your custom contents.                           *\n****************************************************************************\"\n\n".substring(0, "\n****************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been customized.  *\n*  Make sure the exact following configuration is present in that file:    *\n*                                                                          *\n%s\n*                                                                          *\n*  As an alternative you can rename the file, make Vaadin re-generate it,  *\n*  and then update it with your custom contents.                           *\n****************************************************************************\"\n\n".indexOf("%s"))));
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        Assert.assertEquals((String)"types.d.ts should not have been updated", (Object)lastModifiedTime, (Object)Files.getLastModifiedTime(typesTSfile, new LinkOption[0]));
    }

    @Test
    public void customTsDefinition_differentCSSModuleDefinition_tsDefinitionNotUpdated() throws Exception {
        Path typesTSfile = new File(this.outputFolder, "types.d.ts").toPath();
        Files.writeString(typesTSfile, (CharSequence)"declare module '*.css?inline' {\n    custom configuration\n}", new OpenOption[0]);
        FileTime lastModifiedTime = Files.getLastModifiedTime(typesTSfile, new LinkOption[0]);
        ExecutionFailedException exception = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskGenerateTsDefinitions)this.taskGenerateTsDefinitions).execute());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"\n****************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been customized.  *\n*  Make sure the exact following configuration is present in that file:    *\n*                                                                          *\n%s\n*                                                                          *\n*  As an alternative you can rename the file, make Vaadin re-generate it,  *\n*  and then update it with your custom contents.                           *\n****************************************************************************\"\n\n".substring(0, "\n****************************************************************************\n*  The TypeScript type declaration file 'types.d.ts' has been customized.  *\n*  Make sure the exact following configuration is present in that file:    *\n*                                                                          *\n%s\n*                                                                          *\n*  As an alternative you can rename the file, make Vaadin re-generate it,  *\n*  and then update it with your custom contents.                           *\n****************************************************************************\"\n\n".indexOf("%s"))));
        Assert.assertFalse((String)"Should not generate types.d.ts when already existing", (boolean)this.taskGenerateTsDefinitions.shouldGenerate());
        Assert.assertEquals((String)"types.d.ts should not have been updated", (Object)lastModifiedTime, (Object)Files.getLastModifiedTime(typesTSfile, new LinkOption[0]));
    }

    private void assertBackupFileCreated(String originalContent) throws IOException {
        File[] backups = this.taskGenerateTsDefinitions.getGeneratedFile().getParentFile().listFiles(file -> file.getName().endsWith(".bak"));
        Assert.assertEquals((long)1L, (long)backups.length);
        File backupFile = backups[0];
        Assert.assertTrue((String)"Original types.d.ts backup should exist", (boolean)backupFile.exists());
        Assert.assertEquals((Object)originalContent, (Object)Files.readString(backupFile.toPath()));
    }

    private String readExpectedContent(boolean stripComments) throws IOException {
        String fileContent = this.taskGenerateTsDefinitions.getFileContent();
        if (stripComments) {
            fileContent = TaskGenerateTsDefinitions.COMMENT_LINE.matcher(fileContent).replaceAll("");
        }
        return fileContent;
    }

    private String readPreviousContent(String suffix) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream("types.d.ts" + suffix), (Charset)StandardCharsets.UTF_8);
    }

    private String stripEmptyLines(String input) {
        return input.replaceAll("(?m)^[ \t]*\r?\n", "");
    }
}

