/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateTailwindJs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateTailwindJsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File npmFolder;
    private File frontendGeneratedFolder;
    private TaskGenerateTailwindJs taskGenerateTailwindJs;

    @Before
    public void setUp() throws IOException {
        this.npmFolder = this.temporaryFolder.newFolder();
        this.frontendGeneratedFolder = new File(this.npmFolder, "src/frontend-generated");
        this.frontendGeneratedFolder.mkdirs();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.npmFolder).withFrontendGeneratedFolder(this.frontendGeneratedFolder);
        this.taskGenerateTailwindJs = new TaskGenerateTailwindJs(options);
    }

    @Test
    public void should_haveCorrectFileContent() throws Exception {
        this.verifyTailwindJs(this.taskGenerateTailwindJs.getFileContent());
    }

    @Test
    public void should_generateTailwindCss() throws Exception {
        File tailwindjs = new File(this.frontendGeneratedFolder, "tailwind.js");
        this.taskGenerateTailwindJs.execute();
        Assert.assertEquals((String)"Should have correct tailwind.js file path", (Object)tailwindjs, (Object)this.taskGenerateTailwindJs.getGeneratedFile());
        this.verifyTailwindJs(this.getTailwindCssFileContent());
        Assert.assertTrue((String)"Should generate tailwind.js in the frontend generated folder", (boolean)this.taskGenerateTailwindJs.shouldGenerate());
    }

    @Test
    public void should_updateExistingTailwindCss() throws Exception {
        File tailwindcss = new File(this.frontendGeneratedFolder, "tailwind.js");
        Files.writeString(tailwindcss.toPath(), (CharSequence)"OLD CONTENT", new OpenOption[0]);
        this.taskGenerateTailwindJs.execute();
        Assert.assertTrue((String)"Should generate tailwind.css in the frontend generated folder", (boolean)this.taskGenerateTailwindJs.shouldGenerate());
        String tailwindCssContent = this.getTailwindCssFileContent();
        Assert.assertEquals((String)"Should update content in tailwind.css", (Object)this.taskGenerateTailwindJs.getFileContent(), (Object)tailwindCssContent);
    }

    private void verifyTailwindJs(String tailwindJsContent) {
        Assert.assertTrue((String)"Should have tailwind.css import", (boolean)tailwindJsContent.contains("import tailwindCss from './tailwind.css?inline';\n"));
        Assert.assertTrue((String)"Should define applyTailwindCss function", (boolean)tailwindJsContent.contains("function applyTailwindCss(css)"));
        Assert.assertTrue((String)"Should apply Tailwind CSS", (boolean)tailwindJsContent.contains("applyTailwindCss(tailwindCss);\n"));
        Assert.assertTrue((String)"Should inject as global CSS", (boolean)tailwindJsContent.contains("injectGlobalCss(css.toString(), 'CSSImport end', document);\n"));
        Assert.assertTrue((String)"Should support hot module reload", (boolean)tailwindJsContent.contains("import.meta.hot.accept('./tailwind.css?inline',"));
    }

    private String getTailwindCssFileContent() throws IOException {
        return Files.readString(this.taskGenerateTailwindJs.getGeneratedFile().toPath());
    }
}

