/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateReactFiles;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateReactFilesTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    Options options;
    File routesTsx;
    File frontend;
    File frontendGenerated;
    ClassFinder classFinder;

    @Before
    public void setup() throws IOException {
        this.classFinder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.singleton(TestRoute.class));
        Mockito.when((Object)this.classFinder.getClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        this.options = new MockOptions(this.classFinder, this.temporaryFolder.getRoot()).withBuildDirectory("target");
        this.frontend = this.temporaryFolder.newFolder("./src/main/frontend/");
        this.options.withFrontendDirectory(this.frontend);
        this.frontendGenerated = this.temporaryFolder.newFolder("./src/main/frontend/generated/");
        this.options.withFrontendGeneratedFolder(this.frontendGenerated);
        this.routesTsx = new File(this.frontend, "routes.tsx");
    }

    @Test
    public void reactFilesAreWrittenToFrontend() throws ExecutionFailedException {
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(this.options);
        task.execute();
        Assert.assertTrue((String)"Missing ./frontend/generated/flow/Flow.tsx", (boolean)new File(new File(this.frontend, "generated/"), "flow/Flow.tsx").exists());
        Assert.assertTrue((String)"Missing ./frontend/generated/routes.tsx", (boolean)new File(new File(this.frontend, "generated/"), "routes.tsx").exists());
        Assert.assertFalse((String)"Missing ./frontend/routes.tsx", (boolean)new File(this.frontend, "routes.tsx").exists());
        Assert.assertTrue((String)"Missing ./frontend/generated/layouts.json", (boolean)new File(new File(this.frontend, "generated/"), "layouts.json").exists());
        this.assertGeneratedFileExists("jsx-dev-transform/index.ts");
        this.assertGeneratedFileExists("jsx-dev-transform/jsx-runtime.ts");
        this.assertGeneratedFileExists("jsx-dev-transform/jsx-dev-runtime.ts");
    }

    private void assertGeneratedFileExists(String filename) {
        Assert.assertTrue((String)("Missing ./frontend/generated/" + filename), (boolean)new File(new File(this.frontend, "generated/"), filename).exists());
    }

    @Test
    public void layoutsJson_containsExpectedPaths() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.options.getClassFinder().getAnnotatedClasses(Layout.class)).thenReturn(Collections.singleton(TestLayout.class));
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(this.options);
        task.execute();
        String layoutsContent = Files.readString(new File(this.options.getFrontendGeneratedFolder(), "layouts.json").toPath());
        Assert.assertEquals((Object)"[{\"path\":\"/test\"}]", (Object)layoutsContent);
    }

    @Test
    public void routesContainImportAndUsage_serverSideRoutes_noExceptionThrown() throws IOException {
        String content = "        import HelloWorldView from 'Frontend/views/helloworld/HelloWorldView.js';\n        import MainLayout from 'Frontend/views/MainLayout.js';\n        import { lazy } from 'react';\n        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n        import Flow from 'Frontend/generated/flow/Flow';\n        import {protectRoutes} from \"@hilla/react-auth\";\n        import LoginView from \"Frontend/views/LoginView\";\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n        export const { router, routes } = new RouterConfigurationBuilder()\n            .withReactRoutes([\n                 {\n                     element: <MainLayout />,\n                     handle: { title: 'Main' },\n                     children: [\n                         { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World', rolesAllowed: ['USER'] } },\n                         { path: '/about', element: <AboutView />, handle: { title: 'About' } },\n                     ],\n                 },\n             ])\n            .withFallback(Flow)\n            .withReactRoutes([\n                 { path: '/login', element: <Login />, handle: { title: 'Login' } },\n             ])\n            .protect()\n            .build();\n";
        this.executeTask(content);
    }

    @Test
    public void routesContainOnlyImport_serverSideRoutes_exceptionThrown() throws IOException {
        String content = "         import { serverSideRoutes } from 'Frontend/generated/flow/Flow';\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.NO_IMPORT, this.routesTsx.getPath()));
    }

    @Test
    public void routesContainNoImport_serverSideRoutes_exceptionThrown() throws IOException {
        String content = "         export const routes = [\n             ...serverSideRoutes\n         ] as RouteObject[];\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.NO_IMPORT, this.routesTsx.getPath()));
    }

    @Test
    public void routesContainMultipleFlowImports_noExceptionThrown() throws IOException {
        String content = "        import HelloWorldView from 'Frontend/views/helloworld/HelloWorldView.js';\n        import MainLayout from 'Frontend/views/MainLayout.js';\n        import { createBrowserRouter, RouteObject } from 'react-router';\n        import { tea, serverSideRoutes, coffee } from \"Frontend/generated/flow/Flow\";\n        import LoginView from \"Frontend/views/LoginView\";\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n\n        export const routes: RouteObject[] = protectRoutes([\n          {\n            element: <MainLayout />,\n            handle: { title: 'Main' },\n            children: [\n              { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World', rolesAllowed: ['USER'] } },\n              { path: '/about', element: <AboutView />, handle: { title: 'About' } },\n              ...serverSideRoutes\n            ],\n          },\n          { path: '/login', element: <LoginView />},\n        ]);\n\n        export default createBrowserRouter(routes);\n";
        this.executeTask(content);
    }

    @Test
    public void routesMissingImportAndUsage_noBuildOrServerSideRoutes_exceptionThrown() throws IOException {
        String content = "        import HelloWorldView from 'Frontend/views/helloworld/HelloWorldView.js';\n        import MainLayout from 'Frontend/views/MainLayout.js';\n        import { createBrowserRouter, RouteObject } from 'react-router';\n        import { tea, coffee } from \"Frontend/generated/flow/Flow\";\n        import LoginView from \"Frontend/views/LoginView\";\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n\n        export const routes: RouteObject[] = protectRoutes([\n          {\n            element: <MainLayout />,\n            handle: { title: 'Main' },\n            children: [\n              { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World', rolesAllowed: ['USER'] } },\n              { path: '/about', element: <AboutView />, handle: { title: 'About' } }\n            ],\n          },\n          { path: '/login', element: <LoginView />},\n        ]);\n\n        export default createBrowserRouter(routes);\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.NO_IMPORT, this.routesTsx.getPath()));
    }

    @Test
    public void routesMissingImport_exceptionThrown() throws IOException {
        String content = "        import HelloWorldView from 'Frontend/views/helloworld/HelloWorldView.js';\n        import MainLayout from 'Frontend/views/MainLayout.js';\n        import { lazy } from 'react';\n        import { createBrowserRouter, RouteObject } from 'react-router';\n        import {protectRoutes} from \"@hilla/react-auth\";\n        import LoginView from \"Frontend/views/LoginView\";\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n\n        export const routes: RouteObject[] = protectRoutes([\n          {\n            element: <MainLayout />,\n            handle: { title: 'Main' },\n            children: [\n              { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World', rolesAllowed: ['USER'] } },\n              { path: '/about', element: <AboutView />, handle: { title: 'About' } }\n            ],\n          },\n          { path: '/login', element: <LoginView />},\n        ]);\n\n        export default createBrowserRouter(routes);\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.NO_IMPORT, this.routesTsx.getPath()));
    }

    @Test
    public void missingImport_noServerRoutesDefined_noExceptionThrown() throws IOException, ExecutionFailedException {
        String content = "        import HelloWorldView from 'Frontend/views/helloworld/HelloWorldView.js';\n        import MainLayout from 'Frontend/views/MainLayout.js';\n        import { lazy } from 'react';\n        import { createBrowserRouter, RouteObject } from 'react-router';\n        import {protectRoutes} from \"@hilla/react-auth\";\n        import LoginView from \"Frontend/views/LoginView\";\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n\n        export const routes: RouteObject[] = protectRoutes([\n          {\n            element: <MainLayout />,\n            handle: { title: 'Main' },\n            children: [\n              { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World', rolesAllowed: ['USER'] } },\n              { path: '/about', element: <AboutView />, handle: { title: 'About' } }\n            ],\n          },\n          { path: '/login', element: <LoginView />},\n        ]);\n\n        export default createBrowserRouter(routes);\n";
        FileUtils.write((File)this.routesTsx, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.emptySet());
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(this.options);
        task.execute();
    }

    @Test
    public void routesExportMissing_exceptionThrown() throws IOException {
        String content = "        import HelloWorldView from 'Frontend/views/helloworld/HelloWorldView.js';\n        import MainLayout from 'Frontend/views/MainLayout.js';\n        import { lazy } from 'react';\n        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n        import Flow from 'Frontend/generated/flow/Flow';\n        import {protectRoutes} from \"@hilla/react-auth\";\n        import LoginView from \"Frontend/views/LoginView\";\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n        export const { router } = new RouterConfigurationBuilder()\n            .withReactRoutes([\n                 {\n                     element: <MainLayout />,\n                     handle: { title: 'Main' },\n                     children: [\n                         { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World', rolesAllowed: ['USER'] } },\n                         { path: '/about', element: <AboutView />, handle: { title: 'About' } },\n                     ],\n                 },\n             ])\n            .withFallback(Flow)\n            .withReactRoutes([\n                 { path: '/login', element: <Login />, handle: { title: 'Login' } },\n             ])\n            .protect()\n            .build();\n";
        this.assertTaskExecutionFails(content, TaskGenerateReactFiles.MISSING_ROUTES_EXPORT);
    }

    @Test
    public void withFallbackMissing_exceptionThrown() throws IOException {
        String content = "        import HelloWorldView from 'Frontend/views/helloworld/HelloWorldView.js';\n        import MainLayout from 'Frontend/views/MainLayout.js';\n        import { lazy } from 'react';\n        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n        import Flow from 'Frontend/generated/flow/Flow';\n        import {protectRoutes} from \"@hilla/react-auth\";\n        import LoginView from \"Frontend/views/LoginView\";\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n        export const { router, routes } = new RouterConfigurationBuilder()\n            .withReactRoutes([\n                 {\n                     element: <MainLayout />,\n                     handle: { title: 'Main' },\n                     children: [\n                         { path: '/', element: <HelloWorldView />, handle: { title: 'Hello World', rolesAllowed: ['USER'] } },\n                         { path: '/about', element: <AboutView />, handle: { title: 'About' } },\n                     ],\n                 },\n             ])\n            .withReactRoutes([\n                 { path: '/login', element: <Login />, handle: { title: 'Login' } },\n             ])\n            .protect()\n            .build();\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.NO_IMPORT, this.routesTsx.getPath()));
    }

    @Test
    public void withFallbackReceivesDifferentObject_exceptionThrown() throws IOException {
        String content = "        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n        import foo from 'Frontend/generated/flow/Flow';\n\n        export const { router, routes } = new RouterConfigurationBuilder()\n            .withFallback(Flow)\n            .build();\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.NO_IMPORT, this.routesTsx.getPath()));
    }

    @Test
    public void withFallbackMissesImport_exceptionThrown() throws IOException {
        String content = "        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n\n        const AboutView = lazy(async () => import('Frontend/views/about/AboutView.js'));\n        export const { router, routes } = new RouterConfigurationBuilder()\n            .withFallback(Flow)\n            .build();\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.NO_IMPORT, this.routesTsx.getPath()));
    }

    @Test
    public void frontendReactFilesAreCleanedWhenReactIsDisabled() throws ExecutionFailedException {
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(this.options);
        task.execute();
        this.options.withReact(false);
        task.execute();
        Assert.assertFalse((String)"./frontend/routes.tsx should be removed when react is disabled", (boolean)new File(this.frontend, "routes.tsx").exists());
        Assert.assertFalse((String)"./frontend/generated/flow/Flow.tsx should be removed when react is disabled", (boolean)new File(this.frontendGenerated, "flow/Flow.tsx").exists());
        Assert.assertFalse((String)"./frontend/generated/flow/ReactAdapter.tsx should be removed when react is disabled", (boolean)new File(this.frontendGenerated, "flow/ReactAdapter.tsx").exists());
        Assert.assertFalse((String)"./frontend/routes.tsx.flowBackup should not be created with default content", (boolean)new File(this.frontend, "routes.tsx.flowBackup").exists());
        this.assertGeneratedFileRemoved("jsx-dev-transform/index.ts");
        this.assertGeneratedFileRemoved("jsx-dev-transform/jsx-dev-runtime.ts");
        this.assertGeneratedFileRemoved("jsx-dev-transform/jsx-runtime.ts");
    }

    private void assertGeneratedFileRemoved(String filename) {
        Assert.assertFalse((String)("./frontend/generated/" + filename + " should be removed when react is disabled"), (boolean)new File(this.frontendGenerated, filename).exists());
    }

    @Test
    public void frontendCustomReactFilesAreCleanedAndBackUppedWhenReactIsDisabled() throws ExecutionFailedException, IOException {
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(this.options);
        task.execute();
        FileUtils.write((File)this.routesTsx, (CharSequence)"Custom content", (Charset)StandardCharsets.UTF_8);
        this.options.withReact(false);
        task.execute();
        Assert.assertFalse((String)"./frontend/routes.tsx should be removed when react is disabled", (boolean)new File(this.frontend, "routes.tsx").exists());
        Assert.assertFalse((String)"./frontend/generated/routes.tsx should be removed when react is disabled", (boolean)new File(new File(this.frontend, "generated/"), "routes.tsx").exists());
        Assert.assertTrue((String)"./frontend/routes.tsx.flowBackup should exist", (boolean)new File(this.frontend, "routes.tsx.flowBackup").exists());
    }

    @Test
    public void routesContainExport_noConst_noExceptionThrown() throws IOException {
        String content = "        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n        import Flow from 'Frontend/generated/flow/Flow';\n\n        const { router, originalRoutes } = new RouterConfigurationBuilder();\n           .withFallback(Flow)\n           .build();\n\n        const routes = originalRoutes;\n        export { router, routes }\n";
        this.executeTask(content);
    }

    @Test
    public void routesContainExport_twoSingleExports_noExceptionThrown() throws IOException {
        String content = "        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n        import Flow from 'Frontend/generated/flow/Flow';\n\n        const { router, originalRoutes } = new RouterConfigurationBuilder();\n           .withFallback(Flow)\n           .build();\n\n        const routes = originalRoutes;\n        export { routes }\n        router = anotherRouter;\n        export {router}\n";
        this.executeTask(content);
    }

    @Test
    public void routesContainExport_oneSingleExport_exceptionThrown() throws IOException {
        String content = "        import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n        import Flow from 'Frontend/generated/flow/Flow';\n\n        const { router, originalRoutes } = new RouterConfigurationBuilder();\n           .withFallback(Flow)\n           .build();\n\n        const routes = originalRoutes;\n        export { routes }\n";
        this.assertTaskExecutionFails(content, String.format(TaskGenerateReactFiles.MISSING_ROUTES_EXPORT, this.routesTsx.getPath()));
    }

    private void assertTaskExecutionFails(String content, String errorMessage) throws IOException {
        FileUtils.write((File)this.routesTsx, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(this.options);
        Exception exception = (Exception)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskGenerateReactFiles)task).execute());
        Assert.assertEquals((Object)errorMessage, (Object)exception.getMessage());
    }

    private void executeTask(String content) throws IOException {
        FileUtils.write((File)this.routesTsx, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        TaskGenerateReactFiles task = new TaskGenerateReactFiles(this.options);
        try {
            task.execute();
        }
        catch (ExecutionFailedException e) {
            throw new AssertionError("Expected execution to complete successfully, but exception was thrown", e);
        }
    }

    @Tag(value="div")
    @Route(value="test")
    private class TestRoute
    extends Component {
        private TestRoute() {
        }
    }

    @Tag(value="div")
    @Layout(value="/test")
    private class TestLayout
    extends Component
    implements RouterLayout {
        private TestLayout() {
        }
    }
}

