/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateIndexTs;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateIndexTsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File frontendFolder;
    private File generatedImports;
    private TaskGenerateIndexTs taskGenerateIndexTs;
    private Options options;

    @Before
    public void setUp() throws IOException {
        this.frontendFolder = this.temporaryFolder.newFolder("frontend/");
        File generatedFolder = this.temporaryFolder.newFolder(new String[]{"target", "frontend/"});
        this.generatedImports = new File(generatedFolder, "flow-generated-imports.js");
        this.generatedImports.createNewFile();
        this.options = new Options((Lookup)Mockito.mock(Lookup.class), this.temporaryFolder.getRoot()).withFrontendDirectory(this.frontendFolder).withBuildDirectory("target");
        this.taskGenerateIndexTs = new TaskGenerateIndexTs(this.options);
    }

    @Test
    public void should_reported_routing_client_when_IndexJsExists() throws Exception {
        Files.createFile(new File(this.frontendFolder, "index.js").toPath(), new FileAttribute[0]);
        this.taskGenerateIndexTs.execute();
        Assert.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/client".equals(e.getName())));
    }

    @Test
    public void should_reported_routing_client_when_IndexTsExists() throws Exception {
        Files.createFile(new File(this.frontendFolder, "index.ts").toPath(), new FileAttribute[0]);
        this.taskGenerateIndexTs.execute();
        Assert.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/client".equals(e.getName())));
    }

    @Test
    public void should_reported_routing_client_when_IndexTsxExists() throws Exception {
        Files.createFile(new File(this.frontendFolder, "index.tsx").toPath(), new FileAttribute[0]);
        this.taskGenerateIndexTs.execute();
        Assert.assertTrue((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/client".equals(e.getName())));
    }

    @Test
    public void should_not_reported_routing_client() throws Exception {
        this.taskGenerateIndexTs.execute();
        Assert.assertFalse((boolean)UsageStatistics.getEntries().anyMatch(e -> "routing/client".equals(e.getName())));
    }

    @Test
    public void should_notGenerateIndexTs_IndexJsExists() throws Exception {
        Files.createFile(new File(this.frontendFolder, "index.js").toPath(), new FileAttribute[0]);
        this.taskGenerateIndexTs.execute();
        Assert.assertFalse((String)"Should not generate index.ts when index.js exists in the frontend folder", (boolean)this.taskGenerateIndexTs.shouldGenerate());
        Assert.assertFalse((String)"The generated file should not exists", (boolean)this.taskGenerateIndexTs.getGeneratedFile().exists());
    }

    @Test
    public void should_notGenerateIndexTs_IndexTsExists() throws Exception {
        Files.createFile(new File(this.frontendFolder, "index.ts").toPath(), new FileAttribute[0]);
        this.taskGenerateIndexTs.execute();
        Assert.assertFalse((String)"Should not generate index.ts when index.ts exists in the frontend folder", (boolean)this.taskGenerateIndexTs.shouldGenerate());
        Assert.assertFalse((String)"The generated file should not exists", (boolean)this.taskGenerateIndexTs.getGeneratedFile().exists());
    }

    @Test
    public void should_generateIndexJs_IndexJsNotExist() throws Exception {
        this.taskGenerateIndexTs.execute();
        Assert.assertTrue((String)"Should generate index.ts when it doesn't exist in the frontend folder", (boolean)this.taskGenerateIndexTs.shouldGenerate());
        Assert.assertTrue((String)"The generated file should exists", (boolean)this.taskGenerateIndexTs.getGeneratedFile().exists());
        Assert.assertEquals((String)"Should have default content of index.ts", (Object)this.taskGenerateIndexTs.getFileContent(), (Object)IOUtils.toString((URI)this.taskGenerateIndexTs.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void should_ensureValidRelativePath_whenItHasNoRelativePrefix() {
        String customPath = TaskGenerateIndexTs.ensureValidRelativePath((String)"../custom-frontend/generated-flow-imports.js");
        Assert.assertEquals((String)"Should not append './' if it is already a relative path", (Object)"../custom-frontend/generated-flow-imports.js", (Object)customPath);
        customPath = TaskGenerateIndexTs.ensureValidRelativePath((String)"custom-frontend/generated-flow-imports.js");
        Assert.assertEquals((String)"Should append './' if it doesn't start with a relative path", (Object)"./custom-frontend/generated-flow-imports.js", (Object)customPath);
    }
}

