/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateFeatureFlags;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateFeatureFlagsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TaskGenerateFeatureFlags taskGenerateFeatureFlags;
    private FeatureFlags featureFlags;

    @Before
    public void setUp() throws Exception {
        MockVaadinContext context = new MockVaadinContext();
        ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        context.setAttribute(ApplicationConfiguration.class, configuration);
        File frontendFolder = this.temporaryFolder.newFolder("frontend/");
        this.featureFlags = FeatureFlags.get((VaadinContext)context);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), null).withFrontendDirectory(frontendFolder).withFeatureFlags(this.featureFlags);
        this.taskGenerateFeatureFlags = new TaskGenerateFeatureFlags(options);
    }

    @Test
    public void should_disableTypeChecksForGlobals() throws ExecutionFailedException {
        this.taskGenerateFeatureFlags.execute();
        String content = this.taskGenerateFeatureFlags.getFileContent();
        Assert.assertTrue((boolean)content.startsWith("// @ts-nocheck"));
    }

    @Test
    public void should_setupFeatureFlagsGlobal() throws ExecutionFailedException {
        this.taskGenerateFeatureFlags.execute();
        String content = this.taskGenerateFeatureFlags.getFileContent();
        Assert.assertTrue((boolean)content.contains("window.Vaadin = window.Vaadin || {};"));
        Assert.assertTrue((boolean)content.contains("window.Vaadin.featureFlags = window.Vaadin.featureFlags || {};"));
    }

    @Test
    public void should_defineAllFeatureFlags() throws ExecutionFailedException {
        this.taskGenerateFeatureFlags.execute();
        String content = this.taskGenerateFeatureFlags.getFileContent();
        this.featureFlags.getFeatures().forEach(feature -> TaskGenerateFeatureFlagsTest.assertFeatureFlagGlobal(content, feature, false));
    }

    @Test
    public void should_callFeatureFlagsUpdaterFunction() throws ExecutionFailedException {
        this.taskGenerateFeatureFlags.execute();
        String content = this.taskGenerateFeatureFlags.getFileContent();
        Assert.assertTrue((boolean)content.contains("window.Vaadin.featureFlagsUpdaters.forEach(updater => updater(activator))"));
    }

    @Test
    public void should_containEmptyExport() throws ExecutionFailedException {
        this.taskGenerateFeatureFlags.execute();
        String content = this.taskGenerateFeatureFlags.getFileContent();
        Assert.assertTrue((boolean)content.contains("export {};"));
    }

    private static void assertFeatureFlagGlobal(String content, Feature feature, boolean enabled) {
        Assert.assertTrue((boolean)content.contains(String.format("window.Vaadin.featureFlags.%s = %s", feature.getId(), enabled)));
    }
}

