/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateBootstrap;
import com.vaadin.flow.server.frontend.TypeScriptBootstrapModifier;
import com.vaadin.flow.server.frontend.UpdateThemedImportsTest;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskGenerateBootstrapTest {
    private static final String DEV_TOOLS_IMPORT = "import 'Frontend/generated/jar-resources/vaadin-dev-tools/vaadin-dev-tools.js';";
    private static final String CUSTOM_MODIFIER_CONTENT = "// custom modifier";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private FrontendDependenciesScanner frontDeps;
    private File frontendFolder;
    private TaskGenerateBootstrap taskGenerateBootstrap;
    private Options options;

    @Before
    public void setUp() throws Exception {
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(Set.of(this.getClass(), CustomModifier.class));
        this.frontDeps = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(false, (ClassFinder)finder, false, null, true);
        this.frontendFolder = this.temporaryFolder.newFolder("frontend/");
        this.options = new MockOptions((ClassFinder)finder, null).withFrontendDirectory(this.frontendFolder).withProductionMode(true);
        this.taskGenerateBootstrap = new TaskGenerateBootstrap(this.frontDeps, this.options);
    }

    @Test
    public void should_importGeneratedIndexTS() throws ExecutionFailedException {
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains("import './index';"));
    }

    @Test
    public void shouldNot_importDevTools_inProduction() throws ExecutionFailedException {
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        Assert.assertFalse((boolean)content.contains(DEV_TOOLS_IMPORT));
    }

    @Test
    public void should_importDevTools_inDevMode() throws ExecutionFailedException {
        this.options.withProductionMode(false);
        this.taskGenerateBootstrap = new TaskGenerateBootstrap(this.frontDeps, this.options);
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains(DEV_TOOLS_IMPORT));
    }

    @Test
    public void should_importFrontendIndexTS() throws ExecutionFailedException, IOException {
        new File(this.frontendFolder, "index.ts").createNewFile();
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains("import '../index';"));
    }

    @Test
    public void should_importFrontendIndexTSX() throws ExecutionFailedException, IOException {
        new File(this.frontendFolder, "index.tsx").createNewFile();
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains("import '../index';"));
    }

    @Test
    public void should_importFeatureFlagTS() throws ExecutionFailedException {
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains(String.format("import './%s';", "vaadin-featureflags.js")));
    }

    @Test
    public void should_importFeatureFlagTSBeforeModifiers() throws ExecutionFailedException {
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        int featureFlagIndex = content.indexOf(String.format("import './%s';", "vaadin-featureflags.js"));
        int modifierIndex = content.indexOf(CUSTOM_MODIFIER_CONTENT);
        Assert.assertTrue((String)"Feature flag import should be before any modifier", (featureFlagIndex < modifierIndex ? 1 : 0) != 0);
    }

    @Test
    public void should_load_AppTheme() throws MalformedURLException, ExecutionFailedException {
        this.options.withFrontendDirectory(this.frontendFolder).withProductionMode(true);
        this.taskGenerateBootstrap = new TaskGenerateBootstrap((FrontendDependenciesScanner)this.getThemedDependency(), this.options);
        this.taskGenerateBootstrap.execute();
        String content = this.taskGenerateBootstrap.getFileContent();
        List<String> expectedContent = Arrays.asList("import './index';", "import { applyTheme } from './theme.js';", "applyTheme(document);");
        expectedContent.forEach(expectedLine -> Assert.assertTrue((String)String.format("Bootstrap 'vaadin.ts' file is supposed to contain the line: [%s],\nbut actually contains the following: [%s]", expectedLine, content), (boolean)content.contains((CharSequence)expectedLine)));
    }

    private FrontendDependencies getThemedDependency() throws MalformedURLException {
        ClassFinder finder = NodeUpdateTestUtil.getClassFinder();
        return new FrontendDependencies(finder, true, null, true){

            public Map<ChunkInfo, List<String>> getModules() {
                return Collections.emptyMap();
            }

            public Map<ChunkInfo, List<String>> getScripts() {
                return Collections.emptyMap();
            }

            public AbstractTheme getTheme() {
                return new UpdateThemedImportsTest.MyTheme();
            }

            public ThemeDefinition getThemeDefinition() {
                return new ThemeDefinition(UpdateThemedImportsTest.MyTheme.class, "", "my-theme");
            }
        };
    }

    public static class CustomModifier
    implements TypeScriptBootstrapModifier {
        public void modify(List<String> lines, Options options, FrontendDependenciesScanner scanner) {
            lines.add(0, TaskGenerateBootstrapTest.CUSTOM_MODIFIER_CONTENT);
        }
    }
}

