/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.Template;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyTemplateFiles;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.testutil.TestUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskCopyTemplateFilesTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File projectDirectory;
    private File resourceOutputDirectory;
    private ClassFinder finder;

    @Before
    public void setup() throws IOException, ClassNotFoundException {
        this.projectDirectory = this.temporaryFolder.newFolder();
        this.resourceOutputDirectory = new File(this.projectDirectory, "target/META-INF/VAADIN/");
        this.finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)this.finder.getSubTypesOf(Template.class)).thenReturn(Collections.singleton(MyLitElementView.class));
        Class<JsModule> clazz = JsModule.class;
        Mockito.when((Object)this.finder.loadClass(JsModule.class.getName())).thenReturn(clazz);
    }

    @Test
    public void should_copyTemplateFilesFromDefaultFrontendDirectory() throws Exception {
        this.executeTaskCopyTemplateFiles("frontend/");
    }

    @Test
    public void should_copyTemplateFilesFromCustomFrontendDirectory() throws Exception {
        this.executeTaskCopyTemplateFiles("frontend-custom");
    }

    private void executeTaskCopyTemplateFiles(String frontedDirectoryName) throws Exception {
        File frontendDirectory = new File(this.projectDirectory, frontedDirectoryName);
        frontendDirectory.mkdirs();
        new File(frontendDirectory, "my-lit-element-view.js").createNewFile();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.projectDirectory).withBuildResultFolders(frontendDirectory, this.resourceOutputDirectory).withFrontendDirectory(frontendDirectory);
        TaskCopyTemplateFiles task = new TaskCopyTemplateFiles(this.finder, options);
        task.execute();
        List files = TestUtils.listFilesRecursively((File)this.resourceOutputDirectory);
        Assert.assertTrue((String)"TS resource should have been copied", (boolean)files.stream().anyMatch(file -> file.contains("my-lit-element-view.js")));
    }

    @Tag(value="my-lit-element-view")
    @JsModule(value="./my-lit-element-view.js")
    public static class MyLitElementView
    implements Template {
    }
}

