/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskCopyLocalFrontendFilesTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void directoryWithReadOnlyFile_copyIsNotReadOnly() throws IOException {
        File sourceFolder = this.createReadOnlySource();
        File outFolder = this.temporaryFolder.newFolder("out");
        TaskCopyLocalFrontendFiles.copyLocalResources((File)sourceFolder, (File)outFolder, (String[])new String[0]);
        File copiedReadOnly = new File(outFolder, "readOnly.txt");
        Assert.assertTrue((String)"Copied files should be writable even when source is readOnly", (boolean)copiedReadOnly.canWrite());
    }

    @Test
    public void directoryWithReadOnlyFile_canCopyMultipleTimesToSource() throws IOException {
        File sourceFolder = this.createReadOnlySource();
        File outFolder = this.temporaryFolder.newFolder("out");
        TaskCopyLocalFrontendFiles.copyLocalResources((File)sourceFolder, (File)outFolder, (String[])new String[0]);
        TaskCopyLocalFrontendFiles.copyLocalResources((File)sourceFolder, (File)outFolder, (String[])new String[0]);
    }

    @Test
    public void execute_copiedFilesAreTracked() throws IOException {
        File sourceFolder = this.createReadOnlySource();
        File outFolder = this.temporaryFolder.newFolder("out");
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withJarFrontendResourcesFolder(outFolder).copyLocalResources(sourceFolder);
        GeneratedFilesSupport generatedFileSupport = new GeneratedFilesSupport();
        TaskCopyLocalFrontendFiles task = new TaskCopyLocalFrontendFiles(options);
        task.setGeneratedFileSupport(generatedFileSupport);
        task.execute();
        File copiedReadOnly = new File(outFolder, "readOnly.txt");
        Assert.assertTrue((String)"Copied files should be writable even when source is readOnly", (boolean)copiedReadOnly.canWrite());
        Assert.assertEquals((String)"Copied files should have been tracked", Set.of(copiedReadOnly.toPath()), (Object)generatedFileSupport.getFiles());
    }

    private File createReadOnlySource() throws IOException {
        File sourceFolder = this.temporaryFolder.newFolder("source");
        File readOnly = new File(sourceFolder, "readOnly.txt");
        readOnly.createNewFile();
        Assert.assertTrue((String)"Could not make file read-only", (boolean)readOnly.setReadOnly());
        return sourceFolder;
    }
}

