/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCleanFrontendFiles;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TaskCleanFrontendFilesTest {
    @Rule
    public final TemporaryFolder rootFolder = new TemporaryFolder();
    private File projectRoot;
    private File frontendDirectory;
    private ClassFinder classFinder;
    private Options options;

    @Before
    public void init() {
        this.projectRoot = this.rootFolder.getRoot();
        this.frontendDirectory = new File(this.projectRoot, "target/frontend");
        this.classFinder = (ClassFinder)Mockito.mock(ClassFinder.class);
        this.options = new Options(null, this.classFinder, this.projectRoot).withFrontendDirectory(this.frontendDirectory).withFrontendGeneratedFolder(new File(this.frontendDirectory, "generated"));
    }

    @Test
    public void createdFileAreRemoved() throws IOException, ExecutionFailedException {
        TaskCleanFrontendFiles clean = new TaskCleanFrontendFiles(this.options);
        Set<String> generatedFiles = Stream.of("vite.config.ts", "vite.generated.ts", "node_modules", "package.json", "package-lock.json", "tsconfig.json", "types.d.ts", ".npmrc").collect(Collectors.toSet());
        this.createFiles(generatedFiles);
        clean.execute();
        this.assertFilesNotExist(generatedFiles);
    }

    @Test
    public void existingFrontendFiles_onlyCreatedFileAreRemoved() throws IOException, ExecutionFailedException {
        Set<String> existingfiles = Stream.of("vite.config.ts", "package.json", "node_modules", "package-lock.json").collect(Collectors.toSet());
        this.createFiles(existingfiles);
        TaskCleanFrontendFiles clean = new TaskCleanFrontendFiles(this.options);
        Set<String> generatedFiles = Stream.of("vite.generated.ts", "tsconfig.json", "types.d.ts", ".npmrc").collect(Collectors.toSet());
        this.createFiles(generatedFiles);
        clean.execute();
        this.assertFilesNotExist(generatedFiles);
        this.assertFilesExist(existingfiles);
    }

    @Test
    public void nodeModulesFolderIsCleared() throws IOException, ExecutionFailedException {
        TaskCleanFrontendFiles clean = new TaskCleanFrontendFiles(this.options);
        File nodeModules = this.rootFolder.newFolder("node_modules");
        new File(nodeModules, "file").createNewFile();
        File directory = new File(nodeModules, "directory");
        directory.mkdir();
        new File(directory, "file.fi").createNewFile();
        clean.execute();
        this.assertFilesNotExist(Collections.singleton("node_modules"));
    }

    @Test
    public void packageJsonExists_nodeModulesFolderIsKept() throws IOException, ExecutionFailedException {
        this.createFiles(Collections.singleton("package.json"));
        TaskCleanFrontendFiles clean = new TaskCleanFrontendFiles(this.options);
        File nodeModules = this.rootFolder.newFolder("node_modules");
        new File(nodeModules, "file").createNewFile();
        File directory = new File(nodeModules, "directory");
        directory.mkdir();
        new File(directory, "file.fi").createNewFile();
        clean.execute();
        this.assertFilesExist(Collections.singleton("node_modules"));
    }

    @Test
    public void hillaIsUsed_nodeModulesFolderIsKept() throws IOException, ExecutionFailedException {
        TaskCleanFrontendFiles clean;
        try (MockedStatic util = Mockito.mockStatic(FrontendBuildUtils.class);){
            util.when(() -> FrontendBuildUtils.isHillaUsed((File)((File)Mockito.any()), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)true);
            clean = new TaskCleanFrontendFiles(this.options);
        }
        File nodeModules = this.rootFolder.newFolder("node_modules");
        new File(nodeModules, "file").createNewFile();
        File directory = new File(nodeModules, "directory");
        directory.mkdir();
        new File(directory, "file.fi").createNewFile();
        clean.execute();
        this.assertFilesExist(Collections.singleton("node_modules"));
    }

    @Test
    public void hillaIsNotUsed_fileRoutesExists_fileRoutesClearedEagerly() throws IOException, ExecutionFailedException {
        File nodeModules = this.rootFolder.newFolder("target/frontend/generated");
        new File(nodeModules, "file-routes.ts").createNewFile();
        new File(nodeModules, "file-routes.json").createNewFile();
        try (MockedStatic util = Mockito.mockStatic(FrontendBuildUtils.class);){
            util.when(() -> FrontendBuildUtils.isHillaUsed((File)((File)Mockito.any()), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)false);
            new TaskCleanFrontendFiles(this.options);
        }
        this.assertFilesNotExist(Set.of("target/frontend/generated/file-routes.ts", "target/frontend/generated/file-routes.json"));
    }

    private void createFiles(Set<String> filesToCreate) throws IOException {
        for (String file : filesToCreate) {
            this.rootFolder.newFile(file);
        }
    }

    private void assertFilesNotExist(Set<String> files) {
        HashSet<String> existingFiles = new HashSet<String>();
        for (String file2 : files) {
            if (!new File(this.projectRoot, file2).exists()) continue;
            existingFiles.add(file2);
        }
        if (!existingFiles.isEmpty()) {
            StringBuilder fileList = new StringBuilder();
            existingFiles.forEach(file -> fileList.append((String)file).append("\n"));
            Assert.fail((String)String.format("Found files that should have been removed: %s\n", fileList));
        }
    }

    private void assertFilesExist(Set<String> files) {
        HashSet<String> existingFiles = new HashSet<String>(files);
        for (String file2 : files) {
            if (!new File(this.projectRoot, file2).exists()) continue;
            existingFiles.remove(file2);
        }
        if (!existingFiles.isEmpty()) {
            StringBuilder fileList = new StringBuilder();
            existingFiles.forEach(file -> fileList.append((String)file).append("\n"));
            Assert.fail((String)String.format("Missing files that should exist: %s\n", fileList));
        }
    }
}

