/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.ProdBundleUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ProdBundleUtilsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void compressProdBundle_decompressProdBundle_filesHasSameHash() throws IOException {
        File projectBase = this.temporaryFolder.getRoot();
        File prodFolder = new File(projectBase, "target/classes/META-INF/VAADIN");
        prodFolder.mkdirs();
        File configFolder = new File(prodFolder, "config");
        configFolder.mkdir();
        File stats = new File(configFolder, "stats.json");
        File index = new File(prodFolder, "index.html");
        Files.write(stats.toPath(), Collections.singleton("{ \"stats\": 1 }"), new OpenOption[0]);
        Files.write(index.toPath(), Collections.singleton("<!DOCTYPE html>"), new OpenOption[0]);
        String statsHash = StringUtil.getHash((String)Files.readString(stats.toPath()));
        String indexHash = StringUtil.getHash((String)Files.readString(index.toPath()));
        ProdBundleUtils.compressBundle((File)projectBase, (File)prodFolder);
        Assert.assertTrue((String)"Compressed bundle should have been created", (boolean)new File(projectBase, "src/main/bundles/prod.bundle").exists());
        FileUtils.deleteDirectory((File)prodFolder);
        Assert.assertFalse((String)"Prod folder not deleted!", (boolean)prodFolder.exists());
        ProdBundleUtils.unpackBundle((File)projectBase, (File)prodFolder);
        Assert.assertTrue((String)"Prod folder not created!", (boolean)prodFolder.exists());
        Assert.assertTrue((String)"Config folder not created!", (boolean)configFolder.exists());
        Assert.assertTrue((String)"stats file not created!", (boolean)stats.exists());
        Assert.assertTrue((String)"packages file not created!", (boolean)index.exists());
        Assert.assertEquals((Object)statsHash, (Object)StringUtil.getHash((String)Files.readString(stats.toPath())));
        Assert.assertEquals((Object)indexHash, (Object)StringUtil.getHash((String)Files.readString(index.toPath())));
    }
}

