/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class NodeUpdaterTest {
    private static final String POLYMER_VERSION = "3.5.2";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private NodeUpdater nodeUpdater;
    private File npmFolder;
    private ClassFinder finder;
    private Options options;

    @Before
    public void setUp() throws IOException {
        this.npmFolder = this.temporaryFolder.newFolder();
        FeatureFlags featureFlags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        this.finder = (ClassFinder)Mockito.spy((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0]));
        this.options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withFeatureFlags(featureFlags);
        this.nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)Mockito.mock(FrontendDependencies.class), this.options){

            public void execute() {
            }
        };
    }

    @Test
    public void getGeneratedModules_should_includeOnlyWebComponents() throws IOException {
        File frontend = this.temporaryFolder.newFolder();
        File generated = new File(frontend, "generated/");
        File flow = new File(generated, "flow");
        File webComponents = new File(flow, "web-components");
        File fileA = new File(webComponents, "a.js");
        File fileB = new File(webComponents, "b.js");
        File fileC = new File(generated, "c.js");
        this.create(fileA);
        this.create(fileB);
        this.create(fileC);
        Set modules = NodeUpdater.getGeneratedModules((File)frontend);
        Assert.assertEquals(Set.of("web-components/a.js", "web-components/b.js"), (Object)modules);
    }

    private void create(File file) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
    }

    @Test
    public void getDefaultDependencies_withPolymerTemplate_includesAllDependencies() {
        this.fakePolymerTemplateInClasspath();
        Map defaultDeps = this.nodeUpdater.getDefaultDependencies();
        HashSet<String> expectedDependencies = new HashSet<String>();
        expectedDependencies.add("@polymer/polymer");
        expectedDependencies.add("@vaadin/common-frontend");
        expectedDependencies.add("lit");
        expectedDependencies.add("react");
        expectedDependencies.add("react-dom");
        expectedDependencies.add("react-router");
        Set actualDependendencies = defaultDeps.keySet();
        Assert.assertEquals(expectedDependencies, actualDependendencies);
    }

    @Test
    public void getDefaultDependencies_includesAllDependencies() {
        Map defaultDeps = this.nodeUpdater.getDefaultDependencies();
        HashSet<String> expectedDependencies = new HashSet<String>();
        expectedDependencies.add("@vaadin/common-frontend");
        expectedDependencies.add("lit");
        expectedDependencies.add("react");
        expectedDependencies.add("react-dom");
        expectedDependencies.add("react-router");
        Set actualDependendencies = defaultDeps.keySet();
        Assert.assertEquals(expectedDependencies, actualDependendencies);
    }

    @Test
    public void getDefaultDevDependencies_includesAllDependencies_whenUsingVite() {
        Map defaultDeps = this.nodeUpdater.getDefaultDevDependencies();
        Set<String> expectedDependencies = this.getCommonDevDeps();
        expectedDependencies.add("vite");
        expectedDependencies.add("@vitejs/plugin-react");
        expectedDependencies.add("rollup-plugin-brotli");
        expectedDependencies.add("@rollup/plugin-replace");
        expectedDependencies.add("@rollup/pluginutils");
        expectedDependencies.add("rollup-plugin-visualizer");
        expectedDependencies.add("vite-plugin-checker");
        expectedDependencies.add("workbox-build");
        expectedDependencies.add("transform-ast");
        expectedDependencies.add("strip-css-comments");
        expectedDependencies.add("@babel/preset-react");
        expectedDependencies.add("@types/react");
        expectedDependencies.add("@types/react-dom");
        expectedDependencies.add("@preact/signals-react-transform");
        expectedDependencies.add("magic-string");
        expectedDependencies.add("@types/node");
        Set actualDependendencies = defaultDeps.keySet();
        Assert.assertEquals(expectedDependencies, actualDependendencies);
    }

    private Set<String> getCommonDevDeps() {
        HashSet<String> expectedDependencies = new HashSet<String>();
        expectedDependencies.add("typescript");
        return expectedDependencies;
    }

    @Test
    public void updateMainDefaultDependencies_polymerVersionIsNull_useDefault() {
        this.fakePolymerTemplateInClasspath();
        ObjectNode object = JacksonUtils.createObjectNode();
        this.nodeUpdater.addVaadinDefaultsToJson(object);
        this.nodeUpdater.updateDefaultDependencies(object);
        String version = this.getPolymerVersion((JsonNode)object);
        Assert.assertEquals((Object)POLYMER_VERSION, (Object)version);
    }

    @Test
    public void updateMainDefaultDependencies_polymerVersionIsProvidedByUser_useProvided() {
        ObjectNode object = JacksonUtils.createObjectNode();
        ObjectNode dependencies = JacksonUtils.createObjectNode();
        dependencies.put("@polymer/polymer", "4.0.0");
        object.set("dependencies", (JsonNode)dependencies);
        this.nodeUpdater.addVaadinDefaultsToJson(object);
        this.nodeUpdater.updateDefaultDependencies(object);
        String version = this.getPolymerVersion((JsonNode)object);
        Assert.assertEquals((Object)"4.0.0", (Object)version);
    }

    @Test
    public void updateMainDefaultDependencies_vaadinIsProvidedByUser_useDefault() {
        this.fakePolymerTemplateInClasspath();
        ObjectNode object = JacksonUtils.createObjectNode();
        ObjectNode vaadin = JacksonUtils.createObjectNode();
        vaadin.put("disableUsageStatistics", true);
        object.set("vaadin", (JsonNode)vaadin);
        this.nodeUpdater.addVaadinDefaultsToJson(object);
        this.nodeUpdater.updateDefaultDependencies(object);
        Assert.assertEquals((Object)POLYMER_VERSION, (Object)this.getPolymerVersion((JsonNode)object));
        Assert.assertEquals((Object)POLYMER_VERSION, (Object)this.getPolymerVersion(object.get("vaadin")));
    }

    @Test
    public void updateDefaultDependencies_olderVersionsAreUpdated() throws IOException {
        ObjectNode packageJson = this.nodeUpdater.getPackageJson();
        packageJson.set("dependencies", (JsonNode)JacksonUtils.createObjectNode());
        packageJson.set("devDependencies", (JsonNode)JacksonUtils.createObjectNode());
        ((ObjectNode)packageJson.get("devDependencies")).put("typescript", "1.0.0");
        this.nodeUpdater.updateDefaultDependencies(packageJson);
        Assert.assertNotEquals((Object)"1.0.0", (Object)packageJson.get("devDependencies").get("typescript").stringValue());
    }

    @Test
    public void updateDefaultDependencies_newerVersionsAreNotChanged() throws IOException {
        ObjectNode packageJson = this.nodeUpdater.getPackageJson();
        packageJson.set("dependencies", (JsonNode)JacksonUtils.createObjectNode());
        packageJson.set("devDependencies", (JsonNode)JacksonUtils.createObjectNode());
        ((ObjectNode)packageJson.get("devDependencies")).put("vite", "78.2.3");
        this.nodeUpdater.updateDefaultDependencies(packageJson);
        Assert.assertEquals((Object)"78.2.3", (Object)packageJson.get("devDependencies").get("vite").asString());
    }

    @Test
    public void shouldUpdateExistingLocalFormPackageToNpmPackage() {
        ObjectNode packageJson = JacksonUtils.createObjectNode();
        ObjectNode dependencies = JacksonUtils.createObjectNode();
        packageJson.set("dependencies", (JsonNode)dependencies);
        ObjectNode vaadinDependencies = JacksonUtils.createObjectNode();
        vaadinDependencies.set("dependencies", (JsonNode)JacksonUtils.createObjectNode());
        packageJson.set("vaadin", (JsonNode)vaadinDependencies);
        String formPackage = "@vaadin/form";
        String legecyVersion = "./target/flow-frontend/form";
        String newVersion = "22.0.0";
        dependencies.put(formPackage, legecyVersion);
        this.nodeUpdater.addDependency(packageJson, "dependencies", formPackage, newVersion);
        Assert.assertEquals((Object)newVersion, (Object)packageJson.get("dependencies").get(formPackage).asString());
    }

    @Test
    public void shouldSkipUpdatingNonParsableVersions() {
        ObjectNode packageJson = JacksonUtils.createObjectNode();
        ObjectNode dependencies = JacksonUtils.createObjectNode();
        packageJson.set("dependencies", (JsonNode)dependencies);
        ObjectNode vaadinDependencies = JacksonUtils.createObjectNode();
        vaadinDependencies.set("dependencies", (JsonNode)JacksonUtils.createObjectNode());
        packageJson.set("vaadin", (JsonNode)vaadinDependencies);
        String formPackage = "@vaadin/form";
        String existingVersion = "../../../some/local/path";
        String newVersion = "2.0.0";
        dependencies.put(formPackage, existingVersion);
        this.nodeUpdater.addDependency(packageJson, "dependencies", formPackage, newVersion);
        Assert.assertEquals((Object)existingVersion, (Object)packageJson.get("dependencies").get(formPackage).textValue());
    }

    @Test
    public void canUpdateNonParseableVersions() {
        ObjectNode packageJson = JacksonUtils.createObjectNode();
        ObjectNode dependencies = JacksonUtils.createObjectNode();
        packageJson.set("dependencies", (JsonNode)dependencies);
        ObjectNode vaadinDependencies = JacksonUtils.createObjectNode();
        vaadinDependencies.set("dependencies", (JsonNode)JacksonUtils.createObjectNode());
        packageJson.set("vaadin", (JsonNode)vaadinDependencies);
        String pkg = "mypackage";
        String existingVersion = "./some/path";
        dependencies.put(pkg, existingVersion);
        this.nodeUpdater.addDependency(packageJson, "dependencies", pkg, existingVersion);
        Assert.assertEquals((Object)existingVersion, (Object)packageJson.get("dependencies").get(pkg).textValue());
    }

    @Test
    public void getJsonFileContent_incorrectPackageJsonContent_throwsExceptionWithFileName() throws IOException {
        File brokenPackageJsonFile = this.temporaryFolder.newFile("broken-package.json");
        FileUtils.writeStringToFile((File)brokenPackageJsonFile, (String)"{ some broken json ", (Charset)StandardCharsets.UTF_8);
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> NodeUpdater.getJsonFileContent((File)brokenPackageJsonFile));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)StringContains.containsString((String)"Cannot parse package file "));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)StringContains.containsString((String)"broken-package.json"));
    }

    @Test
    @Ignore(value="Can be removed if we agree on ignoring potential issues in [23 + webpack] -> [25] upgrades")
    public void removedAllOldAndExistingPlugins() throws IOException {
        File packageJson = new File(this.npmFolder, "package.json");
        FileWriter packageJsonWriter = new FileWriter(packageJson);
        packageJsonWriter.write("{\n  \"devDependencies\": {\n    \"@vaadin/some-old-plugin\": \"./target/plugins/some-old-plugin\",\n    \"@vaadin/application-theme-plugin\": \"./target/plugins/application-theme-plugin\"\n  }\n}\n");
        packageJsonWriter.close();
        ObjectNode actualDevDeps = (ObjectNode)this.nodeUpdater.getPackageJson().get("devDependencies");
        Assert.assertFalse((boolean)actualDevDeps.has("@vaadin/some-old-plugin"));
        Assert.assertFalse((boolean)actualDevDeps.has("@vaadin/application-theme-plugin"));
    }

    @Test
    public void generateVersionsJson_noVersions_noDevDeps_versionsGeneratedFromPackageJson() throws IOException {
        this.nodeUpdater.generateVersionsJson(JacksonUtils.createObjectNode());
        Assert.assertEquals((Object)"{}", (Object)this.nodeUpdater.versionsJson.toString());
    }

    @Test
    public void generateVersionsJson_versionsGeneratedFromPackageJson_containsBothDepsAndDevDeps() throws IOException {
        File packageJson = new File(this.npmFolder, "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"vaadin\": {\n    \"dependencies\": {\n      \"lit\": \"2.0.0\",\n      \"@vaadin/router\": \"1.7.5\",\n      \"@polymer/polymer\": \"3.4.1\"\n    },\n    \"devDependencies\": {\n      \"css-loader\": \"4.2.1\",\n      \"file-loader\": \"6.1.0\"\n    }\n  },\n  \"dependencies\": {\n    \"lit\": \"2.0.0\",\n    \"@vaadin/router\": \"1.7.5\",\n    \"@polymer/polymer\": \"3.4.1\"\n  },\n  \"devDependencies\": {\n    \"css-loader\": \"4.2.1\",\n    \"file-loader\": \"6.1.0\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        this.nodeUpdater.generateVersionsJson(JacksonUtils.readTree((String)FileUtils.readFileToString((File)packageJson, (Charset)StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)"{\"lit\":\"2.0.0\",\"@vaadin/router\":\"1.7.5\",\"@polymer/polymer\":\"3.4.1\"}", (Object)this.nodeUpdater.versionsJson.toString());
    }

    @Test
    public void testGetPlatformPinnedDependencies_vaadinCoreVersionIsNotPresent_outputIsEmptyJson() throws IOException {
        Logger logger = (Logger)Mockito.spy(Logger.class);
        try (MockedStatic loggerFactoryMocked = Mockito.mockStatic(LoggerFactory.class);){
            loggerFactoryMocked.when(() -> LoggerFactory.getLogger(this.nodeUpdater.getClass())).thenReturn((Object)logger);
            Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn(null);
            Mockito.when((Object)this.finder.getResource("vaadin-versions.json")).thenReturn(null);
            ObjectNode pinnedVersions = this.nodeUpdater.getPlatformPinnedDependencies();
            Assert.assertEquals((long)0L, (long)JacksonUtils.getKeys((JsonNode)pinnedVersions).size());
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).info("Couldn't find {} file to pin dependency versions for core components. Transitive dependencies won't be pinned for npm/pnpm/bun.", (Object)"vaadin-core-versions.json");
        }
    }

    @Test
    public void testGetPlatformPinnedDependencies_onlyVaadinCoreVersionIsPresent_outputContainsOnlyCoreVersions() throws IOException {
        File coreVersionsFile = File.createTempFile("vaadin-core-versions", ".json", this.temporaryFolder.newFolder());
        ObjectNode mockedVaadinCoreJson = this.getMockVaadinCoreVersionsJson();
        Assert.assertTrue((boolean)mockedVaadinCoreJson.has("core"));
        Assert.assertTrue((boolean)mockedVaadinCoreJson.get("core").has("button"));
        Assert.assertFalse((boolean)mockedVaadinCoreJson.has("vaadin"));
        FileUtils.write((File)coreVersionsFile, (CharSequence)mockedVaadinCoreJson.toString(), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)coreVersionsFile.toURI().toURL());
        Mockito.when((Object)this.finder.getResource("vaadin-versions.json")).thenReturn(null);
        ObjectNode pinnedVersions = this.nodeUpdater.getPlatformPinnedDependencies();
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/button"));
        Assert.assertFalse((boolean)pinnedVersions.has("@vaadin/grid-pro"));
        Assert.assertFalse((boolean)pinnedVersions.has("@vaadin/vaadin-grid-pro"));
    }

    @Test
    public void testGetPlatformPinnedDependencies_reactNotAvailable_noReactComponents() throws IOException {
        File coreVersionsFile = File.createTempFile("vaadin-core-versions", ".json", this.temporaryFolder.newFolder());
        ObjectNode mockedVaadinCoreJson = this.getMockVaadinCoreVersionsJson();
        ObjectNode reactComponents = JacksonUtils.createObjectNode();
        ObjectNode reactData = JacksonUtils.createObjectNode();
        reactData.put("jsVersion", "24.4.0-alpha13");
        reactData.put("npmName", "@vaadin/react-components");
        reactComponents.set("react-components", (JsonNode)reactData);
        mockedVaadinCoreJson.set("react", (JsonNode)reactComponents);
        Assert.assertTrue((boolean)mockedVaadinCoreJson.has("core"));
        Assert.assertTrue((boolean)mockedVaadinCoreJson.get("core").has("button"));
        Assert.assertFalse((boolean)mockedVaadinCoreJson.has("vaadin"));
        FileUtils.write((File)coreVersionsFile, (CharSequence)mockedVaadinCoreJson.toString(), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)coreVersionsFile.toURI().toURL());
        Mockito.when((Object)this.finder.getResource("vaadin-versions.json")).thenReturn(null);
        ObjectNode pinnedVersions = this.nodeUpdater.getPlatformPinnedDependencies();
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/button"));
        Assert.assertFalse((boolean)pinnedVersions.has("react-components"));
    }

    @Test
    public void testGetPlatformPinnedDependencies_reactAvailable_containsReactComponents() throws IOException, ClassNotFoundException {
        this.generateTestDataForReactComponents();
        ObjectNode pinnedVersions = this.nodeUpdater.getPlatformPinnedDependencies();
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/button"));
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/react-components"));
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/react-components-pro"));
    }

    @Test
    public void testGetPlatformPinnedDependencies_reactAvailable_excludeWebComponents() throws IOException, ClassNotFoundException {
        this.options.withNpmExcludeWebComponents(true);
        this.generateTestDataForReactComponents();
        ObjectNode pinnedVersions = this.nodeUpdater.getPlatformPinnedDependencies();
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/button"));
        Assert.assertFalse((boolean)pinnedVersions.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)pinnedVersions.has("@vaadin/react-components-pro"));
    }

    @Test
    public void testGetPlatformPinnedDependencies_reactDisabled_excludeWebComponents() throws IOException, ClassNotFoundException {
        this.options.withReact(false);
        this.options.withNpmExcludeWebComponents(true);
        this.generateTestDataForReactComponents();
        ObjectNode pinnedVersions = this.nodeUpdater.getPlatformPinnedDependencies();
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/button"));
        Assert.assertFalse((boolean)pinnedVersions.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)pinnedVersions.has("@vaadin/react-components-pro"));
    }

    private void generateTestDataForReactComponents() throws IOException, ClassNotFoundException {
        File coreVersionsFile = File.createTempFile("vaadin-core-versions", ".json", this.temporaryFolder.newFolder());
        File vaadinVersionsFile = File.createTempFile("vaadin-versions", ".json", this.temporaryFolder.newFolder());
        ObjectNode mockedVaadinCoreJson = this.getMockVaadinCoreVersionsJson();
        ObjectNode reactComponents = JacksonUtils.createObjectNode();
        ObjectNode reactData = JacksonUtils.createObjectNode();
        reactData.put("jsVersion", "24.4.0-alpha13");
        reactData.put("npmName", "@vaadin/react-components");
        reactData.put("mode", "react");
        reactComponents.set("react-components", (JsonNode)reactData);
        mockedVaadinCoreJson.set("react", (JsonNode)reactComponents);
        Assert.assertTrue((boolean)mockedVaadinCoreJson.has("core"));
        Assert.assertTrue((boolean)mockedVaadinCoreJson.get("core").has("button"));
        Assert.assertFalse((boolean)mockedVaadinCoreJson.has("vaadin"));
        ObjectNode mockedVaadinJson = this.getMockVaadinVersionsJson();
        reactComponents = JacksonUtils.createObjectNode();
        reactData = JacksonUtils.createObjectNode();
        reactData.put("jsVersion", "24.4.0-alpha13");
        reactData.put("npmName", "@vaadin/react-components-pro");
        reactData.put("mode", "react");
        reactComponents.set("react-components-pro", (JsonNode)reactData);
        mockedVaadinJson.set("react", (JsonNode)reactComponents);
        FileUtils.write((File)coreVersionsFile, (CharSequence)mockedVaadinCoreJson.toString(), (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)vaadinVersionsFile, (CharSequence)mockedVaadinJson.toString(), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)coreVersionsFile.toURI().toURL());
        Mockito.when((Object)this.finder.getResource("vaadin-versions.json")).thenReturn((Object)vaadinVersionsFile.toURI().toURL());
        Class<FeatureFlags> clazz = FeatureFlags.class;
        ((ClassFinder)Mockito.doReturn(clazz).when((Object)this.finder)).loadClass("com.vaadin.flow.component.react.ReactAdapterComponent");
    }

    @Test
    public void testGetPlatformPinnedDependencies_VaadinAndVaadinCoreVersionsArePresent_outputContainsBothCoreAndCommercialVersions() throws IOException {
        File coreVersionsFile = File.createTempFile("vaadin-core-versions", ".json", this.temporaryFolder.newFolder());
        ObjectNode mockedVaadinCoreJson = this.getMockVaadinCoreVersionsJson();
        Assert.assertTrue((boolean)mockedVaadinCoreJson.has("core"));
        Assert.assertTrue((boolean)mockedVaadinCoreJson.get("core").has("button"));
        Assert.assertFalse((boolean)mockedVaadinCoreJson.has("vaadin"));
        FileUtils.write((File)coreVersionsFile, (CharSequence)mockedVaadinCoreJson.toString(), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)coreVersionsFile.toURI().toURL());
        File vaadinVersionsFile = File.createTempFile("vaadin-versions", ".json", this.temporaryFolder.newFolder());
        ObjectNode mockedVaadinJson = this.getMockVaadinVersionsJson();
        Assert.assertFalse((boolean)mockedVaadinJson.has("core"));
        Assert.assertTrue((boolean)mockedVaadinJson.has("vaadin"));
        Assert.assertTrue((boolean)mockedVaadinJson.get("vaadin").has("grid-pro"));
        Assert.assertTrue((boolean)mockedVaadinJson.get("vaadin").has("vaadin-grid-pro"));
        FileUtils.write((File)vaadinVersionsFile, (CharSequence)mockedVaadinJson.toString(), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.finder.getResource("vaadin-versions.json")).thenReturn((Object)vaadinVersionsFile.toURI().toURL());
        ObjectNode pinnedVersions = this.nodeUpdater.getPlatformPinnedDependencies();
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/button"));
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/grid-pro"));
        Assert.assertTrue((boolean)pinnedVersions.has("@vaadin/vaadin-grid-pro"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getDefaultDependencies_reactIsUsed_addsHillaReactComponents() {
        boolean reactEnabled = this.options.isReactEnabled();
        MockedStatic mockFrontendUtils = Mockito.mockStatic(FrontendUtils.class);
        MockedStatic mockFrontendBuildUtils = Mockito.mockStatic(FrontendBuildUtils.class);
        try {
            mockFrontendBuildUtils.when(() -> FrontendBuildUtils.isHillaUsed((File)((File)Mockito.any(File.class)), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)true);
            mockFrontendUtils.when(() -> FrontendUtils.isReactRouterRequired((File)((File)Mockito.any(File.class)))).thenReturn((Object)true);
            this.options.withReact(true);
            Map defaultDeps = this.nodeUpdater.getDefaultDependencies();
            Assert.assertFalse((String)"Lit component added unexpectedly for react-router", (boolean)defaultDeps.containsKey("@vaadin/hilla-lit-form"));
            Assert.assertTrue((String)"React component should be added when react-router is used", (boolean)defaultDeps.containsKey("@vaadin/hilla-react-auth"));
            Assert.assertTrue((boolean)defaultDeps.containsKey("@vaadin/hilla-react-crud"));
            Assert.assertTrue((boolean)defaultDeps.containsKey("@vaadin/hilla-react-form"));
            Map defaultDevDeps = this.nodeUpdater.getDefaultDevDependencies();
            Assert.assertFalse((String)"Lit dev dependency added unexpectedly for react-router", (boolean)defaultDevDeps.containsKey("lit-dev-dependency"));
            Assert.assertTrue((String)"React dev dependency should be added when react-router is used", (boolean)defaultDevDeps.containsKey("react-dev-dependency"));
        }
        finally {
            this.options.withReact(reactEnabled);
            mockFrontendUtils.close();
            mockFrontendBuildUtils.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getDefaultDependencies_vaadinRouterIsUsed_addsHillaLitComponents() {
        boolean reactEnabled = this.options.isReactEnabled();
        try (MockedStatic mock = Mockito.mockStatic(FrontendBuildUtils.class);){
            mock.when(() -> FrontendBuildUtils.isHillaUsed((File)((File)Mockito.any(File.class)), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)true);
            this.options.withReact(false);
            Map defaultDeps = this.nodeUpdater.getDefaultDependencies();
            Assert.assertTrue((String)"Lit component should be when vaadin-router is used", (boolean)defaultDeps.containsKey("@vaadin/hilla-lit-form"));
            Assert.assertFalse((String)"React component added unexpectedly for vaadin-router", (boolean)defaultDeps.containsKey("@vaadin/hilla-react-form"));
            Map defaultDevDeps = this.nodeUpdater.getDefaultDevDependencies();
            Assert.assertFalse((String)"React dev dependency added unexpectedly for vaadin-router", (boolean)defaultDevDeps.containsKey("react-dev-dependency"));
            Assert.assertTrue((String)"Lit dev dependency should be added when vaadin-router is used", (boolean)defaultDevDeps.containsKey("lit-dev-dependency"));
        }
        finally {
            this.options.withReact(reactEnabled);
        }
    }

    @Test
    public void getDefaultDependencies_hillaIsNotUsed_doesntAddHillaComponents() {
        Map defaultDeps = this.nodeUpdater.getDefaultDependencies();
        Assert.assertFalse((String)"Lit component added unexpectedly when Hilla isn't used", (boolean)defaultDeps.containsKey("@vaadin/hilla-lit-form"));
        Assert.assertFalse((String)"React component added unexpectedly when Hilla isn't used", (boolean)defaultDeps.containsKey("@vaadin/hilla-react-auth"));
        Map defaultDevDeps = this.nodeUpdater.getDefaultDevDependencies();
        Assert.assertFalse((String)"React dev dependency added unexpectedly when Hilla isn't used", (boolean)defaultDevDeps.containsKey("react-dev-dependency"));
        Assert.assertFalse((String)"Lit dev dependency added unexpectedly when Hilla isn't used", (boolean)defaultDevDeps.containsKey("lit-dev-dependency"));
    }

    @Test
    public void getDefaultDevDependencies_includesWorkbox_whenPwaEnabled() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        PwaConfiguration pwaConfig = (PwaConfiguration)Mockito.mock(PwaConfiguration.class);
        Mockito.when((Object)pwaConfig.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)frontendDependencies.getPwaConfiguration()).thenReturn((Object)pwaConfig);
        this.nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)frontendDependencies, this.options){

            public void execute() {
            }
        };
        Map defaultDevDeps = this.nodeUpdater.getDefaultDevDependencies();
        Assert.assertTrue((String)"workbox-core should be included when PWA is enabled", (boolean)defaultDevDeps.containsKey("workbox-core"));
        Assert.assertTrue((String)"workbox-precaching should be included when PWA is enabled", (boolean)defaultDevDeps.containsKey("workbox-precaching"));
    }

    @Test
    public void getDefaultDevDependencies_excludesWorkbox_whenPwaDisabled() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        PwaConfiguration pwaConfig = (PwaConfiguration)Mockito.mock(PwaConfiguration.class);
        Mockito.when((Object)pwaConfig.isEnabled()).thenReturn((Object)false);
        Mockito.when((Object)frontendDependencies.getPwaConfiguration()).thenReturn((Object)pwaConfig);
        this.nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)frontendDependencies, this.options){

            public void execute() {
            }
        };
        Map defaultDevDeps = this.nodeUpdater.getDefaultDevDependencies();
        Assert.assertFalse((String)"workbox-core should not be included when PWA is disabled", (boolean)defaultDevDeps.containsKey("workbox-core"));
        Assert.assertFalse((String)"workbox-precaching should not be included when PWA is disabled", (boolean)defaultDevDeps.containsKey("workbox-precaching"));
    }

    @Test
    public void getDefaultDevDependencies_excludesWorkbox_whenPwaNull() {
        FrontendDependencies frontendDependencies = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        Mockito.when((Object)frontendDependencies.getPwaConfiguration()).thenReturn(null);
        this.nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)frontendDependencies, this.options){

            public void execute() {
            }
        };
        Map defaultDevDeps = this.nodeUpdater.getDefaultDevDependencies();
        Assert.assertFalse((String)"workbox-core should not be included when PWA is null", (boolean)defaultDevDeps.containsKey("workbox-core"));
        Assert.assertFalse((String)"workbox-precaching should not be included when PWA is null", (boolean)defaultDevDeps.containsKey("workbox-precaching"));
    }

    @Test
    public void readPackageJson_nonExistingFile_doesNotThrow() throws IOException {
        this.nodeUpdater.readPackageJson("non-existing-folder");
    }

    @Test
    public void readPackageJson_nonExistingFile_jsonContainsDepsAndDevDeps() throws IOException {
        JsonNode jsonObject = this.nodeUpdater.readPackageJson("non-existing-folder");
        Assert.assertTrue((boolean)jsonObject.has("dependencies"));
        Assert.assertTrue((boolean)jsonObject.has("devDependencies"));
    }

    @Test
    public void readDependencies_doesntHaveDependencies_doesNotThrow() {
        this.nodeUpdater.readDependencies("no-deps", "dependencies");
        this.nodeUpdater.readDependencies("no-deps", "devDependencies");
    }

    @Test
    public void readPackageJsonIfAvailable_nonExistingFile_noErrorLog() {
        final Logger log = (Logger)Mockito.mock(Logger.class);
        this.nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)Mockito.mock(FrontendDependencies.class), this.options){

            public void execute() {
            }

            Logger log() {
                return log;
            }
        };
        this.nodeUpdater.readDependenciesIfAvailable("non-existing-folder", "dependencies");
        Mockito.verifyNoInteractions((Object[])new Object[]{log});
        this.nodeUpdater.readDependenciesIfAvailable("non-existing-folder", "devDpendencies");
        Mockito.verifyNoInteractions((Object[])new Object[]{log});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getDefaultDependencies_hillaAvailableButNotUsed_addsGeneratorDependencies() {
        boolean reactEnabled = this.options.isReactEnabled();
        try (MockedStatic frontendBuildUtilsMock = Mockito.mockStatic(FrontendBuildUtils.class);
             MockedStatic frontendUtilsMock = Mockito.mockStatic(FrontendUtils.class);
             MockedStatic endpointUtilMock = Mockito.mockStatic(EndpointRequestUtil.class);){
            frontendBuildUtilsMock.when(() -> FrontendBuildUtils.isHillaUsed((File)((File)Mockito.any(File.class)), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)false);
            endpointUtilMock.when(EndpointRequestUtil::isHillaAvailable).thenReturn((Object)true);
            frontendUtilsMock.when(() -> FrontendUtils.isReactRouterRequired((File)((File)Mockito.any(File.class)))).thenReturn((Object)true);
            NodeUpdater spyNodeUpdater = (NodeUpdater)Mockito.spy((Object)this.nodeUpdater);
            Map<String, String> mockGeneratorDeps = Map.of("@vaadin/hilla-generator-core", "2.0.0");
            ((NodeUpdater)Mockito.doReturn(mockGeneratorDeps).when((Object)spyNodeUpdater)).readDependenciesIfAvailable(Mockito.anyString(), (String)Mockito.eq((Object)"dependencies"), (String)Mockito.eq((Object)"@vaadin/hilla-generator-"));
            this.options.withReact(true);
            Map defaultDeps = spyNodeUpdater.getDefaultDependencies();
            Assert.assertTrue((String)"React generator dependency should be added when Hilla is available", (boolean)defaultDeps.keySet().stream().anyMatch(key -> key.contains("@vaadin/hilla-generator-")));
            this.options.withReact(false);
            defaultDeps = spyNodeUpdater.getDefaultDependencies();
            Assert.assertTrue((String)"Lit generator dependency should be added when Hilla is available", (boolean)defaultDeps.keySet().stream().anyMatch(key -> key.contains("@vaadin/hilla-generator-")));
        }
        finally {
            this.options.withReact(reactEnabled);
        }
    }

    private String getPolymerVersion(JsonNode object) {
        JsonNode deps = object.get("dependencies");
        return deps.get("@polymer/polymer").textValue();
    }

    private void fakePolymerTemplateInClasspath() {
        Class<FeatureFlags> clazz = FeatureFlags.class;
        try {
            ((ClassFinder)Mockito.doReturn(clazz).when((Object)this.finder)).loadClass("com.vaadin.flow.component.polymertemplate.PolymerTemplate");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectNode getMockVaadinCoreVersionsJson() {
        return JacksonUtils.readTree((String)"{\n    \"core\": {\n        \"accordion\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/accordion\"\n        },\n        \"app-layout\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/app-layout\"\n        },\n        \"avatar\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/avatar\"\n        },\n        \"avatar-group\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/avatar-group\"\n        },\n        \"button\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/button\"\n        },\n        \"checkbox\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/checkbox\"\n        }\n    },\n    \"platform\": \"23.2.0\"\n}\n");
    }

    private ObjectNode getMockVaadinVersionsJson() {
        return JacksonUtils.readTree((String)"{\n    \"vaadin\": {\n        \"board\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/board\"\n        },\n        \"charts\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/charts\"\n        },\n        \"grid-pro\": {\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/grid-pro\"\n        },\n        \"vaadin-board\": {\n            \"component\": true,\n            \"javaVersion\": \"23.2.0\",\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/vaadin-board\",\n            \"pro\": true\n        },\n        \"vaadin-charts\": {\n            \"component\": true,\n            \"javaVersion\": \"23.2.0\",\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/vaadin-charts\",\n            \"pro\": true\n        },\n        \"vaadin-grid-pro\": {\n            \"component\": true,\n            \"javaVersion\": \"23.2.0\",\n            \"jsVersion\": \"23.2.0\",\n            \"npmName\": \"@vaadin/vaadin-grid-pro\",\n            \"pro\": true\n        }\n    },\n    \"platform\": \"23.2.0\"\n}\n");
    }
}

