/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;

public class NodeUpdateTestUtil {
    static ClassFinder getClassFinder() throws MalformedURLException {
        return new ClassFinder.DefaultClassFinder((ClassLoader)new URLClassLoader(NodeUpdateTestUtil.getClassPath()), (Class[])NodeTestComponents.class.getDeclaredClasses());
    }

    static ClassFinder getClassFinder(Class<?> ... classes) throws MalformedURLException {
        return new ClassFinder.DefaultClassFinder((ClassLoader)new URLClassLoader(NodeUpdateTestUtil.getClassPath()), (Class[])classes);
    }

    static URL[] getClassPath() throws MalformedURLException {
        URL[] urls;
        ArrayList<URL> classPaths = new ArrayList<URL>();
        classPaths.add(new File("target/test-classes").toURI().toURL());
        URL jar = NodeUpdateTestUtil.getTestResource("jar-with-frontend-resources.jar");
        classPaths.add(jar);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        for (URL url : urls = URLClassLoader.newInstance(new URL[0], classLoader).getURLs()) {
            classPaths.add(url);
        }
        return classPaths.toArray(new URL[0]);
    }

    static URL getTestResource(String resourceName) {
        URL resourceUrl = NodeUpdateTestUtil.class.getClassLoader().getResource(resourceName);
        Assert.assertNotNull((String)String.format("Expect the test resource to be present in test resource folder with name = '%s'", resourceName), (Object)resourceUrl);
        return resourceUrl;
    }

    void sleep(int ms) throws InterruptedException {
        Thread.sleep(ms);
    }

    List<String> getExpectedImports() {
        return Arrays.asList("@polymer/iron-icon/iron-icon.js", "@vaadin/vaadin-lumo-styles/spacing.js", "@vaadin/vaadin-lumo-styles/icons.js", "@vaadin/vaadin-lumo-styles/style.js", "@vaadin/vaadin-lumo-styles/typography.js", "@vaadin/vaadin-lumo-styles/typography-global.js", "@vaadin/vaadin-lumo-styles/color.js", "@vaadin/vaadin-lumo-styles/color-global.js", "@vaadin/vaadin-lumo-styles/sizing.js", "@vaadin/vaadin-date-picker/src/vaadin-date-picker.js", "@vaadin/vaadin-date-picker/src/vaadin-month-calendar.js", "@vaadin/vaadin-element-mixin/vaadin-element-mixin.js", "@vaadin/vaadin-mixed-component/src/vaadin-mixed-component.js", "@vaadin/vaadin-mixed-component/src/vaadin-something-else.js", "@vaadin/vaadin-mixed-component/src/vaadin-custom-themed-component.js", "./generated/jar-resources/ExampleConnector.js", "3rdparty/component.js", "./local-p3-template.js", "./foo.js", "./vaadin-mixed-component/src/vaadin-mixed-component.js", "./local-template.js", "./foo-dir/vaadin-npm-component.js", "./foo.css", "@vaadin/vaadin-mixed-component/bar.css", "./common-js-file.js", "@vaadin/example-flag/experimental-module-1.js", "@vaadin/example-flag/experimental-module-2.js", "experimental-Connector.js");
    }

    void createExpectedImports(File directoryWithImportsJs, File nodeModulesPath) throws IOException {
        for (String expectedImport : this.getExpectedImports()) {
            this.createExpectedImport(directoryWithImportsJs, nodeModulesPath, expectedImport);
        }
    }

    void createExpectedImport(File directoryWithImportsJs, File nodeModulesPath, String expectedImport) throws IOException {
        File newFile = this.resolveImportFile(directoryWithImportsJs, nodeModulesPath, expectedImport);
        newFile.getParentFile().mkdirs();
        Assert.assertTrue((boolean)newFile.createNewFile());
    }

    void deleteExpectedImports(File directoryWithImportsJs, File nodeModulesPath) {
        for (String expectedImport : this.getExpectedImports()) {
            Assert.assertTrue((boolean)this.resolveImportFile(directoryWithImportsJs, nodeModulesPath, expectedImport).delete());
        }
    }

    File resolveImportFile(File directoryWithImportsJs, File nodeModulesPath, String jsImport) {
        File root = jsImport.startsWith("./") ? directoryWithImportsJs : nodeModulesPath;
        return new File(root, jsImport);
    }

    String addFrontendAlias(String s) {
        if (s.startsWith("./")) {
            return "Frontend/" + s.substring(2);
        }
        return s;
    }
}

