/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.Theme;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class NodeTestComponents
extends NodeUpdateTestUtil {
    public static final String BUTTON_COMPONENT_FQN = ButtonComponent.class.getName();
    public static final String ICON_COMPONENT_FQN = IconComponent.class.getName();

    @NpmPackage.Container(value={@NpmPackage(value="@vaadin/vaadin-button", version="1.1.1", assets={"img/arrow*:img"}), @NpmPackage(value="vite-plugin-pwa", version="0.16.5", dev=true, assets={"frown/**:pwa"})})
    class ButtonComponent
    extends Component {
        ButtonComponent() {
        }
    }

    @JsModule(value="@polymer/iron-icon/iron-icon.js")
    class IconComponent
    extends Component {
        IconComponent() {
        }
    }

    @JavaScript.Container(value={@JavaScript(value="javascript/a.js"), @JavaScript(value="javascript/b.js"), @JavaScript(value="javascript/c.js")})
    @JsModule.Container(value={@JsModule(value="jsmodule/h.js"), @JsModule(value="jsmodule/g.js")})
    public static class JavaScriptOrder
    extends Component {
    }

    @NpmPackage(value="@webcomponents/webcomponentsjs", version="2.2.10")
    public static class ExtraImport {
    }

    @JsModule.Container(value={@JsModule(value="@vaadin/vaadin-lumo-styles/color.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/color-global.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/typography.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/typography-global.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/sizing.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/spacing.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/style.js"), @JsModule(value="@vaadin/vaadin-lumo-styles/icons.js")})
    @CssImport(value="lumo-css-import.css")
    public static class LumoTest
    implements AbstractTheme {
        public static final String LIGHT = "light";
        public static final String DARK = "dark";

        public String getBaseUrl() {
            return "src/";
        }

        public String getThemeUrl() {
            return "theme/lumo/";
        }

        public List<String> getHeaderInlineContents() {
            return Collections.singletonList("<custom-style>\n    <style include=\"lumo-color lumo-typography\"></style>\n</custom-style>");
        }

        public Map<String, String> getHtmlAttributes(String variant) {
            if (variant.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, String> attributes = new HashMap<String, String>(1);
            switch (variant) {
                case "light": {
                    attributes.put("theme", LIGHT);
                    break;
                }
                case "dark": {
                    attributes.put("theme", DARK);
                    break;
                }
                default: {
                    LoggerFactory.getLogger((String)LumoTest.class.getName()).warn("Lumo theme variant not recognized: '{}'. Using no variant.", (Object)variant);
                }
            }
            return attributes;
        }
    }

    @Route(value="", layout=MainLayout.class)
    public static class MainView
    extends Component {
        ButtonComponent buttonComponent;
        IconComponent iconComponent;
        VaadinBowerComponent vaadinBowerComponent;
        VaadinElementMixin vaadinElementMixin;
        VaadinNpmComponent vaadinNpmComponent;
        VaadinMixedComponent vaadinMixedComponent;
        LocalTemplate localP2Template;
        LocalP3Template localP3Template;
        UnresolvedComponent frontendP3Template;
        FlatImport flatImport;
        TranslatedImports translatedImports;
        JavaScriptOrder order;
    }

    @JsModule(value="./common-js-file.js")
    @Theme(themeClass=LumoTest.class, variant="dark")
    @Route
    public static class MainLayout
    implements RouterLayout {
        public Element getElement() {
            return null;
        }
    }

    @Route
    public static class ReferenceView
    extends Component {
        VaadinBowerComponent vaadinBowerComponent;
    }

    @JsModule.Container(value={@JsModule(value="@vaadin/vaadin-mixed-component/src/vaadin-mixed-component.js"), @JsModule(value="@vaadin/vaadin-mixed-component/src/vaadin-something-else.js"), @JsModule(value="@vaadin/vaadin-mixed-component/src/vaadin-something-else"), @JsModule(value="@vaadin/vaadin-mixed-component/src/vaadin-custom-themed-component.js")})
    public static class TranslatedImports
    extends Component {
    }

    @JsModule(value="./foo.js")
    @CssImport.Container(value={@CssImport(value="@vaadin/vaadin-mixed-component/bar.css"), @CssImport(value="./foo.css"), @CssImport(value="./foo.css"), @CssImport(value="./foo.css", include="bar"), @CssImport(value="./foo.css", id="baz"), @CssImport(value="./foo.css", id="baz", include="bar"), @CssImport(value="./foo.css", themeFor="foo-bar"), @CssImport(value="./foo.css", themeFor="foo-bar", include="bar")})
    public static class FlatImport
    extends Component {
    }

    @Route(value="flag-view")
    public static class FlagView
    extends Component {
        ExampleExperimentalComponent component;
    }

    @JsModule.Container(value={@JsModule(value="@vaadin/example-flag/experimental-module-1.js"), @JsModule(value="@vaadin/example-flag/experimental-module-2.js")})
    @JavaScript(value="experimental-Connector.js")
    @Tag(value="example-experimental-component")
    public static class ExampleExperimentalComponent
    extends Component {
    }

    @JsModule(value="unresolved/component")
    public static class UnresolvedComponent
    extends Component {
    }

    @JsModule(value="./local-p3-template.js")
    @NpmPackage(value="@foo/var-component", version="1.1.0")
    public static class LocalP3Template
    extends Component {
    }

    @JsModule.Container(value={@JsModule(value="./local-template.js"), @JsModule(value="3rdparty/component.js")})
    public static class LocalTemplate
    extends Component {
    }

    @JsModule(value="vaadin-mixed-component/src/vaadin-mixed-component.js")
    public static class VaadinMixedComponent
    extends Component {
    }

    @JsModule(value="./foo-dir/vaadin-npm-component.js")
    public static class VaadinNpmComponent
    extends Component {
    }

    @NpmPackage(value="@vaadin/vaadin-element-mixin", version="1.1.2")
    @JsModule(value="@vaadin/vaadin-element-mixin/vaadin-element-mixin.js")
    public static class VaadinElementMixin
    extends Component {
    }

    @JsModule.Container(value={@JsModule(value="@vaadin/vaadin-date-picker/src/vaadin-date-picker.js"), @JsModule(value="@vaadin/vaadin-date-picker/src/vaadin-month-calendar.js")})
    @JavaScript(value="ExampleConnector.js")
    public static class VaadinBowerComponent
    extends Component {
    }

    @Tag(value="div")
    @NpmPackage(value="images", version="1.1.1", assets={"images/28x28/**:28x28"})
    public static class DuplicatedAssets
    extends Component {
    }

    @NpmPackage(value="images", version="1.1.1", assets={"images/22x25/**:22x25"})
    @Tag(value="div")
    public static class Assets
    extends Component {
    }

    @LoadDependenciesOnStartup
    public static class AllEager
    implements AppShellConfigurator {
    }
}

